/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.FilterValueField;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.ValidProperty;
import java.math.BigDecimal;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.TextField;

public class LongDisplayValueFilterValueField
extends FilterValueField<LongDisplayValue> {
    private final ObjectProperty<LongDisplayValue> value;
    private final TextField textField = new TextField();
    private final ValidProperty valid = new ValidProperty(this.textField);

    public LongDisplayValueFilterValueField() {
        this.value = new SimpleObjectProperty<LongDisplayValue>();
        this.valid.set(false);
        this.textField.textProperty().addListener(this::textChanged);
        this.textField.setAlignment(Pos.CENTER_LEFT);
        this.setCenter(this.textField);
    }

    private void textChanged(ObservableValue<? extends String> paramObservableValue, String oldValue, String newValue) {
        try {
            if (newValue != null) {
                BigDecimal convertedValue = Util.parse(newValue);
                this.setValue(new LongDisplayValue(convertedValue));
            } else {
                this.setValue((LongDisplayValue)null);
            }
            this.valid.set(true);
        }
        catch (NumberFormatException e) {
            this.setValue((LongDisplayValue)null);
            this.valid.set(false);
        }
    }

    @Override
    public ReadOnlyBooleanProperty validProperty() {
        return this.valid;
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }

    @Override
    public LongDisplayValue getValue() {
        return (LongDisplayValue)this.value.get();
    }

    @Override
    public void setValue(LongDisplayValue value) {
        this.value.setValue(value);
        if (value != null) {
            this.textField.setText(value.toString());
        }
    }
}

