/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.customization.common;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ButtonWithIcon;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.column.ColumnToolbarMenuTable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.common.ToolbarMenuTable;
import com.deutscheboerse.comxerv.comtrader.jfx.util.TooltipUtils;
import com.deutscheboerse.comxerv.comtrader.jfx.util.UtilityStages;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.inject.Inject;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import org.apache.commons.lang3.StringUtils;

public class ToolbarPopup
extends BorderPane {
    private final Stage stage;
    private final ToolbarMenuTable<?> toolbarMenuTable;
    @FXML
    private GridPane searchPane;
    @FXML
    private TextField searchText;
    @FXML
    private ButtonWithIcon searchButton;
    @FXML
    private Label hintLabel;

    @Inject
    public ToolbarPopup(ApplicationContext appContext, ToolbarMenuTable<?> toolbarMenuTable, String hintDescription) {
        this.toolbarMenuTable = toolbarMenuTable;
        this.stage = appContext.getService(UtilityStages.class).withKey(ToolbarPopup.class.getName()).get();
        this.stage.setOnHidden(event -> this.stage.setScene(null));
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        this.setCenter(toolbarMenuTable);
        this.hintLabel.setText(hintDescription);
        if (toolbarMenuTable instanceof ColumnToolbarMenuTable) {
            TooltipUtils.setTooltip(this.searchButton, Util.getLabel("toolbarPopup_search_button"));
        } else {
            this.searchPane.getChildren().remove(this.searchText);
            this.searchPane.getChildren().remove(this.searchButton);
        }
    }

    @FXML
    public void addSeparator() {
        this.toolbarMenuTable.addSeparator();
    }

    @FXML
    public void close() {
        this.stage.close();
    }

    public void show(String title) {
        this.stage.setScene(new Scene(this));
        this.stage.setTitle(title);
        this.stage.show();
        this.stage.toFront();
    }

    @FXML
    public void search() {
        String text = this.searchText.getText();
        this.toolbarMenuTable.setPredicate(rowData -> {
            if (StringUtils.isEmpty(text)) {
                return true;
            }
            return rowData.getDescription() != null && rowData.getDescription().contains(text);
        });
    }
}

