/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.filter;

import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.FilteredTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.RelevantEntitiesProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.TableView;

public class OrderFilteredTableView
extends FilteredTableView<Order> {
    private final BooleanProperty anyActiveOrder = new SimpleBooleanProperty(false);
    private Map<Order, OrderStatus> orderStatusMap = new HashMap<Order, OrderStatus>();
    private long activeOrders;

    public OrderFilteredTableView(TableView<Order> tableView, Predicate<Order> baseFilter, RelevantEntitiesProvider<Order> relevantEntitiesProvider) {
        super(tableView, baseFilter, relevantEntitiesProvider, false);
        relevantEntitiesProvider.registerDataModelListener(this);
    }

    public BooleanProperty anyActiveOrderProperty() {
        return this.anyActiveOrder;
    }

    private void incrementActiveOrders() {
        ++this.activeOrders;
        this.anyActiveOrder.setValue(true);
    }

    private void decrementActiveOrders() {
        --this.activeOrders;
        this.anyActiveOrder.setValue(this.activeOrders != 0L);
    }

    @Override
    protected boolean addVisibleItem(Order item) {
        OrderStatus oldStatus = this.orderStatusMap.put(item, item.getStatus());
        if (oldStatus == null) {
            if (item.getStatus() == OrderStatus.ACTIVE) {
                this.incrementActiveOrders();
            }
            return true;
        }
        if (oldStatus != OrderStatus.ACTIVE && item.getStatus() == OrderStatus.ACTIVE) {
            this.incrementActiveOrders();
        } else if (oldStatus == OrderStatus.ACTIVE && item.getStatus() != OrderStatus.ACTIVE) {
            this.decrementActiveOrders();
        }
        return false;
    }

    @Override
    protected boolean removeVisibleItem(Order item) {
        OrderStatus oldStatus = this.orderStatusMap.remove(item);
        if (oldStatus == OrderStatus.ACTIVE) {
            this.decrementActiveOrders();
        }
        return oldStatus != null;
    }

    @Override
    protected boolean removeVisibleItems(Collection<Order> items) {
        boolean anyRemoved = false;
        for (Order order : items) {
            anyRemoved |= this.removeVisibleItem(order);
        }
        return anyRemoved;
    }

    @Override
    protected void clearVisibleItems() {
        this.orderStatusMap.clear();
        this.activeOrders = 0L;
        this.anyActiveOrder.setValue(false);
    }
}

