/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.filter.column;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.DateTimeColumFilterValue;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.DateTimeFilterValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.DateTimeRangeFilterValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.FilterValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ColumnFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.PredicateType;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.google.common.collect.Lists;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;

public class DateTimeColumnFilter<S extends BroadcastEntity>
implements ColumnFilter<DateTime, DateTimeColumFilterValue> {
    private final ApplicationContext applicationContext;
    private final LocalService localService;

    public DateTimeColumnFilter() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public DateTimeColumnFilter(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.localService = applicationContext.getService(LocalService.class);
    }

    @Override
    public List<PredicateType> getPredicateTypes() {
        return Lists.newArrayList(PredicateType.EQUAL, PredicateType.NOT_EQUAL, PredicateType.LOWER, PredicateType.LOWER_EQUAL, PredicateType.GREATER, PredicateType.GREATER_EQUAL, PredicateType.IS_EMPTY, PredicateType.IS_NOT_EMPTY, PredicateType.IN_RANGE);
    }

    @Override
    public FilterValueField<DateTimeColumFilterValue> getValueField(PredicateType predicateType) {
        switch (predicateType) {
            case IN_RANGE: {
                return new DateTimeRangeFilterValueField(this.applicationContext);
            }
            case IS_EMPTY: {
                return null;
            }
            case IS_NOT_EMPTY: {
                return null;
            }
        }
        return new DateTimeFilterValueField(this.localService);
    }

    @Override
    public boolean matches(PredicateType predicateType, DateTime cellValue, DateTimeColumFilterValue filterValue) {
        DateTime cellValueRounded = cellValue != null ? cellValue.withMillisOfSecond(0) : null;
        LocalDateTime filterValueRounded = filterValue != null && filterValue.getLocalDateTime() != null ? filterValue.getLocalDateTime().withMillisOfSecond(0) : null;
        DateTime now = DateTime.now();
        DateTime rangeStart = filterValue != null && filterValue.getRange() != null ? filterValue.getRange().getStartTime(now) : null;
        DateTime rangeEnd = filterValue != null && filterValue.getRange() != null ? filterValue.getRange().getEndTime(now) : null;
        switch (predicateType) {
            case EQUAL: {
                return cellValueRounded == null && filterValueRounded == null || cellValueRounded != null && filterValueRounded != null && cellValueRounded.toLocalDateTime().equals(filterValueRounded);
            }
            case NOT_EQUAL: {
                return !this.matches(PredicateType.EQUAL, cellValue, filterValue);
            }
            case LOWER: {
                return cellValueRounded != null && filterValueRounded != null && cellValueRounded.toLocalDateTime().compareTo(filterValueRounded) < 0;
            }
            case LOWER_EQUAL: {
                return cellValueRounded != null && filterValueRounded != null && cellValueRounded.toLocalDateTime().compareTo(filterValueRounded) <= 0;
            }
            case GREATER: {
                return cellValueRounded != null && filterValueRounded != null && cellValueRounded.toLocalDateTime().compareTo(filterValueRounded) > 0;
            }
            case GREATER_EQUAL: {
                return cellValueRounded != null && filterValueRounded != null && cellValueRounded.toLocalDateTime().compareTo(filterValueRounded) >= 0;
            }
            case IN_RANGE: {
                return cellValueRounded != null && rangeStart != null && rangeEnd != null && cellValueRounded.isAfter(rangeStart) && cellValueRounded.isBefore(rangeEnd);
            }
            case IS_EMPTY: {
                return cellValue == null;
            }
            case IS_NOT_EMPTY: {
                return cellValue != null;
            }
        }
        throw new IllegalArgumentException("Invalid predicate type");
    }
}

