/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.filter.column;

import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.EnumFilterValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.FilterValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ColumnFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.PredicateType;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumColumnFilter<T extends Enum>
implements ColumnFilter<T, T> {
    private static final Logger LOG = LoggerFactory.getLogger(EnumColumnFilter.class);
    private Class<T> enumClass;

    @Override
    public List<PredicateType> getPredicateTypes() {
        return Lists.newArrayList(PredicateType.EQUAL, PredicateType.NOT_EQUAL);
    }

    @Override
    public FilterValueField<T> getValueField(PredicateType predicateType) {
        return new EnumFilterValueField<T>(this.enumClass);
    }

    @Override
    public boolean matches(PredicateType predicateType, T cellValue, T filterValue) {
        switch (predicateType) {
            case EQUAL: {
                return Objects.equals(cellValue, filterValue);
            }
            case NOT_EQUAL: {
                return !Objects.equals(cellValue, filterValue);
            }
        }
        throw new IllegalArgumentException("Invalid predicate type");
    }

    public void setEnumClass(String nameClass) {
        try {
            this.enumClass = Class.forName(nameClass);
        }
        catch (ClassNotFoundException e) {
            LOG.error("", e);
        }
    }

    public String getEnumClass() {
        return this.enumClass.getName();
    }
}

