/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ui;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.AndTableFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.FilteredTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.TableFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.column.FilterableTableColumn;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.state.ColumnFilterState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ui.FilterRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;

public class FilterComponent<S extends BroadcastEntity>
extends BorderPane {
    private static final int MAX_ROW_COUNT = 20;
    private final ApplicationContext appContext;
    private final BooleanProperty valid = new SimpleBooleanProperty(false);
    private final FilteredTableView<S> filteredTableView;
    private final List<FilterRow<S, ?>> filterRows;
    @FXML
    private Pane filterRowsContainer;
    @FXML
    private Button addButton;
    @FXML
    private Button okButton;
    @FXML
    private Button removeAllButton;

    public FilterComponent(ApplicationContext appContext, FilteredTableView<S> filteredTableView) {
        this.appContext = appContext;
        this.filteredTableView = filteredTableView;
        this.filterRows = new ArrayList();
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
    }

    public void initialize() {
        this.populate(this.filteredTableView.getCustomFilter().getFilterStates());
        this.okButton.disableProperty().bind(this.valid.not());
        this.rebindValid();
    }

    private void addFilterRow(FilterRow<S, ?> row) {
        this.filterRows.add(row);
        this.filterRowsContainer.getChildren().addAll((Node[])new Node[]{row});
        this.rebindValid();
    }

    private void deleteFilter(FilterRow<S, ?> deleteRow) {
        this.filterRows.remove(deleteRow);
        this.filterRowsContainer.getChildren().removeAll((Node[])new Node[]{deleteRow});
        this.rebindValid();
    }

    private TableFilter<S> getFilter() {
        List tableFilters = this.filterRows.stream().map(FilterRow::getTableFilter).toList();
        return new AndTableFilter(tableFilters);
    }

    @FXML
    public void addFilter() {
        if (this.filterRows.size() < 20) {
            this.addFilterRow(new FilterRow(this.appContext, this.filteredTableView.getFilterableTableColumns(), this::deleteFilter));
        }
    }

    private void populate(Collection<ColumnFilterState<?>> columnFilterStates) {
        List filterableTableColumns = this.filteredTableView.getFilterableTableColumns();
        for (ColumnFilterState<?> state : columnFilterStates) {
            Optional<FilterableTableColumn> filterableTableColumn = filterableTableColumns.stream().filter(column -> state.getColumnId().equals(column.getId())).findFirst();
            if (!filterableTableColumn.isPresent()) continue;
            FilterRow row = new FilterRow(this.appContext, filterableTableColumns, this::deleteFilter);
            FilterableTableColumn sFilterableTableColumn = filterableTableColumn.get();
            row.populate(sFilterableTableColumn, state.getPredicateType(), state.getValue());
            this.addFilterRow(row);
        }
    }

    @FXML
    public void removeAll() {
        this.filterRows.clear();
        this.filterRowsContainer.getChildren().clear();
        this.rebindValid();
    }

    @FXML
    public void ok() {
        this.filteredTableView.setCustomFilter(this.getFilter());
        this.close();
    }

    @FXML
    public void cancel() {
        this.close();
    }

    private void close() {
        this.getScene().getWindow().hide();
    }

    private void rebindValid() {
        this.valid.unbind();
        if (this.filterRows.isEmpty()) {
            this.valid.setValue(true);
        } else {
            BooleanExpression allValid = this.filterRows.stream().map(FilterRow::validProperty).reduce(new SimpleBooleanProperty(true), BooleanExpression::and);
            this.valid.bind(allValid);
        }
    }
}

