/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ui;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.FilterValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ColumnFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.PredicateType;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.TableColumnFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.TableFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.column.FilterableTableColumn;
import com.deutscheboerse.comxerv.comtrader.jfx.util.converter.DisplayNameConverter;
import com.deutscheboerse.ui.jfx.util.binding.ValidProperty;
import com.deutscheboerse.ui.jfx.util.converter.DefaultConverter;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.control.ChoiceBox;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;

public class FilterRow<S extends BroadcastEntity, F extends Serializable>
extends HBox {
    private ValidProperty columnIsValid;
    private final BooleanProperty valid;
    private final ObjectProperty<FilterValueField<F>> valueField;
    private final Collection<FilterableTableColumn<S, ?, ?>> columns;
    private final Consumer<FilterRow> removeAction;
    @FXML
    private ChoiceBox<FilterableTableColumn<S, ?, ?>> columnChoiceBox;
    @FXML
    private ChoiceBox<PredicateType> predicateChoiceBox;
    @FXML
    private BorderPane valuePane;

    public FilterRow(ApplicationContext appContext, Collection<FilterableTableColumn<S, ?, ? extends Serializable>> columns, Consumer<FilterRow> removeAction) {
        this.columns = columns;
        this.removeAction = removeAction;
        this.valid = new SimpleBooleanProperty(false);
        this.valueField = new SimpleObjectProperty<FilterValueField<F>>();
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
    }

    public void initialize() {
        this.columnIsValid = new ValidProperty(this.columnChoiceBox);
        this.columnChoiceBox.setConverter(new DefaultConverter<FilterableTableColumn<S, ?, ?>>(this){

            @Override
            public String toString(FilterableTableColumn<S, ?, ?> object) {
                return object.getLabelText();
            }
        });
        this.columnChoiceBox.getItems().add(FilterableTableColumn.createDummySelectColumn());
        this.columnChoiceBox.getItems().addAll(this.columns);
        this.predicateChoiceBox.setConverter(new DisplayNameConverter());
        this.columnChoiceBox.valueProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue != null) {
                List<PredicateType> predicateTypes = newValue.getColumnFilter().getPredicateTypes();
                boolean predicateTypesEmpty = predicateTypes.isEmpty();
                this.predicateChoiceBox.setVisible(!predicateTypesEmpty);
                this.columnIsValid.setValue(!predicateTypesEmpty);
                this.predicateChoiceBox.getItems().setAll((Collection<PredicateType>)predicateTypes);
                this.predicateChoiceBox.setValue(predicateTypesEmpty ? null : predicateTypes.get(0));
            } else {
                this.predicateChoiceBox.setVisible(false);
            }
        });
        this.valuePane.centerProperty().bind(this.valueField);
        this.predicateChoiceBox.valueProperty().addListener((observable2, oldValue, newValue) -> {
            FilterableTableColumn<S, ?, ?> column = this.columnChoiceBox.getValue();
            this.valid.unbind();
            if (column != null && newValue != null) {
                FilterValueField<?> valueField = column.getColumnFilter().getValueField((PredicateType)newValue);
                this.valueField.setValue(valueField);
                if (valueField != null) {
                    this.valid.bind(valueField.validProperty());
                } else {
                    this.valid.setValue(true);
                }
            } else {
                this.valueField.setValue(null);
                this.valid.set(false);
            }
        });
        this.columnChoiceBox.getSelectionModel().selectFirst();
    }

    @FXML
    public void deleteFilter() {
        this.removeAction.accept(this);
    }

    public void populate(FilterableTableColumn<S, ?, F> column, PredicateType predicateType, F filterValue) {
        this.columnChoiceBox.setValue(column);
        this.predicateChoiceBox.setValue(predicateType);
        if (this.valueField.get() != null) {
            ((FilterValueField)this.valueField.get()).setValue(filterValue);
        }
    }

    public TableFilter<S> getTableFilter() {
        FilterableTableColumn<S, ?, ?> column = this.columnChoiceBox.getValue();
        Object filterValue = this.valueField.getValue() != null ? (Object)((FilterValueField)this.valueField.getValue()).getValue() : null;
        return new TableColumnFilter(column, filterValue, (ColumnFilter<?, Object>)column.getColumnFilter(), this.predicateChoiceBox.getValue());
    }

    public BooleanExpression validProperty() {
        return this.valid;
    }
}

