/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParameters;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel.TotpKeyPane;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.google.inject.Inject;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TotpKeyDialog
extends Dialog<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(TotpKeyDialog.class);
    private final Session session;
    private final TotpKeyPane totpKeyPane;
    private int imageSize = 350;

    @Inject
    public TotpKeyDialog(ApplicationContext appContext) {
        this.totpKeyPane = new TotpKeyPane(appContext);
        this.session = appContext.getService(BackendConnectionGateway.class).getSession();
        this.getDialogPane().setContent(this.totpKeyPane);
        this.setGraphic(new IconView("icon-info-32"));
        StyleUtil.addStyleClass(this.getDialogPane(), "jfxDialog");
        this.setTitle(Util.getLabel("totp_dialog_title"));
        this.setHeaderText(Util.getLabel("totp_dialog_key_info"));
        this.getDialogPane().getButtonTypes().addAll((ButtonType[])new ButtonType[]{ButtonType.OK});
        FxUtil.runLater(() -> this.totpKeyPane.getTotpKey().requestFocus());
    }

    public void show(Window parent, String secret) {
        this.prepare(parent, secret);
        this.showAndWait();
    }

    protected void prepare(Window parent, String secret) {
        this.initOwner(parent);
        this.totpKeyPane.getTotpKey().setText(secret);
        this.generateQrCode(secret);
    }

    private void generateQrCode(String secret) {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        try {
            BitMatrix bitMatrix = qrCodeWriter.encode(this.getUri(secret), BarcodeFormat.QR_CODE, this.imageSize, this.imageSize);
            int matrixWidth = bitMatrix.getWidth();
            Canvas canvas = new Canvas(this.imageSize, this.imageSize);
            GraphicsContext gc2D = canvas.getGraphicsContext2D();
            gc2D.setFill(Color.WHITE);
            gc2D.fillRect(0.0, 0.0, matrixWidth, matrixWidth);
            gc2D.setFill(Color.BLACK);
            for (int v = 0; v < matrixWidth; ++v) {
                for (int h = 0; h < matrixWidth; ++h) {
                    if (!bitMatrix.get(v, h)) continue;
                    gc2D.fillRect(h, v, 1.0, 1.0);
                }
            }
            this.totpKeyPane.getTotpQr().setImage(canvas.snapshot(null, null));
        }
        catch (Exception e) {
            LOG.error("Error generating QR code", e);
        }
    }

    private String getUri(String secret) throws UnsupportedEncodingException {
        return "otpauth://" + this.uriEncode("totp") + "/" + this.uriEncode(this.getQrCodeLabel()) + "?secret=" + this.uriEncode(secret) + "&issuer=" + this.uriEncode("DBG") + "&algorithm=" + this.uriEncode("SHA1") + "&digits=6&period=30";
    }

    private String uriEncode(String text) {
        if (text == null) {
            return "";
        }
        return URLEncoder.encode(text, StandardCharsets.UTF_8).replace("+", "%20");
    }

    private String getQrCodeLabel() {
        if (this.session.getExchange() != null && this.session.getExchange().getName() != null && this.session.getConnectionParameters() != null && this.session.getConnectionParameters().getEnvironmentId() != null) {
            ConnectionParameters connectionParameters = this.session.getConnectionParameters();
            return String.format("M7 %s %s - ComTrader", this.session.getExchange().getName().toUpperCase(), connectionParameters.getEnvironmentId().toLowerCase());
        }
        return "M7 - ComTrader";
    }
}

