/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.market;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.AbstractBestOwnOrderOrderbookValueWrapper;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ContractAdditionOrigin;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.jfx.components.market.MarketSubmitter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.OrderbookRemovalCallback;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.comxerv.comtrader.util.concurrent.CountDownTimer;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMarketOrderWrapper
extends AbstractBestOwnOrderOrderbookValueWrapper {
    public static final String OWN_ORDERS_SUBMIT_DELAY_IN_MILLIS = "own_orders_submit_timeout_in_millis";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMarketOrderWrapper.class);
    private final long ownOrdersSubmitDelayInMillis;
    private final OrderbookRemovalCallback orderbookRemovalCallback;
    private final BooleanProperty submitting;
    private final MessagePublisher messagePublisher;
    private final ScheduledExecutorService scheduledExecutorService;
    private Order currentlyUsedBuyOrder;
    private Order currentlyUsedSellOrder;
    private LongProperty bidOrderChange = new SimpleLongProperty(0L);
    private LongProperty askOrderChange = new SimpleLongProperty(0L);
    private CountDownTimer countDownTimer;
    private final Map<Direction, Order> previewsOrdersToSendMap = new EnumMap<Direction, Order>(Direction.class);

    public AbstractMarketOrderWrapper(OrderbookRemovalCallback orderbookRemovalCallback, ApplicationContext appContext, ContractAdditionOrigin origin) {
        super(origin, orderbookRemovalCallback::removeOrHideOrderbook, orderbookRemovalCallback::updatedItem);
        this.messagePublisher = appContext.getService(MessagePublisher.class);
        this.orderbookRemovalCallback = orderbookRemovalCallback;
        this.submitting = new SimpleBooleanProperty(false);
        this.scheduledExecutorService = appContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        this.bidOrderChange.addListener(o -> AbstractMarketOrderWrapper.updatePrc(x$0 -> this.setOwnBidPrc((LongDisplayValue)x$0), this.currentlyUsedBuyOrder, (LongDisplayValue)this.ownBidPrcProperty().get(), this.bidOrderChange.get()));
        this.askOrderChange.addListener(o -> AbstractMarketOrderWrapper.updatePrc(x$0 -> this.setOwnAskPrc((LongDisplayValue)x$0), this.currentlyUsedSellOrder, (LongDisplayValue)this.ownAskPrcProperty().get(), this.askOrderChange.get()));
        this.ownOrdersSubmitDelayInMillis = appContext.getService(ApplicationConfigurationService.class).getIntegerApplicationProperty(OWN_ORDERS_SUBMIT_DELAY_IN_MILLIS, 0).longValue();
    }

    private static void updatePrc(Consumer<LongDisplayValue> updatePrc, Order currentlyUsedOrder, LongDisplayValue currentPrc, Long change) {
        if (currentlyUsedOrder != null) {
            updatePrc.accept(currentlyUsedOrder.getLimitPrice());
        } else {
            updatePrc.accept(currentPrc == null ? null : currentPrc.add(change));
        }
    }

    private void handleServerTimeout() {
        LOG.info("Timeout occured while submitting modified orders from OwnMarket");
        this.setSubmitting(false);
        this.messagePublisher.publishMessage(Util.getLabel("commons_noResponseFromServerOrder"), MessageSeverity.ERROR);
        this.refreshOrdersFromModel();
    }

    private List<Order> modifyOrder(Direction direction, LongDisplayValue delta) {
        if (delta == null) {
            return Collections.emptyList();
        }
        int decimalShiftPrice = this.getOrderbook().getContract().getProduct().getPriceDecimalShift();
        LongDisplayValue shiftAdjustedDelta = new LongDisplayValue(delta.getDisplayValue().setScale(decimalShiftPrice, RoundingMode.HALF_UP));
        ArrayList<Order> modifiedOrders = new ArrayList<Order>();
        Order order = this.getOrderToModify(direction);
        if (order != null) {
            order.setLimitPrice(order.getLimitPrice().add(shiftAdjustedDelta.getValue()));
            if (order.getOrderType() == OrderType.ICEBERG && order.getRemainingQuantity().compareTo(order.getPeakQuantity()) < 0) {
                order.setOrderType(OrderType.REGULAR);
                order.setPeakQuantity(null);
            }
            modifiedOrders.add(order);
            if (direction.isBuy()) {
                this.bidOrderChange.set(this.bidOrderChange.get() + shiftAdjustedDelta.getValue());
            } else {
                this.askOrderChange.set(this.askOrderChange.get() + shiftAdjustedDelta.getValue());
            }
        } else {
            LOG.warn("No order found, modification is not possible");
        }
        return modifiedOrders;
    }

    private Order getOrderToModify(Direction direction) {
        if (direction.isBuy()) {
            this.currentlyUsedBuyOrder = this.getCurrentlyUsedOrder(this.currentlyUsedBuyOrder, this.getBestOwnBuyOrder());
            return this.currentlyUsedBuyOrder;
        }
        this.currentlyUsedSellOrder = this.getCurrentlyUsedOrder(this.currentlyUsedSellOrder, this.getBestOwnSellOrder());
        return this.currentlyUsedSellOrder;
    }

    private Order getCurrentlyUsedOrder(Order currentlyUsedOrder, Optional<Order> bestOwnOrder) {
        return Optional.ofNullable(currentlyUsedOrder).orElseGet(() -> {
            if (bestOwnOrder.isPresent()) {
                return new Order((Order)bestOwnOrder.get());
            }
            return null;
        });
    }

    public void applyStep(Map<Direction, LongDisplayValue> modification) {
        ArrayList<Order> ordersToSend = new ArrayList<Order>();
        for (Map.Entry<Direction, LongDisplayValue> entry : modification.entrySet()) {
            ordersToSend.addAll(this.modifyOrder(entry.getKey(), entry.getValue()));
        }
        this.prepareSendModifiedOrders(ordersToSend);
    }

    public void applyStep(LongDisplayValue stepSize, Direction ... directions) {
        EnumMap<Direction, LongDisplayValue> modifications = new EnumMap<Direction, LongDisplayValue>(Direction.class);
        for (Direction direction : directions) {
            modifications.put(direction, stepSize);
        }
        this.applyStep(modifications);
    }

    public void narrow(LongDisplayValue stepSize) {
        if (stepSize != null) {
            ArrayList<Order> ordersToSend = new ArrayList<Order>();
            ordersToSend.addAll(this.modifyOrder(Direction.BUY, stepSize));
            ordersToSend.addAll(this.modifyOrder(Direction.SELL, stepSize.invert()));
            this.prepareSendModifiedOrders(ordersToSend);
        }
    }

    public void widen(LongDisplayValue stepSize) {
        if (stepSize != null) {
            ArrayList<Order> ordersToSend = new ArrayList<Order>();
            ordersToSend.addAll(this.modifyOrder(Direction.BUY, stepSize.invert()));
            ordersToSend.addAll(this.modifyOrder(Direction.SELL, stepSize));
            this.prepareSendModifiedOrders(ordersToSend);
        }
    }

    public void fillUp(Direction direction) {
        Order originalOrder = this.getOrderToModify(direction);
        if (originalOrder != null && !originalOrder.getRemainingQuantity().equals(originalOrder.getInitialQuantity())) {
            Order modifiedOrder = new Order(originalOrder);
            modifiedOrder.setRemainingQuantity(modifiedOrder.getInitialQuantity());
            this.sendOrdersAfterTimeoutReached(Collections.singletonList(modifiedOrder));
        }
    }

    private void prepareSendModifiedOrders(List<Order> ordersToSend) {
        if (this.countDownTimer != null) {
            this.countDownTimer.abort();
            this.countDownTimer = null;
        }
        if (ordersToSend.stream().allMatch(order -> order.getProduct().isPriceValid(order.getLimitPrice()))) {
            ordersToSend.stream().forEach(o -> this.previewsOrdersToSendMap.put(o.getDirection(), (Order)o));
            ArrayList<Order> allOrdersToSend = new ArrayList<Order>(this.previewsOrdersToSendMap.values());
            Runnable timeoutAction = FxUtil.wrapWithRunInFxThread(() -> {
                this.sendOrdersAfterTimeoutReached(allOrdersToSend);
                this.previewsOrdersToSendMap.clear();
            });
            this.countDownTimer = new CountDownTimer(this.ownOrdersSubmitDelayInMillis, timeoutAction, this.scheduledExecutorService);
        }
    }

    private int compareOrdersToSend(Order o1, Order o2) {
        if (o1.getDirection().isBuy() && o2.getDirection().isSell()) {
            return this.bidOrderChange.get() < 0L ? -1 : 1;
        }
        if (o1.getDirection().isSell() && o2.getDirection().isBuy()) {
            return this.askOrderChange.get() > 0L ? 1 : -1;
        }
        return 0;
    }

    private void sendOrdersAfterTimeoutReached(List<Order> ordersToSend) {
        ArrayList<Order> ordersToSendOrdered = new ArrayList<Order>(ordersToSend);
        Collections.sort(ordersToSendOrdered, this::compareOrdersToSend);
        for (Order orderToSend : ordersToSendOrdered) {
            if (orderToSend.getDirection().isBuy()) {
                this.loadValuesFromBuyOrder(orderToSend);
                continue;
            }
            this.loadValuesFromSellOrder(orderToSend);
        }
        this.getMarketSubmitter().sendModifiedOrders(this, ordersToSendOrdered);
        this.clearAfterSubmitOrCancel();
    }

    private void clearAfterSubmitOrCancel() {
        this.countDownTimer = null;
        this.currentlyUsedSellOrder = null;
        this.currentlyUsedBuyOrder = null;
        this.askOrderChange.set(0L);
        this.bidOrderChange.set(0L);
        this.refreshOrdersFromModel();
    }

    protected abstract MarketSubmitter getMarketSubmitter();

    public OrderbookRemovalCallback getOrderbookRemovalCallback() {
        return this.orderbookRemovalCallback;
    }

    public boolean getSubmitting() {
        return this.submitting.get();
    }

    public void setSubmitting(boolean submitting) {
        this.submitting.set(submitting);
    }

    public BooleanProperty submittingProperty() {
        return this.submitting;
    }

    public Runnable getTimeoutHandler() {
        return FxUtil.wrapWithRunInFxThread(this::handleServerTimeout);
    }
}

