/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.market;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.jfx.components.market.AbstractMarketOrderWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.components.market.MarketSubmitter;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.async.ActionWithTimeout;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.CrossTradeProtectionService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractMarketSubmitter
implements MarketSubmitter {
    private static final long TIMEOUT_IN_MILLIS = 30000L;
    private final UserAlertService userAlertService;
    private final CrossTradeProtectionService crossTradeProtectionService;
    private final ScheduledExecutorService scheduledExecutorService;

    public AbstractMarketSubmitter(ApplicationContext appContext) {
        this.userAlertService = appContext.getService(UserAlertService.class);
        this.crossTradeProtectionService = appContext.getService(CrossTradeProtectionService.class);
        this.scheduledExecutorService = appContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
    }

    @Override
    public void sendModifiedOrders(AbstractMarketOrderWrapper marketOrderWrapper, List<Order> ordersToSend) {
        if (ordersToSend.isEmpty()) {
            marketOrderWrapper.refreshOrdersFromModel();
            return;
        }
        if (!this.crossTradeProtectionService.checkOrdersWithEachOther(ordersToSend, false) || !this.crossTradeProtectionService.checkOrdersWithExclusion(ordersToSend, false)) {
            this.userAlertService.showConfirmationDialog(Util.getLabel("ownMarketPanel_ignoreStepToAvoidOrderMatchPopupMessage_header"), Util.getLabel("ownMarketPanel_ignoreStepToAvoidOrderMatchPopupMessage"), UserAlertService.Flag.ERROR);
            marketOrderWrapper.refreshOrdersFromModel();
            return;
        }
        marketOrderWrapper.setSubmitting(true);
        AtomicInteger awaitingResponses = this.getAwaitingResponses(ordersToSend);
        ActionWithTimeout.Action action = callWhenFinished -> {
            ResponseHandler responseHandler = asyncResponse -> {
                if (!asyncResponse.getStatus().equals((Object)ResponseStatus.SUCCESS)) {
                    marketOrderWrapper.refreshOrdersFromModel();
                }
                if (awaitingResponses.decrementAndGet() <= 0 && callWhenFinished.actionFinished() == ActionWithTimeout.ActionState.FINISHED) {
                    marketOrderWrapper.setSubmitting(false);
                }
            };
            this.sendOrder(responseHandler, ordersToSend);
        };
        new ActionWithTimeout(action, 30000L, marketOrderWrapper.getTimeoutHandler(), this.scheduledExecutorService).executeAsynchronously();
    }

    abstract AtomicInteger getAwaitingResponses(List<Order> var1);

    abstract void sendOrder(ResponseHandler var1, List<Order> var2);
}

