/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntryRow;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateAdapter;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.BatchUpdateListener;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.listener.WeakBatchUpdateListener;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.TableColumnWithTooltip;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.ExtendedOrderbookChangeType;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.ExtendedOrderbookTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook.ExtendedOrderbookEntriesCellFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook.ExtendedOrderbookEntriesMemberCellValueFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook.ExtendedOrderbookEntriesQuantityCellValueFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook.ExtendedOrderbookEntriesTraderCellValueFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.TableViewOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.deutscheboerse.ui.jfx.util.binding.ObservableBase;
import com.deutscheboerse.ui.jfx.util.control.table.AllColumnsEqualWidthListener;
import com.deutscheboerse.ui.jfx.util.control.table.PropertyPathValueFactory;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.VPos;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

@OverrideGuiConfiguration(field="orderbookTable", overrideId="ExtendedOrderbookTables", strategy=TableViewOverrideGuiStrategy.class)
public class ExtendedOrderbookTables
extends GridPane {
    private static final int MIN_ROWS = 10;
    public static final int TABLE_COLUMN_MIN_WIDTH = 45;
    private final ExtendedOrderbookTableView orderbookTable;
    private final ObjectProperty<Orderbook> orderbook;
    private final ObservableValue<ExtendedOrderbookEntries> bids;
    private final ObservableValue<ExtendedOrderbookEntries> asks;
    private final ObservableBase reloadOrderbookObservable;
    private final IntegerProperty rowLimit;
    private final ObservableValue<Number> tablesPrefHeight;
    private final boolean adminPanel;
    private final IntegerProperty minRows = new SimpleIntegerProperty(10);
    private final ApplicationContext applicationContext;
    private final BatchUpdateListener<ExtendedOrderbookEntry> reloadBidsListener;
    private final BatchUpdateListener<ExtendedOrderbookEntry> reloadAsksListener;
    private final BatchUpdateListener<ExtendedOrderbookEntry> weakReloadBidsListener;
    private final BatchUpdateListener<ExtendedOrderbookEntry> weakReloadAsksListener;
    private ScheduledExecutorService executor;

    public ExtendedOrderbookTables(boolean adminPanel, boolean scrollLess) {
        this(FXMLLoaderWithContext.getAppContext(), adminPanel, scrollLess);
    }

    protected ExtendedOrderbookTables(ApplicationContext applicationContext, boolean adminPanel, boolean scrollLess) {
        this.applicationContext = applicationContext;
        this.orderbook = new SimpleObjectProperty<Orderbook>();
        this.rowLimit = new SimpleIntegerProperty(1);
        this.adminPanel = adminPanel;
        this.executor = applicationContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        this.reloadBidsListener = BatchUpdateAdapter.batchFinishedListener(this::reloadBids);
        this.weakReloadBidsListener = new WeakBatchUpdateListener<ExtendedOrderbookEntry>(this.reloadBidsListener);
        this.reloadAsksListener = BatchUpdateAdapter.batchFinishedListener(this::reloadAsks);
        this.weakReloadAsksListener = new WeakBatchUpdateListener<ExtendedOrderbookEntry>(this.reloadAsksListener);
        this.reloadOrderbookObservable = new ObservableBase();
        this.bids = DependentBinding.get(Orderbook::getExtendedBuys, this.orderbook, null, this.orderbook, this.reloadOrderbookObservable);
        this.asks = DependentBinding.get(Orderbook::getExtendedSells, this.orderbook, null, this.orderbook, this.reloadOrderbookObservable);
        this.getStyleClass().add("extendedOrderbookTables");
        this.orderbookTable = new ExtendedOrderbookTableView(adminPanel, scrollLess);
        GridPane.setHgrow(this.orderbookTable, Priority.ALWAYS);
        GridPane.setVgrow(this.orderbookTable, Priority.ALWAYS);
        GridPane.setValignment(this.orderbookTable, VPos.TOP);
        this.tablesPrefHeight = DependentBinding.get(this::computeTablesPrefHeight, this.rowLimit, this.minRows, this.orderbookTable.fixedCellSizeProperty(), this.orderbookTable.getItems());
        this.initTables();
        this.initialLoad();
    }

    private void initTables() {
        this.initTable();
        this.initBidsTableColumns();
        this.initAsksTableColumns();
        this.add(this.orderbookTable, 0, 0);
        this.rowLimit.addListener((observable2, oldValue, newValue) -> this.rowLimitChanged(oldValue.intValue(), newValue.intValue()));
    }

    private void initTable() {
        this.initTable(this.orderbookTable);
        this.orderbookTable.setId("orderbookTable");
        this.orderbookTable.getStyleClass().add("orderbookTable");
        this.orderbookTable.orderbookProperty().bind(this.orderbook);
        this.bids.addListener((observable2, oldValue, newValue) -> this.bidsChanged((ExtendedOrderbookEntries)oldValue, (ExtendedOrderbookEntries)newValue));
        this.asks.addListener((observable2, oldValue, newValue) -> this.asksChanged((ExtendedOrderbookEntries)oldValue, (ExtendedOrderbookEntries)newValue));
    }

    private void initTable(ExtendedOrderbookTableView table) {
        table.setFixedCellSize(24.0);
        HBox.setHgrow(table, Priority.ALWAYS);
        AllColumnsEqualWidthListener.apply(table);
        table.orderbookProperty().bind(this.orderbook);
        table.prefHeightProperty().bind(this.tablesPrefHeight);
    }

    private void initAsksTableColumns() {
        TableColumn asksAsk = this.buildColumn("commons_ask", "commons_askPrice", "askColumn");
        asksAsk.setCellValueFactory(new PropertyPathValueFactory("sellOrderbookEntry.price"));
        ExtendedOrderbookEntriesCellFactory asksAskCellFactory = new ExtendedOrderbookEntriesCellFactory(this.applicationContext, ExtendedOrderbookChangeType.PRICE.asMask(), false, Direction.SELL);
        asksAsk.setCellFactory(asksAskCellFactory);
        TableColumn<ExtendedOrderbookEntryRow, String> asksQuantityShort = this.buildColumn("commons_quantityShort", "commons_askQuantity", "quantityColumn");
        asksQuantityShort.setCellValueFactory(new ExtendedOrderbookEntriesQuantityCellValueFactory(Direction.SELL));
        ExtendedOrderbookEntriesCellFactory asksQuantityShortCellFactory = new ExtendedOrderbookEntriesCellFactory(this.applicationContext, ExtendedOrderbookChangeType.ANY_MASK, false, Direction.SELL);
        asksQuantityShort.setCellFactory(asksQuantityShortCellFactory);
        TableColumn asksAccQty = this.buildColumn("commons_accQty", "commons_askAccumulatedQuantity", "accQtyColumn");
        asksAccQty.setCellValueFactory(new PropertyPathValueFactory("sellOrderbookEntry.accQuantity"));
        ExtendedOrderbookEntriesCellFactory asksAccQtyCellFactory = new ExtendedOrderbookEntriesCellFactory(this.applicationContext, 0, true, Direction.SELL);
        asksAccQty.setCellFactory(asksAccQtyCellFactory);
        TableColumn asksVwapShort = this.buildColumn("commons_vwapShort", "commons_askVWAP", "vwapColumn");
        asksVwapShort.setCellValueFactory(new PropertyPathValueFactory("sellOrderbookEntry.vwap"));
        ExtendedOrderbookEntriesCellFactory asksVwapShortCellFactory = new ExtendedOrderbookEntriesCellFactory(this.applicationContext, 0, true, Direction.SELL);
        asksVwapShort.setCellFactory(asksVwapShortCellFactory);
        if (this.adminPanel) {
            TableColumn<ExtendedOrderbookEntryRow, String> asksOwner = this.buildColumn("commons_ownerShort", "commons_sellMemberName", "ownerCodeColumn");
            asksOwner.setCellValueFactory(new ExtendedOrderbookEntriesTraderCellValueFactory(this.applicationContext, Direction.SELL));
            asksOwner.setCellFactory(new ExtendedOrderbookEntriesCellFactory(this.applicationContext, 0, false, Direction.SELL));
            TableColumn<ExtendedOrderbookEntryRow, String> asksMember = this.buildColumn("commons_memberShort", "commons_sellTraderName", "memberColumn");
            asksMember.setCellValueFactory(new ExtendedOrderbookEntriesMemberCellValueFactory(this.applicationContext, Direction.SELL));
            asksMember.setCellFactory(new ExtendedOrderbookEntriesCellFactory(this.applicationContext, 0, false, Direction.SELL));
            this.orderbookTable.getColumns().addAll(asksAsk, asksQuantityShort, asksAccQty, asksVwapShort, asksOwner, asksMember);
        } else {
            this.orderbookTable.getColumns().addAll(asksAsk, asksQuantityShort, asksAccQty, asksVwapShort);
        }
    }

    private void initBidsTableColumns() {
        TableColumn bidsVwapShort = this.buildColumn("commons_vwapShort", "commons_bidVWAP", "vwapColumn");
        bidsVwapShort.setCellValueFactory(new PropertyPathValueFactory("buyOrderbookEntry.vwap"));
        ExtendedOrderbookEntriesCellFactory bidsVwapCellFactory = new ExtendedOrderbookEntriesCellFactory(this.applicationContext, 0, true, Direction.BUY);
        bidsVwapShort.setCellFactory(bidsVwapCellFactory);
        TableColumn bidsAccQty = this.buildColumn("commons_accQty", "commons_bidAccumulatedQuantity", "accQtyColumn");
        bidsAccQty.setCellValueFactory(new PropertyPathValueFactory("buyOrderbookEntry.accQuantity"));
        ExtendedOrderbookEntriesCellFactory bidsAccQtyCellFactory = new ExtendedOrderbookEntriesCellFactory(this.applicationContext, 0, true, Direction.BUY);
        bidsAccQty.setCellFactory(bidsAccQtyCellFactory);
        TableColumn<ExtendedOrderbookEntryRow, String> bidsQuantityShort = this.buildColumn("commons_quantityShort", "commons_bidQuantity", "quantityColumn");
        bidsQuantityShort.setCellValueFactory(new ExtendedOrderbookEntriesQuantityCellValueFactory(Direction.BUY));
        ExtendedOrderbookEntriesCellFactory bidsQuantityShortCellFactory = new ExtendedOrderbookEntriesCellFactory(this.applicationContext, ExtendedOrderbookChangeType.ANY_MASK, false, Direction.BUY);
        bidsQuantityShort.setCellFactory(bidsQuantityShortCellFactory);
        TableColumn bidsBid = this.buildColumn("commons_bid", "commons_bidPrice", "bidColumn");
        bidsBid.setCellValueFactory(new PropertyPathValueFactory("buyOrderbookEntry.price"));
        ExtendedOrderbookEntriesCellFactory bidsBidCellFactory = new ExtendedOrderbookEntriesCellFactory(this.applicationContext, ExtendedOrderbookChangeType.PRICE.asMask(), false, Direction.BUY);
        bidsBid.setCellFactory(bidsBidCellFactory);
        if (this.adminPanel) {
            TableColumn<ExtendedOrderbookEntryRow, String> bidsMember = this.buildColumn("commons_memberShort", "commons_buyMemberName", "memberColumn");
            bidsMember.setCellValueFactory(new ExtendedOrderbookEntriesMemberCellValueFactory(this.applicationContext, Direction.BUY));
            bidsMember.setCellFactory(new ExtendedOrderbookEntriesCellFactory(this.applicationContext, 0, false, Direction.BUY));
            TableColumn<ExtendedOrderbookEntryRow, String> bidsOwner = this.buildColumn("commons_ownerShort", "commons_buyTraderName", "ownerCodeColumn");
            bidsOwner.setCellValueFactory(new ExtendedOrderbookEntriesTraderCellValueFactory(this.applicationContext, Direction.BUY));
            bidsOwner.setCellFactory(new ExtendedOrderbookEntriesCellFactory(this.applicationContext, 0, false, Direction.BUY));
            this.orderbookTable.getColumns().addAll(bidsMember, bidsOwner, bidsVwapShort, bidsAccQty, bidsQuantityShort, bidsBid);
        } else {
            this.orderbookTable.getColumns().addAll(bidsVwapShort, bidsAccQty, bidsQuantityShort, bidsBid);
        }
    }

    private <T> TableColumn<ExtendedOrderbookEntryRow, T> buildColumn(String labelKey, String tooltipKey, String id) {
        TableColumnWithTooltip tc = new TableColumnWithTooltip();
        tc.setLabelText(Util.getLabel(labelKey));
        tc.setTooltipText(Util.getLabel(tooltipKey));
        tc.setId(id);
        tc.setMinWidth(45.0);
        tc.setResizable(false);
        tc.setSortable(false);
        return tc;
    }

    private void initialLoad() {
        this.reloadBids();
        this.reloadAsks();
    }

    private void rowLimitChanged(int oldValue, int newValue) {
        this.reloadBids();
        this.reloadAsks();
        if (oldValue == -1 && newValue != -1 || oldValue != -1 && newValue != -1 && newValue < oldValue) {
            this.executor.schedule(() -> FxUtil.runInFxThread(this.orderbookTable::forceCleanPile), 10L, TimeUnit.SECONDS);
        }
    }

    private void bidsChanged(ExtendedOrderbookEntries oldValue, ExtendedOrderbookEntries newValue) {
        if (oldValue != null) {
            oldValue.removeListener(this.weakReloadBidsListener);
        }
        if (newValue != null) {
            newValue.addListener(this.weakReloadBidsListener);
        }
        this.reloadBids();
    }

    private void asksChanged(ExtendedOrderbookEntries oldValue, ExtendedOrderbookEntries newValue) {
        if (oldValue != null) {
            oldValue.removeListener(this.weakReloadAsksListener);
        }
        if (newValue != null) {
            newValue.addListener(this.weakReloadAsksListener);
        }
        this.reloadAsks();
    }

    private void reloadBids() {
        this.orderbookTable.updateTableContent(this.getEntriesList(this.bids), Direction.BUY);
    }

    private void reloadAsks() {
        this.orderbookTable.updateTableContent(this.getEntriesList(this.asks), Direction.SELL);
    }

    private List<ExtendedOrderbookEntry> getEntriesList(ObservableValue<ExtendedOrderbookEntries> entries2) {
        ExtendedOrderbookEntries entriesValue = entries2.getValue();
        if (entriesValue != null && this.rowLimit.get() == -1) {
            return entriesValue.getEntries();
        }
        if (entriesValue != null) {
            return entriesValue.getEntries().subList(0, Math.min(entriesValue.getEntries().size(), this.rowLimit.get()));
        }
        return Collections.emptyList();
    }

    private double computeTablesPrefHeight() {
        int rows = this.rowLimit.get() == -1 ? Math.max(this.minRows.get(), this.orderbookTable.getItems().size()) : this.rowLimit.get();
        return (double)(rows + 1) * this.orderbookTable.getFixedCellSize();
    }

    public ObjectProperty<Orderbook> orderbookProperty() {
        return this.orderbook;
    }

    public Orderbook getOrderbook() {
        return (Orderbook)this.orderbook.get();
    }

    public IntegerProperty rowLimitProperty() {
        return this.rowLimit;
    }

    public int getMinRows() {
        return this.minRows.get();
    }

    public IntegerProperty minRowsProperty() {
        return this.minRows;
    }

    public void setMinRows(int minRows) {
        this.minRows.set(minRows);
    }

    public void reloadOrderbookEntries() {
        this.reloadOrderbookObservable.invalidate();
    }

    public ExtendedOrderbookTableView getOrderbookTable() {
        return this.orderbookTable;
    }

    public ExtendedOrderbookTableView getTable() {
        return this.orderbookTable;
    }
}

