/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry;

import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AbstractProductAwareLongDisplayValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderBindingUtil;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;

public class PeakPriceDeltaField
extends AbstractProductAwareLongDisplayValueField {
    public PeakPriceDeltaField() {
    }

    public PeakPriceDeltaField(LongDisplayValue initialValue) {
        super(initialValue);
    }

    public PeakPriceDeltaField(LongDisplayValue initialValue, int delta) {
        super(initialValue, delta);
    }

    public void init(final ReadOnlyObjectProperty<Direction> direction, final ReadOnlyObjectProperty<Contract> contract, final ReadOnlyObjectProperty<OrderType> orderType, final ReadOnlyObjectProperty<LongDisplayValue> price, final ReadOnlyObjectProperty<LongDisplayValue> quantity, final ReadOnlyObjectProperty<LongDisplayValue> peakQuantity) {
        this.productProperty().bind(OrderBindingUtil.productBinding(contract));
        this.disableProperty().bind(Bindings.or(orderType.isNotEqualTo(OrderType.ICEBERG), contract.isNull()));
        this.promptTextProperty().bind((ObservableValue<String>)new DependentBinding<String>(this, new Observable[]{orderType}){

            @Override
            protected String computeValue() {
                if (orderType.getValue() == OrderType.ICEBERG) {
                    return Util.getLabel("commons_delta");
                }
                return null;
            }
        });
        this.textFieldFocusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (contract.get() != null) {
                Product product = ((Contract)contract.get()).getProduct();
                int decimalShift = product.getPriceDecimalShift();
                int tickSize = (int)product.getPriceTickSize().getValue();
                if (!oldValue.booleanValue() && newValue.booleanValue() || this.isValid()) {
                    LongDisplayValue oldpeakPriceDelta = this.getValue();
                    if (oldpeakPriceDelta != null) {
                        this.setValue(oldpeakPriceDelta.applyShift(decimalShift));
                    }
                    this.setDelta(tickSize);
                    this.selectAllIfFocused();
                }
                if (this.getValue() != null && oldValue.booleanValue() && !newValue.booleanValue()) {
                    this.setValue(this.getValue().applyShift(decimalShift));
                }
            }
        });
        orderType.addListener((observableValue, oldValue, newValue) -> {
            if (newValue != OrderType.ICEBERG) {
                this.setValue(null);
            }
        });
        this.maximumProperty().bind((ObservableValue<LongDisplayValue>)new DependentBinding<LongDisplayValue>(this, new Observable[]{direction, contract, quantity, peakQuantity, price}){

            @Override
            protected LongDisplayValue computeValue() {
                Direction directionValue = (Direction)direction.get();
                Contract contractValue = (Contract)contract.getValue();
                if (Direction.BUY.equals(directionValue)) {
                    if (contractValue != null) {
                        return new LongDisplayValue(0L, contractValue.getProduct().getPriceDecimalShift());
                    }
                    return new LongDisplayValue(0L, 0);
                }
                if (contractValue != null) {
                    Product product = contractValue.getProduct();
                    long maxDelta = Long.MAX_VALUE;
                    if (quantity.get() != null && peakQuantity.get() != null && price.get() != null && ((LongDisplayValue)peakQuantity.get()).getValue() != 0L) {
                        int numberOfPeaks = (int)Math.ceil((double)((LongDisplayValue)quantity.get()).getValue() / (double)((LongDisplayValue)peakQuantity.get()).getValue());
                        LongDisplayValue limitPrice = (LongDisplayValue)price.get();
                        maxDelta = numberOfPeaks == 1 ? 0L : product.getPriceMaxValue().subtract(limitPrice.getValue()).getValue() / (long)(numberOfPeaks - 1);
                    }
                    long range = product.getIcebergPriceDeltaRange().getValue();
                    long minValue = Math.min(maxDelta, range);
                    return new LongDisplayValue(minValue, contractValue.getProduct().getPriceDecimalShift());
                }
                return null;
            }
        });
        this.minimumProperty().bind((ObservableValue<LongDisplayValue>)new DependentBinding<LongDisplayValue>(this, new Observable[]{direction, contract, quantity, peakQuantity, price}){

            @Override
            protected LongDisplayValue computeValue() {
                Direction directionValue = (Direction)direction.get();
                Contract contractValue = (Contract)contract.getValue();
                if (Direction.SELL.equals(directionValue)) {
                    if (contractValue != null) {
                        return new LongDisplayValue(0L, contractValue.getProduct().getPriceDecimalShift());
                    }
                    return new LongDisplayValue(0L, 0);
                }
                if (contractValue != null) {
                    Product product = contractValue.getProduct();
                    long maxDelta = Long.MIN_VALUE;
                    if (quantity.get() != null && peakQuantity.get() != null && price.get() != null && ((LongDisplayValue)peakQuantity.get()).getValue() != 0L) {
                        int numberOfPeaks = (int)Math.ceil((double)((LongDisplayValue)quantity.get()).getValue() / (double)((LongDisplayValue)peakQuantity.get()).getValue());
                        LongDisplayValue limitPrice = (LongDisplayValue)price.get();
                        maxDelta = numberOfPeaks == 1 ? 0L : product.getPriceMinValue().subtract(limitPrice.getValue()).getValue() / (long)(numberOfPeaks - 1);
                    }
                    long range = -product.getIcebergPriceDeltaRange().getValue();
                    long maxValue = Math.max(maxDelta, range);
                    return new LongDisplayValue(maxValue, contractValue.getProduct().getPriceDecimalShift());
                }
                return null;
            }
        });
    }

    @Override
    public LongDisplayValue getInitialValue() {
        return LongDisplayValue.ZERO.applyShift(this.getProduct().getPriceDecimalShift());
    }

    @Override
    public Node getPreviewForConfigTable() {
        PeakPriceDeltaField simpleLongDisplayValueField = new PeakPriceDeltaField(this.getValue());
        simpleLongDisplayValueField.setValue(this.getValue());
        simpleLongDisplayValueField.prefWidthProperty().bind(this.widthProperty());
        simpleLongDisplayValueField.setDisable(true);
        return simpleLongDisplayValueField;
    }
}

