/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.producttimeline;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.property.binding.LongDisplayValueStringBinding;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValueChange;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.FlashingLabel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ValueChangeWidget;
import com.deutscheboerse.comxerv.comtrader.jfx.components.producttimeline.LabeledBar;
import com.deutscheboerse.comxerv.comtrader.jfx.util.DirectionStyleUtil;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.WeakObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;

public class OrderbookLabeledBar
extends LabeledBar {
    protected static final String VALUE_NOT_PRESENT_TEXT = "-";
    private final FlashingLabel lastQtyText;
    private final FlashingLabel lastPrcText;
    private final ValueChangeWidget valueChangeWidget;

    public OrderbookLabeledBar(ApplicationContext appContext) {
        HBox lastQtyPrcContainer = new HBox();
        lastQtyPrcContainer.setFillHeight(false);
        lastQtyPrcContainer.setAlignment(Pos.CENTER_LEFT);
        this.lastQtyText = new FlashingLabel(appContext);
        this.lastQtyText.setId("lastQtyText");
        this.lastQtyText.getStyleClass().addAll((String[])new String[]{"headerLabel"});
        this.lastQtyText.setAlignment(Pos.CENTER_LEFT);
        Label at = new Label(Util.getLabel("commons_at"));
        at.getStyleClass().addAll((String[])new String[]{"headerLabel"});
        this.lastPrcText = new FlashingLabel(appContext);
        this.lastPrcText.setId("lastPrcText");
        this.lastPrcText.getStyleClass().addAll((String[])new String[]{"headerLabel"});
        this.lastPrcText.setAlignment(Pos.CENTER_LEFT);
        this.valueChangeWidget = new ValueChangeWidget();
        lastQtyPrcContainer.getChildren().addAll((Node[])new Node[]{this.lastQtyText, at, this.lastPrcText, this.valueChangeWidget});
        this.getContrainer().getChildren().add(lastQtyPrcContainer);
    }

    public void loadLastPrcQty(Orderbook currentOrderbookValue) {
        if (currentOrderbookValue != null) {
            this.lastPrcText.textProperty().bind(new WeakObservableValue<String>(new LongDisplayValueStringBinding(currentOrderbookValue.lastPriceProperty(), true, VALUE_NOT_PRESENT_TEXT)));
            this.lastQtyText.textProperty().bind(new WeakObservableValue<String>(new LongDisplayValueStringBinding(currentOrderbookValue.lastQuantityProperty(), true, VALUE_NOT_PRESENT_TEXT)));
            this.valueChangeWidget.valueProperty().addListener(observable2 -> DirectionStyleUtil.setCssClass((Node)this.lastPrcText, (ValueChange)((Object)((Object)currentOrderbookValue.priceChangeProperty().getValue()))));
            DirectionStyleUtil.setCssClass((Node)this.lastPrcText, (ValueChange)((Object)currentOrderbookValue.priceChangeProperty().getValue()));
        } else {
            this.lastPrcText.textProperty().unbind();
            this.lastQtyText.textProperty().unbind();
        }
    }

    public void loadPriceChange(Orderbook currentOrderbookValue) {
        if (currentOrderbookValue != null) {
            this.valueChangeWidget.valueProperty().bind(new WeakObservableValue<ValueChange>(currentOrderbookValue.priceChangeProperty()));
        } else {
            this.valueChangeWidget.valueProperty().unbind();
            this.valueChangeWidget.setValue(null);
        }
    }
}

