/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.settings;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.SettingsSection;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.BorderPane;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.LineNumberFactory;

public abstract class AbstractTemplatesPane
extends BorderPane
implements SettingsSection {
    private final SettingsService.Settings<List<String>> TEMPLATES;
    private final SettingsService.Settings<Boolean> TEMPLATES_FIRST_IS_DEFAULT;
    private final String DEFAULT_TEMPLATE_TEXT;
    private final int MAX_NUM_OF_TEMPLATES;
    private final int MAX_LENGTH_OF_TEMPLATE;
    private final TemplateRegex TEMPLATE_REGEX;
    private final SettingsService settingsService;
    private final UserAlertService userAlertService;
    @FXML
    protected CodeArea templatesArea;
    @FXML
    protected CheckBox templateWrapCheckbox;
    @FXML
    protected CheckBox templateUseFirstAsDefault;

    protected AbstractTemplatesPane(ApplicationContext appContext, SettingsService.Settings<List<String>> templates, SettingsService.Settings<Boolean> firstIsDefault, int maxNumOfTemplates, int maxLengthOfTemplate, TemplateRegex templateRegex, String defaultTemplateText) {
        this.DEFAULT_TEMPLATE_TEXT = defaultTemplateText;
        this.MAX_NUM_OF_TEMPLATES = maxNumOfTemplates;
        this.MAX_LENGTH_OF_TEMPLATE = maxLengthOfTemplate;
        this.TEMPLATE_REGEX = templateRegex;
        this.TEMPLATES = templates;
        this.TEMPLATES_FIRST_IS_DEFAULT = firstIsDefault;
        this.settingsService = appContext.getService(SettingsService.class);
        this.userAlertService = appContext.getService(UserAlertService.class);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        this.templatesArea.setPadding(new Insets(0.0, 1.0, 0.0, 0.0));
        this.templatesArea.setParagraphGraphicFactory(LineNumberFactory.get(this.templatesArea));
        this.templatesArea.setWrapText(false);
        this.templatesArea.appendText(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)this.settingsService.loadSettings(this.TEMPLATES)));
        this.templateUseFirstAsDefault.setSelected(this.settingsService.loadSettings(this.TEMPLATES_FIRST_IS_DEFAULT));
    }

    @Override
    public boolean applyChanges() {
        List<String> nonEmptyLines = Arrays.stream(this.templatesArea.getText().split("\n|\r\n")).filter(s -> !s.isBlank()).toList();
        StringJoiner longLines = new StringJoiner(",");
        StringJoiner invalidCharacters = new StringJoiner(",");
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < nonEmptyLines.size(); ++i) {
            if (nonEmptyLines.get(i).length() > this.MAX_LENGTH_OF_TEMPLATE) {
                longLines.add(Integer.toString(i + 1));
            }
            if (TemplateRegex.NO_RESTRICTION.equals(this.TEMPLATE_REGEX) || nonEmptyLines.get(i).matches(this.TEMPLATE_REGEX.regex)) continue;
            invalidCharacters.add(Integer.toString(i + 1));
        }
        if (nonEmptyLines.size() > this.MAX_NUM_OF_TEMPLATES) {
            errors.add(Util.getLabel("settingsPanel_templatesTab_validationError_tooMany", this.MAX_NUM_OF_TEMPLATES));
        }
        if (longLines.length() > 0) {
            errors.add(Util.getLabel("settingsPanel_templatesTab_validationError_tooLong", longLines.toString(), this.MAX_LENGTH_OF_TEMPLATE));
        }
        if (invalidCharacters.length() > 0) {
            errors.add(Util.getLabel("settingsPanel_templatesTab_validationError_invvalidCharacters", invalidCharacters.toString(), this.TEMPLATE_REGEX.humanReadableAllowedChars));
        }
        this.templatesArea.replaceText(String.join((CharSequence)"\n", nonEmptyLines));
        if (errors.isEmpty()) {
            this.settingsService.storeSettings(this.TEMPLATES, nonEmptyLines);
            this.settingsService.storeSettings(this.TEMPLATES_FIRST_IS_DEFAULT, this.templateUseFirstAsDefault.isSelected());
        } else {
            String errorText = String.join((CharSequence)"\n", errors);
            this.userAlertService.showConfirmationDialog(Util.getLabel("settingsPanel_templatesTab_validationError_title"), Util.getLabel("settingsPanel_templatesTab_validationError_text") + "\n" + errorText, UserAlertService.Flag.ERROR);
        }
        return errors.isEmpty();
    }

    @Override
    public void cancelChanges() {
        this.templatesArea.replaceText(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)this.settingsService.loadSettings(this.TEMPLATES)));
    }

    @Override
    public void resetToDefault() {
        this.templatesArea.replaceText(this.DEFAULT_TEMPLATE_TEXT);
    }

    @FXML
    void templateWrapAction() {
        this.templatesArea.setWrapText(this.templateWrapCheckbox.isSelected());
    }

    public static class TemplateRegex {
        public static final TemplateRegex NO_RESTRICTION = new TemplateRegex("", "");
        private final String regex;
        private final String humanReadableAllowedChars;

        public TemplateRegex(String regex, String humanReadableAllowedChars) {
            this.regex = regex;
            this.humanReadableAllowedChars = humanReadableAllowedChars;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateRegex that = (TemplateRegex)o;
            return Objects.equals(this.regex, that.regex) && Objects.equals(this.humanReadableAllowedChars, that.humanReadableAllowedChars);
        }

        public int hashCode() {
            return Objects.hash(this.regex, this.humanReadableAllowedChars);
        }
    }
}

