/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.util.DisplayDescription;
import com.deutscheboerse.comxerv.comtrader.core.util.DisplayImage;
import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.TimeStampProvider;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.image.ImageFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.ColorInvalidationListener;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.GenericCellCustomizer;
import com.deutscheboerse.comxerv.comtrader.jfx.service.flash.ColorFlash;
import com.deutscheboerse.comxerv.comtrader.jfx.service.flash.ColorFlashFactory;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.control.AutoScaleImageView;
import java.util.Optional;
import javafx.beans.DefaultProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.util.Callback;
import org.joda.time.DateTime;

@DefaultProperty(value="cellCustomizer")
public class GenericCellFactory<S, T>
implements Callback<TableColumn<S, T>, TableCell<S, T>> {
    private final ApplicationContext applicationContext;
    private boolean flashing;
    private ContentDisplay contentDisplay;
    private Pos alignment;
    private Insets padding;
    private String cellStyleClass;
    private GenericCellCustomizer<S, T> cellCustomizer;
    private static final Tooltip SHARED_TOOLTIP = new Tooltip();

    public GenericCellFactory() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    protected GenericCellFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.flashing = true;
        this.contentDisplay = ContentDisplay.TEXT_ONLY;
        this.alignment = Pos.CENTER;
        this.padding = new Insets(0.0);
    }

    @Override
    public TableCell<S, T> call(TableColumn<S, T> column) {
        GenericDisplayCell<S, T> cell = new GenericDisplayCell<S, T>(this.applicationContext, this.flashing, this.cellCustomizer);
        cell.setAlignment(this.alignment);
        cell.setContentDisplay(this.contentDisplay);
        cell.setPadding(this.padding);
        if (this.cellStyleClass != null && !this.cellStyleClass.isEmpty()) {
            StyleUtil.addStyleClasses(cell, this.cellStyleClass);
        }
        ColorInvalidationListener.registerForColoredTableColumn(column, cell);
        return cell;
    }

    public boolean isFlashing() {
        return this.flashing;
    }

    public void setFlashing(boolean flashing) {
        this.flashing = flashing;
    }

    public ContentDisplay getContentDisplay() {
        return this.contentDisplay;
    }

    public void setContentDisplay(ContentDisplay contentDisplay) {
        this.contentDisplay = contentDisplay;
    }

    public Pos getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Pos alignment) {
        this.alignment = alignment;
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding;
    }

    public String getCellStyleClass() {
        return this.cellStyleClass;
    }

    public void setCellStyleClass(String cellStyleClass) {
        this.cellStyleClass = cellStyleClass;
    }

    public GenericCellCustomizer<S, T> getCellCustomizer() {
        return this.cellCustomizer;
    }

    public void setCellCustomizer(GenericCellCustomizer<S, T> cellCustomizer) {
        this.cellCustomizer = cellCustomizer;
    }

    protected static class GenericDisplayCell<S, T>
    extends TableCell<S, T> {
        private final LocalService localService;
        private final TimeService timeService;
        private final ColorFlash flash;
        private final GenericCellCustomizer<S, T> customizer;
        private boolean rowIsChanging;

        public GenericDisplayCell(ApplicationContext applicationContext, boolean flashing, GenericCellCustomizer<S, T> customizer) {
            this.customizer = customizer;
            this.localService = applicationContext.getService(LocalService.class);
            this.flash = flashing ? applicationContext.getService(ColorFlashFactory.class).getFlash(this) : null;
            this.timeService = applicationContext.getService(TimeService.class);
            this.rowIsChanging = false;
        }

        @Override
        protected void updateItem(T item, boolean empty) {
            Object oldItem = this.getItem();
            super.updateItem(item, empty);
            this.setGraphic(null);
            this.setText(null);
            this.setTooltip(null);
            this.setOnMouseEntered(null);
            if (this.flash != null) {
                this.flash.abort();
            }
            if (item != null && !empty) {
                this.setText(this.getText(item));
                this.setGraphic(this.getGraphic(item));
                String tooltipText = this.getTooltipText(item);
                if (tooltipText != null) {
                    this.setOnMouseEntered(event -> SHARED_TOOLTIP.setText(tooltipText));
                    this.setTooltip(SHARED_TOOLTIP);
                }
                if (!this.rowIsChanging && oldItem != null && !item.equals(oldItem) && this.flash != null) {
                    this.flash.flash();
                }
            }
            if (this.customizer != null) {
                this.customizer.customizeTableCell(this);
            }
        }

        @Override
        public void updateIndex(int i) {
            if (this.flash != null) {
                this.flash.abort();
            }
            this.rowIsChanging = true;
            super.updateIndex(i);
            this.rowIsChanging = false;
            Optional<S> rowValue = this.getRowValue();
            if (this.flash != null && rowValue.orElse(null) instanceof TimeStampProvider && !this.isEmpty()) {
                TimeStampProvider timeStampProvider = (TimeStampProvider)rowValue.get();
                DateTime serverTime = this.timeService.getServerTime();
                if (serverTime.isBefore(timeStampProvider.getTimeStamp().plusSeconds(1))) {
                    this.flash.flash();
                }
            }
        }

        private String getDefaultText(T item) {
            if (item instanceof String) {
                return (String)item;
            }
            if (item instanceof Long) {
                return Long.toString((Long)item);
            }
            if (item instanceof Integer) {
                return Integer.toString((Integer)item);
            }
            if (item instanceof DisplayName) {
                return ((DisplayName)item).getDisplayName();
            }
            if (item instanceof DateTime) {
                return this.localService.formatDateTime((DateTime)item);
            }
            if (item instanceof LongDisplayValue) {
                return this.localService.formatLongDisplayValue((LongDisplayValue)item);
            }
            return null;
        }

        protected String getText(T item) {
            String defaultText = this.getDefaultText(item);
            return this.customizer != null ? this.customizer.getText(item, this.getRowValue().orElse(null), defaultText) : defaultText;
        }

        private Optional<S> getRowValue() {
            int i = this.getIndex();
            if (i >= 0 && this.getTableView() != null && i < this.getTableView().getItems().size() && this.getTableView().getItems().get(i) != null) {
                return Optional.of(this.getTableView().getItems().get(i));
            }
            return Optional.empty();
        }

        private Node getDefaultGraphic(T item) {
            Image image;
            if (item instanceof DisplayImage && (image = ImageFactory.getImage((DisplayImage)item, "/com/deutscheboerse/comxerv/comtrader/flags/64x64/00_default.png")) != null) {
                return new AutoScaleImageView(image, this);
            }
            return null;
        }

        protected Node getGraphic(T item) {
            Node defaultGraphic = this.getDefaultGraphic(item);
            return this.customizer != null ? this.customizer.getGraphic(item, this.getRowValue().orElse(null), defaultGraphic) : defaultGraphic;
        }

        private String getDefaultTooltipText(T item) {
            return item instanceof DisplayDescription ? ((DisplayDescription)item).getDescription() : null;
        }

        protected String getTooltipText(T item) {
            String defaultTooltipText = this.getDefaultTooltipText(item);
            return this.customizer != null ? this.customizer.getTooltipText(item, this.getRowValue().orElse(null), defaultTooltipText) : defaultTooltipText;
        }
    }
}

