/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.market;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractMarketMakerPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.market.AbstractMarketOrderWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.ColorInvalidationListener;
import com.deutscheboerse.ui.jfx.util.binding.WeakObservableValue;
import java.util.EnumMap;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class MarketButtonCellFactory
implements Callback<TableColumn<AbstractMarketOrderWrapper, AbstractMarketOrderWrapper>, TableCell<AbstractMarketOrderWrapper, AbstractMarketOrderWrapper>> {
    private UpDown upDown;
    private Direction direction;

    @Override
    public TableCell<AbstractMarketOrderWrapper, AbstractMarketOrderWrapper> call(TableColumn<AbstractMarketOrderWrapper, AbstractMarketOrderWrapper> tDirectionTableColumn) {
        MarketButtonTableCell ownMarketPanelTableViewButton = new MarketButtonTableCell(this.upDown, this.direction);
        ColorInvalidationListener.registerForColoredTableColumn(tDirectionTableColumn, ownMarketPanelTableViewButton);
        return ownMarketPanelTableViewButton;
    }

    public UpDown getUpDown() {
        return this.upDown;
    }

    public void setUpDown(UpDown upDown) {
        this.upDown = upDown;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    protected static final class MarketButtonTableCell
    extends TableCell<AbstractMarketOrderWrapper, AbstractMarketOrderWrapper> {
        private final UpDown upDown;
        private final Direction direction;
        private final BooleanProperty disableButton;

        public MarketButtonTableCell(UpDown upDown, Direction direction) {
            this.upDown = upDown;
            this.direction = direction;
            this.disableButton = new SimpleBooleanProperty(true);
        }

        @Override
        protected void updateItem(AbstractMarketOrderWrapper item, boolean empty) {
            super.updateItem(item, empty);
            if (empty || item == null) {
                this.setGraphic(null);
                this.disableButton.unbind();
                this.disableButton.setValue(true);
            } else {
                Button button = new Button();
                button.setGraphic(new IconView(this.upDown.getIconStyleClass()));
                button.setOnAction(event -> this.stepQuote());
                this.disableButton.bind(BooleanExpression.booleanExpression(new WeakObservableValue<Boolean>(item.submittingProperty())).and(this.getStepSizeValid()));
                button.disableProperty().bind(this.disableButton);
                this.setGraphic(button);
            }
        }

        private void stepQuote() {
            ObjectProperty<LongDisplayValue> localStepSize = this.getStepSize();
            LongDisplayValue currentStepSize = this.upDown == UpDown.UP ? (LongDisplayValue)localStepSize.getValue() : ((LongDisplayValue)localStepSize.getValue()).invert();
            EnumMap<Direction, LongDisplayValue> modification = new EnumMap<Direction, LongDisplayValue>(Direction.class);
            modification.put(this.direction, currentStepSize);
            ((AbstractMarketOrderWrapper)this.getItem()).applyStep(modification);
        }

        private ObjectProperty<LongDisplayValue> getStepSize() {
            return ((AbstractMarketMakerPanel)this.getTableView().getParent()).getContractTree().getProductStepSizes().get(((AbstractMarketOrderWrapper)this.getItem()).getOrderbook().getContract().getProduct()).valueProperty();
        }

        private ReadOnlyBooleanProperty getStepSizeValid() {
            return ((AbstractMarketMakerPanel)this.getTableView().getParent()).getContractTree().getProductStepSizes().get(((AbstractMarketOrderWrapper)this.getItem()).getOrderbook().getContract().getProduct()).validProperty();
        }
    }

    protected static enum UpDown {
        UP("button-step-up"),
        DOWN("button-step-down");

        private final String styleClass;

        private UpDown(String styleClass) {
            this.styleClass = styleClass;
        }

        public String getIconStyleClass() {
            return this.styleClass;
        }
    }
}

