/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntryRow;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryType;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.ExtendedOrderbookTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook.ExtendedOrderbookEntryTooltip;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook.OrderbookEntryTableCellClickHandler;
import com.deutscheboerse.comxerv.comtrader.jfx.service.SelectedCellService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.trade.TradingActionService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.action.OrderActionsService;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import java.util.LinkedList;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.input.MouseEvent;

public class AbstractExtendedOrderbookEntryTableCell<T>
extends TableCell<ExtendedOrderbookEntryRow, T> {
    protected static final String DEFAULT_TABLECELL_STYLE_CLASS = "table-cell";
    protected static final String BASE_STYLE_CLASS = "extendedOrderbookEntriesTableCell";
    protected static final String OWN_ORDER_TEXT_STYLE_CLASS = "ownOrder";
    protected static final String MBR_ORDER_TEXT_STYLE_CLASS = "mbrOrder";
    protected static final String BAL_ORDER_TEXT_STYLE_CLASS = "balOrder";
    protected static final String ICB_ORDER_TEXT_STYLE_CLASS = "icbOrder";
    protected static final String NON_TRADABLE_ORDER_TEXT_STYLE_CLASS = "nonTradableOrder";
    protected final ApplicationContext applicationContext;
    protected final boolean displaysAccumulatedValue;
    protected final boolean adminPanel;
    protected final ExtendedOrderbookEntryTooltip tooltip;
    protected final DataModel<Long, Order> orderDataModel;
    protected final ExtendedOrderbookTableView tableView;
    protected final Direction direction;
    private final EventHandler<MouseEvent> selectionListener;
    private final TradingActionService tradingActionService;
    protected final SelectedCellService selectedCellService;

    public AbstractExtendedOrderbookEntryTableCell(ApplicationContext applicationContext, ExtendedOrderbookTableView tableView, boolean displaysAccumulatedValue, Direction direction) {
        this.tableView = tableView;
        this.direction = direction;
        this.orderDataModel = applicationContext.getDataModel(Order.class);
        this.displaysAccumulatedValue = displaysAccumulatedValue;
        this.tooltip = applicationContext.getService(ExtendedOrderbookEntryTooltip.class);
        this.adminPanel = tableView.isAdminPanel();
        this.applicationContext = applicationContext;
        this.setOnMouseEntered(this::onMouseEntered);
        this.selectedCellService = applicationContext.getService(SelectedCellService.class);
        this.selectionListener = this.selectedCellService.getListenerAsMouseEventHandler(this);
        this.tradingActionService = applicationContext.getService(TradingActionService.class);
    }

    private void onMouseEntered(MouseEvent event) {
        this.tooltip.applyNewExtendedOrderbookEntry(this.getEntry(this.getIndex()));
    }

    @Override
    public void updateIndex(int i) {
        super.updateIndex(i);
        ExtendedOrderbookEntry entry = this.getEntry(i);
        this.updateCellStyle(entry);
        this.updateClickHandlers(entry);
        this.updateTooltip(entry);
    }

    @Override
    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        this.selectedCellService.update(this);
    }

    private ExtendedOrderbookEntry getEntry(int i) {
        ObservableList items = this.tableView.getItems();
        return i >= 0 && i < items.size() && items.get(i) != null ? ((ExtendedOrderbookEntryRow)items.get(i)).getOrderbookEntry(this.direction) : null;
    }

    private void updateTooltip(ExtendedOrderbookEntry entry) {
        if (entry != null) {
            this.setTooltip(this.tooltip);
        } else {
            this.setTooltip(null);
        }
    }

    private void updateCellStyle(ExtendedOrderbookEntry entry) {
        LinkedList<String> styleClasses = new LinkedList<String>();
        styleClasses.add(DEFAULT_TABLECELL_STYLE_CLASS);
        styleClasses.add(BASE_STYLE_CLASS);
        if (entry != null) {
            Order order;
            if (OrderType.BALANCE.equals(entry.getOrderType())) {
                styleClasses.add(BAL_ORDER_TEXT_STYLE_CLASS);
            } else if (!this.adminPanel && entry.isContainsOwnUserOrder()) {
                styleClasses.add(OWN_ORDER_TEXT_STYLE_CLASS);
            } else if (!this.adminPanel && entry.isContainsOwnOrder()) {
                styleClasses.add(MBR_ORDER_TEXT_STYLE_CLASS);
            }
            if (!(this.adminPanel || this.displaysAccumulatedValue || entry.getTradable())) {
                styleClasses.add(NON_TRADABLE_ORDER_TEXT_STYLE_CLASS);
            }
            if (!this.adminPanel && this.displaysAccumulatedValue && !entry.isAccumulatedTradable()) {
                styleClasses.add(NON_TRADABLE_ORDER_TEXT_STYLE_CLASS);
            }
            if (this.adminPanel && (order = this.orderDataModel.findById(entry.getOrderId())) != null && order.getOrderType() == OrderType.ICEBERG) {
                styleClasses.add(ICB_ORDER_TEXT_STYLE_CLASS);
            }
        }
        StyleUtil.setStyleClass(this, styleClasses);
    }

    private void updateClickHandlers(ExtendedOrderbookEntry entry) {
        if (entry == null) {
            this.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.selectionListener);
            this.removeEventHandler(MouseEvent.DRAG_DETECTED, this.selectionListener);
        } else {
            this.addEventHandler(MouseEvent.MOUSE_CLICKED, this.selectionListener);
            this.addEventHandler(MouseEvent.DRAG_DETECTED, this.selectionListener);
        }
        OrderbookEntryTableCellClickHandler mouseEventHandler = entry == null || this.adminPanel ? this::handleMouseEventEmpty : (this.displaysAccumulatedValue ? new OrderbookEntryTableCellClickHandler(this.applicationContext, entry, (Node)this, OrderActionsService.PreparedOrderQuantitySelector.ACCUMULATED) : new OrderbookEntryTableCellClickHandler(this.applicationContext, entry, (Node)this, OrderActionsService.PreparedOrderQuantitySelector.FIRM));
        this.setOnMouseClicked(mouseEventHandler);
        this.setOnDragDetected(mouseEventHandler);
    }

    private void handleMouseEventEmpty(MouseEvent mouseEvent) {
        this.tradingActionService.doAction(mouseEvent, this.tableView.getOrderbook(), this.direction, OrderbookEntryType.NOT_AGGREGATED);
    }
}

