/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.CommonOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.jfx.service.flash.ColorFlash;
import com.deutscheboerse.comxerv.comtrader.jfx.service.flash.ColorFlashFactory;
import javafx.geometry.Pos;
import javafx.scene.control.Label;

public class EntryTextWithFlash
extends Label {
    private static final String OWN_USR_ORDER_TEXT_STYLE_CLASS = "ownOrder";
    private static final String OWN_MBR_ORDER_TEXT_STYLE_CLASS = "mbrOrder";
    private static final String NOT_OWN_ORDER_TEXT_STYLE_CLASS = "notOwnOrder";
    private static final String BAL_ORDER_TEXT_STYLE_CLASS = "balOrder";
    private static final String BASE_STYLE_CLASS = "subEntryCell";
    private static final String ODD_STYLE_CLASS = "odd";
    private static final String EVEN_STYLE_CLASS = "even";
    private final ColorFlash flash;
    private CommonOrderbookEntry entry;

    protected EntryTextWithFlash(ApplicationContext applicationContext) {
        this.flash = applicationContext.getService(ColorFlashFactory.class).getFlash(this);
        this.setMaxWidth(Double.MAX_VALUE);
        this.setAlignment(Pos.CENTER);
    }

    public void applyValue(CommonOrderbookEntry entry, String textValue) {
        this.entry = entry;
        this.setText(textValue);
        this.setOnMouseEntered(null);
    }

    public void applyStyleClass(boolean isOdd) {
        String oddEvenStyleClass;
        String typeStyleClass = this.entry.isContainsOwnUserOrder() ? OWN_USR_ORDER_TEXT_STYLE_CLASS : (this.entry.isContainsOwnOrder() ? OWN_MBR_ORDER_TEXT_STYLE_CLASS : NOT_OWN_ORDER_TEXT_STYLE_CLASS);
        boolean containsBalOrder = this.entry.isContainsBalOrder();
        String string = oddEvenStyleClass = isOdd ? ODD_STYLE_CLASS : EVEN_STYLE_CLASS;
        if (containsBalOrder) {
            this.getStyleClass().setAll((String[])new String[]{BASE_STYLE_CLASS, BAL_ORDER_TEXT_STYLE_CLASS, oddEvenStyleClass, typeStyleClass});
        } else {
            this.getStyleClass().setAll((String[])new String[]{BASE_STYLE_CLASS, oddEvenStyleClass, typeStyleClass});
        }
    }

    public void flash() {
        this.flash.flash();
    }

    public void abortFlash() {
        this.flash.abort();
    }
}

