/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javafx.scene.control.Tooltip;
import javafx.stage.WindowEvent;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;

@Singleton
public class LastTradeTooltip
extends Tooltip {
    private final TimeService timeService;
    private Orderbook orderbook;

    @Inject
    public LastTradeTooltip(TimeService timeService) {
        this.timeService = timeService;
        this.setOnShowing(this::onShowing);
    }

    private void onShowing(WindowEvent windowEvent) {
        if (this.orderbook != null) {
            DateTime serverTime = this.timeService.getServerTime();
            DateTime lastTradeTime = this.orderbook.getLastTradeTime();
            StyleUtil.addStyleClass(this, "tooltip");
            if (lastTradeTime != null) {
                Period period = new Period((ReadableInstant)lastTradeTime, (ReadableInstant)serverTime, PeriodType.time());
                String hours = Integer.toString(period.getHours());
                String minutes = Integer.toString(period.getMinutes());
                String seconds = Integer.toString(period.getSeconds());
                this.setText(Util.getLabel("orderbookPanel_lastTrade_tooltip", hours, minutes, seconds));
                this.setAnchorY(this.getAnchorY() + 7.0);
            } else {
                this.setText(Util.getLabel("orderbookPanel_lastTradeNotAvailable_tooltip"));
                this.setAnchorY(this.getAnchorY() + 7.0);
            }
        } else {
            windowEvent.consume();
        }
    }

    public Orderbook getOrderbook() {
        return this.orderbook;
    }

    public void setOrderbook(Orderbook orderbook) {
        this.orderbook = orderbook;
    }
}

