/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.tree;

import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;

public class SearchBox
extends HBox {
    @FXML
    private TextField searchText;
    @FXML
    private Button clearButton;
    @FXML
    private Button switchButton;
    @FXML
    private Label switchButtonLabel;
    private Mode mode;
    private final ObjectProperty<Optional<Predicate<Object>>> filter = new SimpleObjectProperty<Optional<Optional<Predicate<Object>>>>(Optional.empty());

    public SearchBox() {
        this.mode = Mode.CONTRACT_SEARCH;
        FXMLLoaderWithContext.loadCustomComponent(this);
        this.searchText.setText("");
        this.useContractSearch();
        this.clearButton.visibleProperty().bind(this.searchText.textProperty().isNotEmpty());
        this.searchText.textProperty().addListener(observable2 -> this.reloadFilter());
    }

    private void useContractSearch() {
        this.mode = Mode.CONTRACT_SEARCH;
        this.switchButtonLabel.setText(Mode.CONTRACT_SEARCH.getButtonText());
        this.switchButton.getTooltip().setText(Util.getLabel("commons_searchContract"));
    }

    private void useProductSearch() {
        this.mode = Mode.PRODUCT_SEARCH;
        this.switchButtonLabel.setText(Mode.PRODUCT_SEARCH.getButtonText());
        this.switchButton.getTooltip().setText(Util.getLabel("commons_searchProduct"));
    }

    public void showSwitchButton(boolean show) {
        this.switchButton.setVisible(show);
    }

    @FXML
    public void clear() {
        this.searchText.setText("");
        this.searchText.requestFocus();
    }

    @FXML
    public void switchMode() {
        String oldSearchText = this.searchText.getText();
        this.searchText.setText("");
        this.searchText.requestFocus();
        if (this.mode == Mode.CONTRACT_SEARCH) {
            this.useProductSearch();
        } else {
            this.useContractSearch();
        }
        this.searchText.setText(oldSearchText);
    }

    private void reloadFilter() {
        if (this.searchText.getText() == null || this.searchText.getText().isEmpty()) {
            this.filter.setValue(Optional.empty());
        } else {
            this.filter.setValue(Optional.of(this::filter));
        }
    }

    private boolean filter(Object o) {
        if (this.mode == Mode.PRODUCT_SEARCH && o instanceof Product) {
            return ((Product)o).getDisplayName().toLowerCase().contains(this.searchText.getText().toLowerCase());
        }
        if (this.mode == Mode.CONTRACT_SEARCH && o instanceof Contract) {
            return ((Contract)o).getName().toLowerCase().contains(this.searchText.getText().toLowerCase());
        }
        if (o instanceof String) {
            return ((String)o).toLowerCase().contains(this.searchText.getText().toLowerCase());
        }
        return true;
    }

    public ReadOnlyObjectProperty<Optional<Predicate<Object>>> searchFilterProperty() {
        return this.filter;
    }

    private static enum Mode {
        CONTRACT_SEARCH("C"),
        PRODUCT_SEARCH("P");

        private String buttonText;

        private Mode(String buttonText) {
            this.buttonText = buttonText;
        }

        public String getButtonText() {
            return this.buttonText;
        }
    }
}

