/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui;

import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.AbstractOverrideGuiStrategy;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;
import org.json.simple.JSONObject;

public class TableViewOverrideGuiStrategy<X>
extends AbstractOverrideGuiStrategy<TableView<X>, TableColumn<X, ?>> {
    public TableViewOverrideGuiStrategy() {
        super(TableView::getColumns, TableColumnBase::getId);
    }

    @Override
    public void apply(TableView<X> fieldValue, String overrideId, JSONObject json) {
        super.apply(fieldValue, overrideId, json);
        Map<String, List<JSONObject>> overrides = this.groupByKey(json, overrideId);
        for (Map.Entry<String, List<JSONObject>> overrideEntry : overrides.entrySet()) {
            boolean isHide = overrideEntry.getValue().stream().map(override -> override.get("op")).anyMatch("hide"::equals);
            boolean isShow = overrideEntry.getValue().stream().map(override -> override.get("op")).anyMatch("show"::equals);
            Optional<Number> index = overrideEntry.getValue().stream().map(override -> override.get("op")).filter(Number.class::isInstance).map(Number.class::cast).findFirst();
            Optional<TableColumn> tableColumn = fieldValue.getColumns().stream().filter(column -> ((String)overrideEntry.getKey()).equals(column.getId())).findFirst();
            if (isHide && tableColumn.isPresent()) {
                tableColumn.get().setVisible(false);
            }
            if (isShow && tableColumn.isPresent()) {
                tableColumn.get().setVisible(true);
            }
            if (!index.isPresent() || !tableColumn.isPresent()) continue;
            fieldValue.getColumns().remove(tableColumn.get());
            fieldValue.getColumns().add(index.get().intValue(), tableColumn.get());
        }
    }
}

