/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service;

import com.deutscheboerse.comxerv.comtrader.jfx.service.Theme;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomTheme
extends Theme {
    private static final Logger LOG = LoggerFactory.getLogger(CustomTheme.class);
    private byte[] data;

    public CustomTheme(String name, String cssPath, byte[] data) {
        super(name, cssPath, () -> CustomTheme.readCss(data));
        this.data = Arrays.copyOf(data, data.length);
    }

    private static List<String> readCss(byte[] data) {
        List<String> list;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        try {
            list = IOUtils.readLines((InputStream)inputStream, StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("Could not read color theme.");
                return Collections.emptyList();
            }
        }
        ((InputStream)inputStream).close();
        return list;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public boolean isDeletable() {
        return true;
    }
}

