/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.ContentTab;
import com.deutscheboerse.comxerv.comtrader.jfx.components.ConvertableToFxml;
import com.deutscheboerse.comxerv.comtrader.jfx.components.TabPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.service.StageWithSuffix;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileManager;
import com.deutscheboerse.comxerv.comtrader.service.profile.StageState;
import com.deutscheboerse.comxerv.comtrader.service.profile.TabState;
import com.deutscheboerse.comxerv.comtrader.service.profile.UserProfile;
import com.deutscheboerse.ui.jfx.util.StageUtil;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.stage.Stage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowStateStorage {
    private static final Logger LOG = LoggerFactory.getLogger(WindowStateStorage.class);
    private final ProfileManager profileManager;
    private final StageUtil stageUtil;

    public WindowStateStorage(ApplicationContext appContext) {
        this.profileManager = appContext.getService(ProfileManager.class);
        this.stageUtil = appContext.getService(StageUtil.class);
    }

    public void restoreStageState(StageWithSuffix stageWithSuffix) {
        Stage stage = stageWithSuffix.getStage();
        String suffix = stageWithSuffix.getSuffix();
        StageState stageState = this.profileManager.getCurrentProfile().getStageState(suffix);
        if (stageState != null) {
            stage.setX(stageState.getX());
            stage.setY(stageState.getY());
            stage.setHeight(stageState.getHeight());
            stage.setWidth(stageState.getWidth());
            stage.setFullScreen(stageState.isFullScreen());
            stage.setMaximized(stageState.isMaximized());
            this.stageUtil.moveStageToVisibleArea(stage);
        } else {
            stage.setX(0.0);
            stage.setY(0.0);
            stage.setWidth(800.0);
            stage.setHeight(600.0);
            stage.setFullScreen(false);
            stage.setMaximized(false);
        }
    }

    protected StageState getStageState(StageWithSuffix stageWithSuffix) {
        String suffix = stageWithSuffix.getSuffix();
        Stage stage = stageWithSuffix.getStage();
        StageState storedStageState = this.profileManager.getCurrentProfile().getStageState(suffix);
        StageState stageState = storedStageState == null ? new StageState() : storedStageState;
        stageState.setX((int)stage.getX());
        stageState.setY((int)stage.getY());
        stageState.setWidth((int)stage.getWidth());
        stageState.setHeight((int)stage.getHeight());
        stageState.setFullScreen(stage.isFullScreen());
        stageState.setMaximized(stage.isMaximized());
        return stageState;
    }

    public void storeFXmlContent(TabPanel tabPanel, String suffix) {
        StageState stageState = this.getStageState(tabPanel, suffix);
        this.profileManager.getCurrentProfile().setStageState(suffix, stageState);
    }

    private StageState getStageState(TabPanel tabPanel, String suffix) {
        StageState storedStageState = this.profileManager.getCurrentProfile().getStageState(suffix);
        StageState stageState = storedStageState == null ? new StageState() : storedStageState;
        ArrayList<TabState> tabs = Lists.newArrayList();
        tabPanel.getTabs().stream().filter(tab -> tab instanceof ContentTab).forEach(tab -> {
            ContentTab contentTab = (ContentTab)tab;
            TabState tabState = new TabState();
            Node tabContent = contentTab.getContent();
            if (tabContent instanceof ConvertableToFxml) {
                tabState.setContent(this.buildFxml((ConvertableToFxml)((Object)tabContent)));
            }
            tabState.setTitle(StringEscapeUtils.escapeJava(contentTab.getText()));
            tabs.add(tabState);
        });
        stageState.setTabs(tabs);
        stageState.setSelectedTab(tabPanel.getSelectionModel().getSelectedIndex());
        stageState.setVisibleTabs(tabPanel.getVisibleTabs());
        return stageState;
    }

    public void loadFXmlContent(ApplicationContext appContext, String suffix, TabPanel target) {
        StageState storedStageState = this.profileManager.getCurrentProfile().getStageState(suffix);
        if (storedStageState != null) {
            storedStageState.getTabs().stream().map(tabState -> this.createContentTab(tabState.getContent(), StringEscapeUtils.unescapeJava(tabState.getTitle()), appContext)).forEach(target.getTabs()::add);
            int selectedTab = storedStageState.getSelectedTab();
            if (selectedTab < target.getTabs().size()) {
                target.getSelectionModel().select(selectedTab);
            }
            target.setVisibleTabs(storedStageState.isVisibleTabs());
        }
        target.addPlusTab(true);
    }

    public void saveStageStates(Set<StageWithSuffix> stages) {
        UserProfile currentProfile = this.profileManager.getCurrentProfile();
        currentProfile.clearStages();
        stages.stream().forEach(stageWithSuffix -> currentProfile.setStageState(stageWithSuffix.getSuffix(), this.getStageState((StageWithSuffix)stageWithSuffix)));
    }

    protected Set<String> getSuffixSet() {
        return new HashSet<String>(this.profileManager.getCurrentProfile().getStages().keySet());
    }

    private void addImports(StringBuilder fxmlContent) {
        fxmlContent.append("<?import javafx.scene.control.*?>\n");
        fxmlContent.append("<?import javafx.scene.layout.*?>\n");
        fxmlContent.append("<?import javafx.scene.shape.*?>\n");
        fxmlContent.append("<?import com.deutscheboerse.comxerv.comtrader.jfx.components.*?>\n");
        fxmlContent.append("<?import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.*?>\n");
        fxmlContent.append("<?import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.*?>\n");
    }

    private String buildFxml(ConvertableToFxml rootNode) {
        return rootNode.generateFxml().replaceAll(">", ">\n");
    }

    private ContentTab createContentTab(String content, String title, ApplicationContext appContext) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content: {}", (Object)content.replaceAll("\\s+", " "));
            }
            File tmpFxmlFile = File.createTempFile("fxml_", ".fxml");
            LOG.debug("created tmp-file: {}", (Object)tmpFxmlFile.getAbsoluteFile());
            StringBuilder builder = new StringBuilder();
            this.addImports(builder);
            builder.append(content);
            FileUtils.write(tmpFxmlFile, (CharSequence)builder.toString(), StandardCharsets.UTF_8);
            ContentTab contentTab = new ContentTab(appContext);
            Parent tabContent = FXMLLoaderWithContext.load(appContext, tmpFxmlFile.toURI().toURL());
            this.deleteFile(tmpFxmlFile);
            contentTab.setContent(tabContent);
            contentTab.registerStorableComponents();
            contentTab.setText(title);
            return contentTab;
        }
        catch (IOException e) {
            LOG.error("Could not load tab content FXML", e);
            throw new RuntimeException(e);
        }
    }

    private void deleteFile(File file) {
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            LOG.error("Could not delete temporary file {}", (Object)file.getAbsolutePath());
        }
    }
}

