/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.style;

import com.deutscheboerse.comxerv.comtrader.jfx.service.CustomTheme;
import com.deutscheboerse.comxerv.comtrader.jfx.service.Theme;
import com.deutscheboerse.comxerv.comtrader.jfx.service.style.ColorThemeService;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsLoadedEvent;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.comxerv.comtrader.util.ApplicationPropertiesUtil;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Scene;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ColorThemeServiceImpl
implements ColorThemeService {
    private static final String CUSTOM_THEME_CSS_PATH_SETTINS_PREFIX = ColorThemeServiceImpl.class.getName() + "$customThemeCssPath$";
    private static final String TEMP_FILE_RESOURCE_PREFIX = "file:///";
    private static final String DEFAULT_THEME_NAME = ApplicationPropertiesUtil.getApplicationProperty("default_theme_name");
    private static final String THEME_PROPERTIES_NAME_KEY = "name";
    private static final String THEME_PROPERTIES_PATH_KEY = "path";
    private static final String CUSTOM_THEME_NAMES_SEPARATOR = ",";
    private static final Logger LOG = LoggerFactory.getLogger(ColorThemeServiceImpl.class);
    private static final SettingsService.Settings<String> SELECTED_THEME_NAME_SETTINGS = new SettingsService.Settings<Object>("selectedThemeName", null);
    private static final SettingsService.Settings<String> SELECTED_THEME_PATH_SETTINGS = new SettingsService.Settings<Object>("selectedThemePath", null);
    private static final SettingsService.Settings<Boolean> SELECTED_THEME_IS_CUSTOM_SETTINGS = new SettingsService.Settings<Boolean>("selectedThemeIsCustom", false);
    private static final SettingsService.Settings<String> CUSTOM_THEME_NAMES_SETTINGS = new SettingsService.Settings<String>("customThemeNames", "");
    private Theme defaultTheme;
    private final List<Theme> availableThemes;
    private final ObjectProperty<Theme> currentTheme;
    private final Set<Scene> registeredScenes;
    private final SettingsService settingsService;

    @Inject
    public ColorThemeServiceImpl(SettingsService settingsService, EventBus eventBus) {
        this.settingsService = settingsService;
        this.registeredScenes = Collections.newSetFromMap(new WeakHashMap());
        this.availableThemes = new ArrayList<Theme>();
        this.loadDefaultThemes();
        this.loadCustomThemes();
        this.currentTheme = new SimpleObjectProperty<Theme>(this.getDefaultTheme());
        eventBus.register(this);
    }

    @Subscribe
    public void handleSettingsLoaded(SettingsLoadedEvent settingsLoadedEvent) {
        Iterator<Theme> themeIterator = this.availableThemes.iterator();
        while (themeIterator.hasNext()) {
            if (!themeIterator.next().isDeletable()) continue;
            themeIterator.remove();
        }
        this.loadCustomThemes();
        this.storeConfiguredTheme(this.getConfiguredTheme());
        this.switchToTheme(this.getConfiguredTheme());
    }

    private void loadDefaultThemes() {
        URL themePropertiesUrl = ColorThemeServiceImpl.class.getResource("/guisettings/themes/color-theme.properties");
        if (themePropertiesUrl == null) {
            LOG.error("Cannot load default themes, property file not found.");
            return;
        }
        Properties themeProperties = new Properties();
        try (InputStream inputStream = themePropertiesUrl.openStream();){
            themeProperties.load(inputStream);
            List<Theme> themesInPackage = this.readThemesFromProperties(themeProperties);
            this.availableThemes.addAll(themesInPackage);
            if (this.defaultTheme == null && !this.availableThemes.isEmpty()) {
                this.defaultTheme = this.availableThemes.get(0);
            }
        }
        catch (IOException e) {
            LOG.error("Could not read color theme configuration from " + themePropertiesUrl.toString() + ". Themes from this package will not be available.", e);
        }
    }

    private List<Theme> readThemesFromProperties(Properties properties) {
        ArrayList<Theme> themes = new ArrayList<Theme>();
        for (String key : properties.stringPropertyNames()) {
            String[] keyParts = key.split("\\.");
            if (keyParts.length != 2 || !keyParts[1].equals(THEME_PROPERTIES_NAME_KEY)) continue;
            String themeId = keyParts[0];
            String themeName = properties.getProperty(key);
            String themePath = properties.getProperty(themeId + ".path");
            if (themeName == null || themeName.isEmpty() || themePath == null || themePath.isEmpty()) continue;
            Theme theme = new Theme(themeName, themePath);
            themes.add(theme);
            if (!themeName.equals(DEFAULT_THEME_NAME)) continue;
            this.defaultTheme = theme;
        }
        return themes;
    }

    private void loadCustomThemes() {
        for (String customThemeName : this.getCustomThemeNames()) {
            CustomTheme customTheme = this.loadCustomTheme(customThemeName);
            if (customTheme != null) {
                this.availableThemes.add(customTheme);
                continue;
            }
            LOG.error("Could not load custom theme " + customThemeName);
        }
    }

    @Override
    public Theme getCurrentTheme() {
        Theme theme = (Theme)this.currentTheme.get();
        if (theme != null && theme.isValid()) {
            return theme;
        }
        return this.getDefaultTheme();
    }

    @Override
    public Theme getDefaultTheme() {
        return this.defaultTheme;
    }

    @Override
    public Theme getConfiguredTheme() {
        String themeName = this.settingsService.loadSettings(SELECTED_THEME_NAME_SETTINGS);
        if (themeName == null) {
            return this.getDefaultTheme();
        }
        boolean isCustomTheme = this.settingsService.loadSettings(SELECTED_THEME_IS_CUSTOM_SETTINGS);
        if (isCustomTheme) {
            return Optional.ofNullable(this.getCustomThemeFromAvailableThemes(themeName)).orElse(this.getDefaultTheme());
        }
        String themePath = this.settingsService.loadSettings(SELECTED_THEME_PATH_SETTINGS);
        if (!this.resourceExists(themePath)) {
            return this.getDefaultTheme();
        }
        return new Theme(themeName, themePath);
    }

    private boolean resourceExists(String themePath) {
        if (themePath == null) {
            return false;
        }
        if (!((String)themePath).startsWith("/")) {
            themePath = "/" + (String)themePath;
        }
        return this.getClass().getResource((String)themePath) != null;
    }

    private Theme getCustomThemeFromAvailableThemes(String themeName) {
        for (Theme theme : this.availableThemes) {
            if (!(theme instanceof CustomTheme) || !themeName.equals(theme.getName())) continue;
            return theme;
        }
        return null;
    }

    @Override
    public void storeConfiguredTheme(Theme theme) {
        boolean isCustomTheme = theme instanceof CustomTheme;
        this.settingsService.storeSettings(SELECTED_THEME_NAME_SETTINGS, theme.getName());
        this.settingsService.storeSettings(SELECTED_THEME_IS_CUSTOM_SETTINGS, isCustomTheme);
        if (!isCustomTheme) {
            this.settingsService.storeSettings(SELECTED_THEME_PATH_SETTINGS, theme.getCssPath());
        }
    }

    @Override
    public List<Theme> getAvailableThemes() {
        return Collections.unmodifiableList(this.availableThemes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchToTheme(Theme theme) {
        for (Scene scene : this.registeredScenes) {
            this.switchSceneToTheme(theme, scene);
        }
        ObjectProperty<Theme> objectProperty = this.currentTheme;
        synchronized (objectProperty) {
            this.currentTheme.set(theme);
        }
    }

    private void switchSceneToTheme(Theme theme, Scene scene) {
        if (theme.getCssPath() != null && scene != null) {
            scene.getStylesheets().remove(((Theme)this.currentTheme.get()).getCssPath());
            scene.getStylesheets().add(theme.getCssPath());
        }
    }

    @Override
    public void registerSceneForThemeSwitching(Scene scene) {
        if (scene != null) {
            StyleUtil.addStylePath(scene, ((Theme)this.currentTheme.get()).getCssPath());
            StyleUtil.addStylePath(scene, "/com/deutscheboerse/comxerv/comtrader/jfx/style/style.css");
            StyleUtil.addStylePath(scene, "/com/deutscheboerse/comxerv/comtrader/jfx/style/icons.css");
            StyleUtil.addStylePath(scene, "/com/deutscheboerse/comxerv/comtrader/jfx/style/userCustomizable.css");
            this.registeredScenes.add(scene);
        }
    }

    @Override
    public Theme addCustomTheme(File sourceFile) throws IOException {
        byte[] bytes = FileUtils.readFileToByteArray(sourceFile);
        String themeName = FilenameUtils.removeExtension(sourceFile.getName());
        String themeTempFilePath = this.createTempThemeResourcePath(themeName, bytes);
        CustomTheme theme = new CustomTheme(themeName, themeTempFilePath, bytes);
        this.availableThemes.add(theme);
        this.addCustomTheme(theme);
        return theme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addThemeChangeListener(ChangeListener<Theme> listener) {
        ObjectProperty<Theme> objectProperty = this.currentTheme;
        synchronized (objectProperty) {
            this.currentTheme.addListener(listener);
        }
    }

    private void addCustomTheme(CustomTheme theme) {
        List<String> customThemeNames = this.getCustomThemeNames();
        this.storeCustomTheme(theme);
        customThemeNames.add(theme.getName());
        this.storeCustomThemeNames(customThemeNames);
    }

    private void storeCustomTheme(CustomTheme theme) {
        String themeName = theme.getName();
        SettingsService.Settings<byte[]> themeDataSettings = this.getThemeDataSettings(themeName);
        this.settingsService.storeSettings(themeDataSettings, theme.getData());
    }

    private SettingsService.Settings<byte[]> getThemeDataSettings(String themeName) {
        return new SettingsService.Settings<byte[]>(CUSTOM_THEME_CSS_PATH_SETTINS_PREFIX + themeName, new byte[0]);
    }

    private CustomTheme loadCustomTheme(String themeName) {
        SettingsService.Settings<byte[]> themeDataSettings = new SettingsService.Settings<byte[]>(CUSTOM_THEME_CSS_PATH_SETTINS_PREFIX + themeName, new byte[0]);
        byte[] customThemeData = this.settingsService.loadSettings(themeDataSettings);
        if (customThemeData != null && customThemeData.length > 0) {
            try {
                String tempFileForCustomTheme = this.createTempThemeResourcePath(themeName, customThemeData);
                return new CustomTheme(themeName, tempFileForCustomTheme, customThemeData);
            }
            catch (IOException e) {
                LOG.error("Could not write temp file for theme. ", e);
                return null;
            }
        }
        return null;
    }

    @Override
    public void removeCustomTheme(Theme theme) {
        if (this.getCurrentTheme().equals(theme)) {
            this.switchToTheme(this.defaultTheme);
        }
        this.availableThemes.remove(theme);
        List<String> customThemeNames = this.getCustomThemeNames();
        customThemeNames.remove(theme.getName());
        this.storeCustomThemeNames(customThemeNames);
    }

    private List<String> getCustomThemeNames() {
        String storedCustomThemeNames = this.settingsService.loadSettings(CUSTOM_THEME_NAMES_SETTINGS);
        return Lists.newArrayList(Splitter.on(CUSTOM_THEME_NAMES_SEPARATOR).omitEmptyStrings().trimResults().split(storedCustomThemeNames));
    }

    private void storeCustomThemeNames(List<String> customThemeNames) {
        String joinedThemeNames = Joiner.on(CUSTOM_THEME_NAMES_SEPARATOR).join(customThemeNames);
        this.settingsService.storeSettings(CUSTOM_THEME_NAMES_SETTINGS, joinedThemeNames);
    }

    private String createTempThemeResourcePath(String themeName, byte[] data) throws IOException {
        File tempCssFile = File.createTempFile(themeName, ".css");
        try (FileOutputStream fileOutputStream = new FileOutputStream(tempCssFile);){
            IOUtils.write(data, (OutputStream)fileOutputStream);
        }
        URL fileUrl = new URL(TEMP_FILE_RESOURCE_PREFIX + tempCssFile.getAbsolutePath());
        return fileUrl.toExternalForm();
    }
}

