/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.style;

import com.deutscheboerse.comxerv.comtrader.jfx.service.style.FontService;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsLoadedEvent;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;

@Singleton
public class FontServiceImpl
implements FontService {
    private FontService.FontFamily fontFamily;
    private FontService.FontSize fontSize;
    private FontService.VerticalBorder verticalBorder;
    private FontService.HorizontalBorder horizontalBorder;
    private FontService.CellPadding cellPadding;
    private FontService.PanelDivider panelDivider;
    private final SettingsService settingsService;
    private final Set<Scene> registeredScenes;
    protected static final SettingsService.Settings<FontService.FontFamily> FONT_FAMILY_SETTINGS = new SettingsService.Settings<FontService.FontFamily>("fontFamily", FontService.DEFAULT_FONT_FAMILY);
    protected static final SettingsService.Settings<FontService.FontSize> FONT_SIZE_SETTINGS = new SettingsService.Settings<FontService.FontSize>("fontSize", FontService.DEFAULT_FONT_SIZE);
    protected static final SettingsService.Settings<FontService.VerticalBorder> VERTICAL_BORDER_SETTINGS = new SettingsService.Settings<FontService.VerticalBorder>("verticalBorder", FontService.DEFAULT_VERTICAL_BORDER);
    protected static final SettingsService.Settings<FontService.HorizontalBorder> HORIZONTAL_BORDER_SETTINGS = new SettingsService.Settings<FontService.HorizontalBorder>("horizontalBorder", FontService.DEFAULT_HORIZONTAL_BORDER);
    protected static final SettingsService.Settings<FontService.CellPadding> CELL_PADDING_SETTINGS = new SettingsService.Settings<FontService.CellPadding>("cellPadding", FontService.DEFAULT_CELL_PADDING);
    protected static final SettingsService.Settings<FontService.PanelDivider> PANEL_DIVIDER_SETTINGS = new SettingsService.Settings<FontService.PanelDivider>("panelDivider", FontService.DEFAULT_PANEL_DEVIDER);
    private static final Set<String> FONT_SIZE_STYLE_CLASSES = Stream.of(FontService.FontSize.values()).map(FontService.FontSize::getMultiplierStyleClass).collect(Collectors.toSet());

    @Inject
    public FontServiceImpl(SettingsService settingsService, EventBus eventBus) {
        this.settingsService = settingsService;
        this.registeredScenes = Collections.newSetFromMap(new WeakHashMap());
        this.loadSettings();
        eventBus.register(this);
    }

    private void loadSettings() {
        this.fontFamily = this.settingsService.loadSettings(FONT_FAMILY_SETTINGS);
        this.fontSize = this.settingsService.loadSettings(FONT_SIZE_SETTINGS);
        this.verticalBorder = this.settingsService.loadSettings(VERTICAL_BORDER_SETTINGS);
        this.horizontalBorder = this.settingsService.loadSettings(HORIZONTAL_BORDER_SETTINGS);
        this.cellPadding = this.settingsService.loadSettings(CELL_PADDING_SETTINGS);
        this.panelDivider = this.settingsService.loadSettings(PANEL_DIVIDER_SETTINGS);
    }

    @Override
    public FontService.FontSize getFontSize() {
        return this.fontSize;
    }

    @Override
    public void setFontSize(FontService.FontSize fontSize) {
        this.fontSize = fontSize;
        this.settingsService.storeSettings(FONT_SIZE_SETTINGS, fontSize);
        this.applyFontToAllRegisteredScenes();
    }

    @Override
    public FontService.FontFamily getFontFamily() {
        return this.fontFamily;
    }

    @Override
    public void setFontFamily(FontService.FontFamily fontFamily) {
        this.fontFamily = fontFamily;
        this.settingsService.storeSettings(FONT_FAMILY_SETTINGS, fontFamily);
        this.applyFontToAllRegisteredScenes();
    }

    @Override
    public FontService.CellPadding getCellPadding() {
        return this.cellPadding;
    }

    @Override
    public void setCellPadding(FontService.CellPadding cellPadding) {
        this.cellPadding = cellPadding;
        this.settingsService.storeSettings(CELL_PADDING_SETTINGS, cellPadding);
        this.applyCellPaddingToAllScenes();
    }

    @Override
    public FontService.VerticalBorder getVerticalBorder() {
        return this.verticalBorder;
    }

    @Override
    public void setVerticalBorder(FontService.VerticalBorder verticalBorder) {
        this.verticalBorder = verticalBorder;
        this.settingsService.storeSettings(VERTICAL_BORDER_SETTINGS, verticalBorder);
        this.applyVerticalBorderToAllScenes();
    }

    @Override
    public FontService.HorizontalBorder getHorizontalBorder() {
        return this.horizontalBorder;
    }

    @Override
    public void setHorizontalBorder(FontService.HorizontalBorder hrizontalBorder) {
        this.horizontalBorder = hrizontalBorder;
        this.settingsService.storeSettings(HORIZONTAL_BORDER_SETTINGS, hrizontalBorder);
        this.applyHorizontalBorderToAllScenes();
    }

    @Override
    public FontService.PanelDivider getPanelDivider() {
        return this.panelDivider;
    }

    @Override
    public void setPanelDivider(FontService.PanelDivider selectedPanelDivider) {
        this.panelDivider = selectedPanelDivider;
        this.settingsService.storeSettings(PANEL_DIVIDER_SETTINGS, this.panelDivider);
        this.applyPanelDividerToAlldScenes();
    }

    @Override
    public void registerSceneForFontSwitching(Scene scene) {
        this.applyFontToScene(scene);
        this.applyCellPaddingToScene(scene);
        this.applyVerticalBorderToScene(scene);
        this.applyHorizontalBorderToScene(scene);
        this.applyPanelDividerToScene(scene);
        this.registeredScenes.add(scene);
    }

    @Subscribe
    public void handleSettingsLoadedEvent(SettingsLoadedEvent settingsLoadedEvent) {
        this.loadSettings();
        this.applyFontToAllRegisteredScenes();
    }

    private void applyFontToAllRegisteredScenes() {
        this.registeredScenes.forEach(this::applyFontToScene);
    }

    private void applyFontToScene(Scene scene) {
        if (scene != null && scene.getRoot() != null) {
            Parent root = scene.getRoot();
            root.setStyle("-fx-font-family: " + this.fontFamily.getCssName() + "; -fx-font-size: " + this.fontSize.getFontSize());
            root.getStyleClass().removeAll((Collection<?>)FONT_SIZE_STYLE_CLASSES);
            root.getStyleClass().add(this.fontSize.getMultiplierStyleClass());
            this.workaroundTableHeaderSize(root);
        }
    }

    private void applyCellPaddingToScene(Scene scene) {
        if (scene != null && scene.getRoot() != null) {
            Stream.of(FontService.CellPadding.values()).map(FontService.CellPadding::getStyleClass).forEach(scene.getRoot().getStyleClass()::remove);
            StyleUtil.addStyleClass(scene.getRoot(), this.cellPadding.getStyleClass());
        }
    }

    private void applyVerticalBorderToScene(Scene scene) {
        if (scene != null && scene.getRoot() != null) {
            Stream.of(FontService.VerticalBorder.values()).map(FontService.VerticalBorder::getStyleClass).forEach(scene.getRoot().getStyleClass()::remove);
            StyleUtil.addStyleClass(scene.getRoot(), this.verticalBorder.getStyleClass());
        }
    }

    private void applyHorizontalBorderToScene(Scene scene) {
        if (scene != null && scene.getRoot() != null) {
            Stream.of(FontService.HorizontalBorder.values()).map(FontService.HorizontalBorder::getStyleClass).forEach(scene.getRoot().getStyleClass()::remove);
            StyleUtil.addStyleClass(scene.getRoot(), this.horizontalBorder.getStyleClass());
        }
    }

    private void applyPanelDividerToScene(Scene scene) {
        if (scene != null && scene.getRoot() != null) {
            Stream.of(FontService.PanelDivider.values()).map(FontService.PanelDivider::getStyleClass).forEach(scene.getRoot().getStyleClass()::remove);
            StyleUtil.addStyleClass(scene.getRoot(), this.panelDivider.getStyleClass());
        }
    }

    private void applyCellPaddingToAllScenes() {
        this.registeredScenes.forEach(this::applyCellPaddingToScene);
    }

    private void applyVerticalBorderToAllScenes() {
        this.registeredScenes.forEach(this::applyVerticalBorderToScene);
    }

    private void applyHorizontalBorderToAllScenes() {
        this.registeredScenes.forEach(this::applyHorizontalBorderToScene);
    }

    private void applyPanelDividerToAlldScenes() {
        this.registeredScenes.forEach(this::applyPanelDividerToScene);
    }

    private void workaroundTableHeaderSize(Parent root) {
        root.lookupAll(".column-header-background").stream().filter(StackPane.class::isInstance).map(StackPane.class::cast).forEach(this::fixHeaderSize);
    }

    private void fixHeaderSize(StackPane headerRow) {
        Node button = headerRow.lookup(".show-hide-columns-button");
        Node header = headerRow.lookup(".nested-column-header");
        if (button instanceof StackPane && header != null) {
            headerRow.applyCss();
            double height = header.prefHeight(-1.0);
            double width = button.prefWidth(height);
            button.resize(width, height);
            headerRow.resize(headerRow.getWidth(), height);
        }
    }
}

