/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.version;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.service.style.StyleService;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ScheduledExecutorService;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Hyperlink;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionMismatchErrorDialog
extends BorderPane {
    private static final Logger LOG = LoggerFactory.getLogger(VersionMismatchErrorDialog.class);
    private Stage stage;
    private final StyleService styleService;
    private final ScheduledExecutorService executor;
    @FXML
    private Hyperlink hyperlink;

    public VersionMismatchErrorDialog(ApplicationContext appContext) {
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        this.styleService = appContext.getService(StyleService.class);
        this.executor = appContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        String downloadPage = appContext.getService(ApplicationConfigurationService.class).getApplicationProperty("customerPortalUrl");
        this.hyperlink.setText(downloadPage);
    }

    public void initialize() {
        this.hyperlink.setOnAction(event -> this.executor.execute(() -> {
            try {
                Desktop.getDesktop().browse(new URI(this.hyperlink.getText()));
            }
            catch (IOException | URISyntaxException e) {
                LOG.error("Enable to open system browser", e);
            }
        }));
        LOG.info("Version mismatch error dialog initialized.");
    }

    @FXML
    public void okPressed() {
        this.close();
    }

    public void show() {
        this.stage = new Stage(StageStyle.UTILITY);
        VersionMismatchErrorDialog modalDialog = this;
        Scene scene = new Scene(modalDialog);
        this.stage.setScene(scene);
        this.styleService.registerSceneForStyleSwitching(scene);
        this.styleService.registerWindowForStyleSwitching(scene.getWindow());
        this.stage.setResizable(false);
        this.stage.setTitle(Util.getLabel("versionCheck_newVersion_check"));
        this.stage.show();
    }

    public void close() {
        this.stage.close();
    }
}

