/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.util;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.util.FileUtil;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.comxerv.comtrader.util.concurrent.ConcurrencyUtil;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StuckApplicationGuard {
    private static final Logger LOG = LoggerFactory.getLogger(StuckApplicationGuard.class);
    private static final String DISABLE_GUARD_PROPERTY_KEY = "disableStuckApplicationGuard";
    private static final String WITH_HEAP_DUMP_KEY = "withHeapDumpWhenStuck";
    private final Runnable applicationStuckCallback;
    private final ScheduledExecutorService scheduledExecutorService;
    private final AtomicLong lastTimeFxThreadRun;
    private static final int CHECK_FX_THREAD_INTERVAL_IN_SECONDS = 5;
    private final ApplicationContext appContext;
    private volatile ExpectedLoad expectedLoad = ExpectedLoad.NORMAL;

    public StuckApplicationGuard(Runnable applicationStuckCallback, ApplicationContext appContext) {
        this.applicationStuckCallback = applicationStuckCallback;
        this.appContext = appContext;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("Comtrader-StuckApplicationGuard").build());
        this.lastTimeFxThreadRun = new AtomicLong(System.currentTimeMillis());
    }

    public void start() {
        if (Boolean.getBoolean(DISABLE_GUARD_PROPERTY_KEY)) {
            LOG.info("The StuckApplicationGuard was manually disabled.");
        } else {
            LOG.info("The StuckApplicationGuard is enabled.");
            this.setExpectedLoad(ExpectedLoad.HIGH);
            this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                FxUtil.runInFxThread(() -> this.lastTimeFxThreadRun.set(System.currentTimeMillis()));
                long currentTime = System.currentTimeMillis();
                long lastRecordedFxThreadTimestamp = this.lastTimeFxThreadRun.get();
                int calculatedDelay = this.expectedLoad.getMaxAllowedFxThreadDelayInMillis() + ExpectedLoad.NORMAL.getMaxAllowedFxThreadDelayInMillis();
                if (currentTime - lastRecordedFxThreadTimestamp > (long)calculatedDelay) {
                    this.handleStuckApplication();
                } else if ((double)(currentTime - lastRecordedFxThreadTimestamp) > (double)calculatedDelay * 0.75) {
                    LOG.warn("The application has reached 3/4 unresponsive trashold ({}ms)!", (Object)calculatedDelay);
                }
            }, 5L, 5L, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        if (System.getProperty(DISABLE_GUARD_PROPERTY_KEY) == null) {
            this.scheduledExecutorService.shutdown();
        }
    }

    private void handleStuckApplication() {
        File folder;
        if (LOG.isErrorEnabled()) {
            LOG.error("The application seems to have stopped responding.\n{}", (Object)ConcurrencyUtil.dumpAllThreads(false));
        }
        if ((Boolean.getBoolean(WITH_HEAP_DUMP_KEY) || this.appContext.getService(ApplicationConfigurationService.class).getBooleanApplicationProperty(WITH_HEAP_DUMP_KEY)) && (folder = FileUtil.findLogFolder()) != null) {
            String heapDumpFile = folder.getAbsolutePath() + File.separator + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss")) + "_heapdump.hprof";
            Util.heapDump(heapDumpFile, true);
        }
        this.applicationStuckCallback.run();
    }

    public void setExpectedLoad(ExpectedLoad expectedLoad) {
        this.expectedLoad = expectedLoad;
        LOG.info("Expected load is now set to {}/{} millis", (Object)expectedLoad.name(), (Object)expectedLoad.getMaxAllowedFxThreadDelayInMillis());
    }

    public static enum ExpectedLoad {
        NORMAL(60000),
        HIGH(120000);

        private final int maxAllowedFxThreadDelayInMillis;

        private ExpectedLoad(int maxAllowedFxThreadDelayInMillis) {
            this.maxAllowedFxThreadDelayInMillis = maxAllowedFxThreadDelayInMillis;
        }

        public int getMaxAllowedFxThreadDelayInMillis() {
            return this.maxAllowedFxThreadDelayInMillis;
        }
    }
}

