/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.util;

import com.deutscheboerse.comxerv.comtrader.jfx.service.WindowService;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.ui.jfx.util.ModalStages;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

@Singleton
public class UtilityStages {
    private final Map<String, Stage> utilityStages;
    private final WindowService windowService;
    private final EventBus eventBus;

    @Inject
    public UtilityStages(WindowService windowService, EventBus eventBus) {
        this.windowService = windowService;
        this.eventBus = eventBus;
        this.utilityStages = new HashMap<String, Stage>();
    }

    public StageBuilder withKey(String key) {
        return new StageBuilder(this, key);
    }

    private Stage getUtilityStage(String key, StageStyle stageStyle, Modality modality) {
        return this.utilityStages.computeIfAbsent(key, k -> {
            CloseOnLogoutStage stage = new CloseOnLogoutStage(stageStyle);
            stage.addEventFilter(KeyEvent.KEY_PRESSED, t -> {
                if (t.getCode() == KeyCode.ESCAPE) {
                    stage.close();
                    t.consume();
                }
            });
            this.windowService.decorateWindow(stage);
            this.eventBus.register(stage);
            if (modality == Modality.APPLICATION_MODAL) {
                ModalStages.makeModal(stage);
            } else {
                stage.initModality(modality);
            }
            return stage;
        });
    }

    public static class StageBuilder {
        private StageStyle stageStyle = StageStyle.DECORATED;
        private Modality modality = Modality.NONE;
        private Parent root;
        private final UtilityStages utilityStages;
        private final String key;

        private StageBuilder(UtilityStages utilityStages, String key) {
            this.utilityStages = utilityStages;
            this.key = key;
        }

        public StageBuilder withModality(Modality modality) {
            this.modality = modality;
            return this;
        }

        public StageBuilder withStageStyle(StageStyle stageStyle) {
            this.stageStyle = stageStyle;
            return this;
        }

        public StageBuilder withRoot(Parent root) {
            this.root = root;
            return this;
        }

        public Stage get() {
            Stage stage = this.utilityStages.getUtilityStage(this.key, this.modality == Modality.APPLICATION_MODAL ? StageStyle.UTILITY : this.stageStyle, this.modality);
            if (this.root != null) {
                stage.setScene(new Scene(this.root));
            }
            return stage;
        }
    }

    private static final class CloseOnLogoutStage
    extends Stage {
        public CloseOnLogoutStage(StageStyle style) {
            super(style);
        }

        @Subscribe
        public void handleLogout(LogoutEvent event) {
            if (this.isShowing()) {
                this.hide();
            }
        }
    }
}

