/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.monitoring;

import com.deutscheboerse.comxerv.comtrader.monitoring.DualSynchronousSender;
import com.deutscheboerse.comxerv.comtrader.service.info.EnvironmentInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import tech.energyit.statsd.FastStatsDClient;
import tech.energyit.statsd.StatsDClient;
import tech.energyit.statsd.Tag;
import tech.energyit.statsd.TagImpl;

@Singleton
public class Monitor {
    private static final byte[] MEM_USED = "mem_used".getBytes();
    private static final byte[] MEM_TOTAL = "mem_total".getBytes();
    private static final byte[] RAM = "ram".getBytes();
    private static final byte[] FX_DELAY = "fx_delay".getBytes();
    private static final byte[] CPU_PROCESS = "cpu_process".getBytes();
    private static final byte[] CPU_SYSTEM = "cpu_system".getBytes();
    private static final byte[] MESSAGE_DELAY = "message_delay".getBytes();
    private static final byte[] UI_THREAD_INVOKED = "ui_thread_invoked".getBytes();
    private static final byte[] BATCH_SIZE = "batch_size".getBytes();
    private static final byte[] CONNECTION_STATUS = "connected".getBytes();
    private static final byte[] ENTITY_SIZE = "pool_size".getBytes();
    private static final byte[] CLENAUP_DURATION = "cleanup".getBytes();
    private static final byte[] VERSION_TAG = "v".getBytes();
    private final StatsDClient statsDClient = Boolean.parseBoolean(System.getProperty("statsd.enabled")) ? new FastStatsDClient("m7_comtrader", new DualSynchronousSender(System.getProperty("statsd.host"), Integer.parseInt(System.getProperty("statsd.port")))) : new VoidStatsDClient(this);
    private final TagImpl versionTag;

    @Inject
    public Monitor(EnvironmentInfo environmentInfo) {
        this.versionTag = new TagImpl(VERSION_TAG, environmentInfo.getComTraderInfo().getBytes());
    }

    public void usedMemory(long value) {
        this.statsDClient.gauge(MEM_USED, value, new Tag[]{this.versionTag});
    }

    public void maxMemory(long value) {
        this.statsDClient.gauge(MEM_TOTAL, value, new Tag[]{this.versionTag});
    }

    public void totalMemory(long value) {
        this.statsDClient.gauge(RAM, value, new Tag[]{this.versionTag});
    }

    public void fxDelay(long value) {
        this.statsDClient.time(FX_DELAY, value, this.versionTag);
    }

    public void processCpuLoad(double value) {
        this.statsDClient.gauge(CPU_PROCESS, value, this.versionTag);
    }

    public void systemCpuLoad(double value) {
        this.statsDClient.gauge(CPU_SYSTEM, value, this.versionTag);
    }

    public void largeMessageDelay(long value) {
        this.statsDClient.gauge(MESSAGE_DELAY, value, new Tag[]{this.versionTag});
    }

    public void uiThreadInvoked(int value) {
        this.statsDClient.gauge(UI_THREAD_INVOKED, (long)value, new Tag[]{this.versionTag});
    }

    public void batchSize(int value) {
        this.statsDClient.gauge(BATCH_SIZE, (long)value, new Tag[]{this.versionTag});
    }

    public void connected(boolean connected) {
        this.statsDClient.gauge(CONNECTION_STATUS, connected ? 1L : 0L, new Tag[]{this.versionTag});
    }

    public void entitySize(int value, String entity) {
        this.statsDClient.gauge(ENTITY_SIZE, (long)value, new Tag[]{this.versionTag, new TagImpl("e".getBytes(), entity.getBytes())});
    }

    public void cleanupDuration(long value, String entity) {
        this.statsDClient.time(CLENAUP_DURATION, value, this.versionTag, new TagImpl("e".getBytes(), entity.getBytes()));
    }

    @VisibleForTesting
    StatsDClient getStatsDClient() {
        return this.statsDClient;
    }

    class VoidStatsDClient
    implements StatsDClient {
        VoidStatsDClient(Monitor this$0) {
        }

        @Override
        public void gauge(byte[] aspect, long value, Tag ... tags) {
        }

        @Override
        public void gauge(byte[] aspect, char deltaSign, long value, Tag ... tags) {
        }

        @Override
        public void gauge(byte[] aspect, long value, double sampleRate, Tag ... tags) {
        }

        @Override
        public void gauge(byte[] aspect, double value, Tag ... tags) {
        }

        @Override
        public void gauge(byte[] aspect, char deltaSign, double value, Tag ... tags) {
        }

        @Override
        public void gauge(byte[] aspect, double value, double sampleRate, Tag ... tags) {
        }

        @Override
        public void count(byte[] aspect, long delta, Tag ... tags) {
        }

        @Override
        public void count(byte[] aspect, long delta, double sampleRate, Tag ... tags) {
        }

        @Override
        public void count(byte[] aspect, double delta, Tag ... tags) {
        }

        @Override
        public void count(byte[] aspect, double delta, double sampleRate, Tag ... tags) {
        }

        @Override
        public void time(byte[] aspect, long timeInMs, Tag ... tags) {
        }

        @Override
        public void time(byte[] aspect, long timeInMs, double sampleRate, Tag ... tags) {
        }

        @Override
        public void histogram(byte[] aspect, long value, Tag ... tags) {
        }

        @Override
        public void histogram(byte[] aspect, long value, double sampleRate, Tag ... tags) {
        }

        @Override
        public void histogram(byte[] aspect, double value, Tag ... tags) {
        }

        @Override
        public void histogram(byte[] aspect, double value, double sampleRate, Tag ... tags) {
        }

        @Override
        public void set(byte[] aspect, long value, Tag ... tags) {
        }

        @Override
        public void set(byte[] aspect, long value, double sampleRate, Tag ... tags) {
        }

        @Override
        public void set(byte[] aspect, double value, Tag ... tags) {
        }

        @Override
        public void set(byte[] aspect, double value, double sampleRate, Tag ... tags) {
        }

        @Override
        public void meter(byte[] aspect, long value, Tag ... tags) {
        }

        @Override
        public void meter(byte[] aspect, double value, Tag ... tags) {
        }
    }
}

