/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import com.deutscheboerse.comxerv.comtrader.service.GlobalOrderbookSettingsService;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsLoadedEvent;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

@Singleton
public class GlobalOrderbookSettingsServiceImpl
implements GlobalOrderbookSettingsService {
    private static final SettingsService.Settings<Boolean> VISIBILITY_OF_PRODUCT_NAVIGATOR = new SettingsService.Settings<Boolean>("visibilityOfProductNavigator", true);
    private final ObjectProperty<Boolean> visibilityOfProductNavigator;
    private final SettingsService settingsService;

    @Inject
    public GlobalOrderbookSettingsServiceImpl(SettingsService settingsService, EventBus eventBus) {
        this.settingsService = settingsService;
        this.visibilityOfProductNavigator = new SimpleObjectProperty<Boolean>(settingsService.loadSettings(VISIBILITY_OF_PRODUCT_NAVIGATOR));
        this.visibilityOfProductNavigator.addListener(observable2 -> settingsService.storeSettings(VISIBILITY_OF_PRODUCT_NAVIGATOR, (Boolean)this.visibilityOfProductNavigator.get()));
        eventBus.register(this);
    }

    @Subscribe
    public void handleSettingsLoadedEvent(SettingsLoadedEvent event) {
        this.visibilityOfProductNavigator.set(this.settingsService.loadSettings(VISIBILITY_OF_PRODUCT_NAVIGATOR));
    }

    @Override
    public Boolean getVisibilityOfProductNavigator() {
        return (Boolean)this.visibilityOfProductNavigator.get();
    }

    @Override
    public ObservableValue<Boolean> visibilityOfProductNavigatorProperty() {
        return this.visibilityOfProductNavigator;
    }

    @Override
    public void setVisibilityOfProductNavigator(Boolean visibility) {
        this.visibilityOfProductNavigator.set(visibility);
    }
}

