/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.entities.Message;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MessagePublisherImpl
implements MessagePublisher {
    private static final Logger LOG = LoggerFactory.getLogger(MessagePublisherImpl.class);
    private final DataModel<String, Message> messageDataModel;
    private final TimeService timeService;

    @Inject
    public MessagePublisherImpl(ApplicationContext appContext) {
        this.messageDataModel = appContext.getDataModel(Message.class);
        this.timeService = appContext.getService(TimeService.class);
    }

    @Override
    public void publishMessage(String text, MessageSeverity severity) {
        DateTime timestamp = this.timeService.getServerTime();
        Message message = Message.createGuiMessage(timestamp, text, severity, null);
        LOG.debug("Publishing message with {} severity, with text {}", (Object)severity, (Object)text);
        this.messageDataModel.handleBroadcastEntity(message);
    }

    @Override
    public void publishMessage(AsyncResponse response) {
        if (response.getMessage() == null || response.getMessage().isEmpty()) {
            return;
        }
        MessageSeverity severity = response.getStatus() == ResponseStatus.ERROR ? MessageSeverity.ERROR : MessageSeverity.HIGH;
        this.publishMessage(response.getMessage(), severity);
    }
}

