/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.amqp;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParametersWithFallback;
import com.deutscheboerse.comxerv.comtrader.entities.session.LogoutType;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.BroadcastListenerHandlerForClass;
import com.deutscheboerse.comxerv.comtrader.service.LoginException;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ExchangeConnectionFactory;
import com.deutscheboerse.comxerv.comtrader.service.amqp.MessageInterceptor;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutCleanUpDataModelEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.PreLogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.listener.LogoutNotificationListener;
import com.deutscheboerse.comxerv.comtrader.service.question.ForceLoginQuestion;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BackendConnectionGatewayImpl
implements BackendConnectionGateway {
    private static final Logger LOG = LoggerFactory.getLogger(BackendConnectionGatewayImpl.class);
    private ApplicationContext appContext;
    private volatile ExchangeConnection connection;
    private final List<MessageInterceptor> messageInterceptors = new CopyOnWriteArrayList<MessageInterceptor>();
    private final EventBus eventBus;
    private final TimeService timeService;
    private final BroadcastListenerHandlerForClass broadcastListenerHandlerForClass;
    private final ExecutorService executorService;

    @Inject
    public BackendConnectionGatewayImpl(ApplicationContext applicationContext) {
        this.appContext = applicationContext;
        this.eventBus = applicationContext.getService(EventBus.class);
        this.timeService = applicationContext.getService(TimeService.class);
        this.broadcastListenerHandlerForClass = applicationContext.getService(BroadcastListenerHandlerForClass.class);
        this.broadcastListenerHandlerForClass.registerBackendBroadcastListener(this.appContext.getService(LogoutNotificationListener.class));
        this.executorService = applicationContext.getService(ExecutorService.class, WorkerExecutor.class);
    }

    @Override
    public synchronized void addMessageInterceptor(MessageInterceptor messageInterceptor) {
        this.messageInterceptors.add(messageInterceptor);
        if (this.connection != null) {
            this.connection.addMessageInterceptor(messageInterceptor);
        }
    }

    @Override
    public synchronized Session login(ConnectionParametersWithFallback params) throws LoginException {
        Session session = this.getSession();
        if (session != null) {
            throw new LoginException("There is already an open session.");
        }
        this.connection = this.createExchangeSpecificConnection(params);
        try {
            this.connection.connect();
            if (params.isConnectionCheck()) {
                LOG.info("Connection check SUCESSFULL");
                this.closeConnection();
                return null;
            }
            for (MessageInterceptor handler : this.messageInterceptors) {
                this.connection.addMessageInterceptor(handler);
            }
            this.connection.login(new ForceLoginQuestion(this.appContext.getService(UserAlertService.class)));
        }
        catch (LoginException | RuntimeException e) {
            LOG.error("Login failed", e);
            this.closeConnection();
            throw e;
        }
        this.connection.startBroadcastListener();
        return this.connection.getSession();
    }

    private ExchangeConnection createExchangeSpecificConnection(ConnectionParametersWithFallback params) {
        Exchange exchange = params.getExchange();
        ExchangeConnectionFactory exchangeConnectionFactory = this.appContext.getService(ExchangeConnectionFactory.class, exchange);
        if (exchangeConnectionFactory != null) {
            return exchangeConnectionFactory.createExchangeConnection(params);
        }
        throw new IllegalArgumentException("Unsupported Exchange: " + exchange.getId());
    }

    @Override
    public synchronized void closeConnection() {
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
        this.timeService.removeServerTime();
    }

    @Override
    public void logout(Runnable logoutErrorConfirmation) {
        this.logout(LogoutType.INTERNAL_QUIET, null, logoutErrorConfirmation);
    }

    private synchronized ExchangeConnection getAndUnsetConnection() {
        ExchangeConnection copyConnection = this.connection;
        this.connection = null;
        return copyConnection;
    }

    @Override
    public void logout(@Nonnull LogoutType logoutType, String reloginMessage, Runnable logoutErrorConfirmation) {
        ExchangeConnection copyConnection = this.getAndUnsetConnection();
        if (copyConnection == null) {
            return;
        }
        Session session = copyConnection.getSession();
        this.eventBus.post(new PreLogoutEvent(copyConnection.getSession()));
        this.executorService.execute(() -> {
            try {
                if (logoutType.isSendLogoutRequest()) {
                    copyConnection.logout();
                } else {
                    copyConnection.disconnect();
                }
            }
            catch (Exception e) {
                LOG.error("Logout failed", e);
                if (logoutErrorConfirmation != null) {
                    logoutErrorConfirmation.run();
                }
            }
            finally {
                this.eventBus.post(new LogoutCleanUpDataModelEvent(session));
                this.eventBus.post(new LogoutEvent(session, logoutType.isSendStatistics(), reloginMessage));
            }
        });
    }

    @Override
    public ExchangeConnection getConnection() {
        return this.connection;
    }

    @Override
    public Session getSession() {
        return Optional.ofNullable(this.connection).map(ExchangeConnection::getSession).orElse(null);
    }
}

