/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.comxerv;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductState;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingSettingsService;
import com.google.inject.Inject;

public class ProductValidator {
    private final DataModel<String, Product> productDataModel;
    private final TradingSettingsService tradingSettingsService;

    @Inject
    public ProductValidator(ApplicationContext appContext) {
        this.productDataModel = appContext.getDataModel(Product.class);
        this.tradingSettingsService = appContext.getService(TradingSettingsService.class);
    }

    public boolean isProductAotEnabled(Product remoteProduct) {
        if (remoteProduct != null && remoteProduct.getLinkedProductId() != null) {
            Product linkedProduct = this.productDataModel.findById(remoteProduct.getLinkedProductId());
            return linkedProduct != null && linkedProduct.isAotEnabled() && linkedProduct.getProductState() == ProductState.ACTIVE;
        }
        return false;
    }

    public boolean computeAotEnabled(Contract contract) {
        return contract != null && this.isProductAotEnabled(contract.getProduct()) && this.tradingSettingsService.isDefaultAot();
    }
}

