/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.order;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ContractColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMessage;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Arrays;
import java.util.Collection;

public class OrderContractColumn
extends ContractColumn<Order>
implements ImportColumn<Contract, Order> {
    public OrderContractColumn(String header, ApplicationContext appContext) {
        super(header, appContext);
    }

    @Override
    public Contract getValue(Order objectToExport) {
        return objectToExport.getContract();
    }

    @Override
    public Contract parseValue(String data) throws ImportException {
        Contract contract = this.parseContractValue(data);
        if (contract != null || data.isEmpty()) {
            return contract;
        }
        throw new ImportException("Unknown contract.", Util.getLabel("orderValidationError_invalidContract") + " " + data);
    }

    @Override
    public void applyValue(Contract value, Order importedObject) {
        importedObject.setContract(value);
    }

    @Override
    public Collection<String> getErrorCodesKeys() {
        return Arrays.asList(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_CONTRACT.getMessageKey(), ValidationMessage.ORDER_VALIDATION_ERROR_INACTIVE_CONTRACT.getMessageKey());
    }
}

