/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.order;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValidityRestriction;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.service.comxerv.ProductValidator;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ErrorCollector;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportService;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderAccountTypeColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderAotColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderBalancingGroupColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderContractColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderContractReferenceColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderDeliveryAreaColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderDirectionColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderFacilityTypeColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderLocationColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderMarketBasedColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderOpenOrCloseColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderOrderRestrictionColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderOrderTypeColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderPeakPriceDeltaColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderPeakQuantityColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderPriceColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderProductColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderQuantityColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderRearContractColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderStatusColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderStopPriceColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderTextColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderUsageFractionColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderValidityDateColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.order.OrderValidityRestrictionColumn;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.CommonOrderValidationService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.OrderValidationService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMode;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderImportService
extends ImportService<Order> {
    private static final Logger LOG = LoggerFactory.getLogger(OrderImportService.class);
    private final OrderValidationService orderValidationService;
    private final DataModel<String, BalancingGroup> balancingGroupDataModel;

    @Inject
    public OrderImportService(ApplicationContext appContext) {
        super(appContext);
        this.orderValidationService = appContext.getService(OrderValidationService.class);
        this.balancingGroupDataModel = appContext.getDataModel(BalancingGroup.class);
    }

    @Override
    public List<ImportColumn<?, Order>> getSupportedColumns() {
        ArrayList columns = new ArrayList();
        columns.add(new OrderDeliveryAreaColumn("commons_area", this.getAppContext()));
        columns.add(new OrderContractColumn("commons_contractShort", this.getAppContext()));
        columns.add(new OrderRearContractColumn("commons_rearContractShort", this.getAppContext()));
        columns.add(new OrderPriceColumn("commons_priceShort"));
        columns.add(new OrderStopPriceColumn("commons_stopPriceShort"));
        columns.add(new OrderQuantityColumn("commons_quantityShort"));
        columns.add(new OrderPeakQuantityColumn("commons_peakQuantityShort"));
        columns.add(new OrderPeakPriceDeltaColumn("commons_peakPriceDeltaShort"));
        columns.add(new OrderOpenOrCloseColumn("commons_openCloseShort"));
        columns.add(new OrderOrderTypeColumn("commons_type"));
        columns.add(new OrderBalancingGroupColumn("commons_balancingGroupShort", this.getAppContext()));
        columns.add(new OrderOrderRestrictionColumn("commons_executionRestrictionShortest"));
        columns.add(new OrderValidityRestrictionColumn("commons_validityRestrictionShortest"));
        columns.add(new OrderValidityDateColumn("commons_validityDateShort", this.getAppContext().getService(LocalService.class), this.getAppContext().getService(ActiveExchange.class)));
        columns.add(new OrderDirectionColumn("commons_buySellShort"));
        columns.add(new OrderProductColumn("commons_product", this.getAppContext()));
        columns.add(new OrderTextColumn("commons_textShort"));
        columns.add(new OrderAccountTypeColumn("commons_accountShort"));
        columns.add(new OrderStatusColumn("commons_statusShort"));
        columns.add(new OrderAotColumn("commons_aotShort"));
        columns.add(new OrderLocationColumn("commons_locationShort"));
        columns.add(new OrderMarketBasedColumn("commons_marketBasedShort"));
        columns.add(new OrderContractReferenceColumn("commons_contractReferenceShort"));
        columns.add(new OrderFacilityTypeColumn("commons_facilityTypeShort"));
        columns.add(new OrderUsageFractionColumn("commons_usageFractionShort"));
        return columns;
    }

    @Override
    public Order importRecord(List<ImportColumn<?, Order>> columns, List<String> record, int lineNr, ErrorCollector errorCollector) {
        Order order = new Order();
        order.setExecutionRestriction(ExecutionRestriction.NONE);
        order.setValidityRestriction(ValidityRestriction.GOOD_FOR_SESSION);
        order.setValidityDate(null);
        order.setText("");
        order.setLocation("");
        order.setAccount("A1");
        order.setStatus(OrderStatus.ACTIVE);
        order.setId(null);
        String defaultBalancingGroupId = this.getAppContext().getService(UserService.class).getCurrentUser().getDefaultBalancingGroup();
        order.setBalancingGroup(this.balancingGroupDataModel.findById(defaultBalancingGroupId));
        for (int i = 0; i < columns.size(); ++i) {
            ImportColumn<?, Order> column = columns.get(i);
            try {
                Object value = column.parseValue(record.get(i));
                if (value == null) continue;
                column.applyValue(value, order);
                continue;
            }
            catch (ImportException e) {
                errorCollector.addError(e.getExplanation(), lineNr, i + 1, column.getHeader());
            }
        }
        this.checkContractAndProduct(columns, record, lineNr, errorCollector);
        this.setDefaultDeliveryArea(order);
        this.setDefaultAot(order);
        return order;
    }

    private void checkContractAndProduct(List<ImportColumn<?, Order>> columns, List<String> record, int lineNr, ErrorCollector errorCollector) {
        Contract contract = null;
        String productName = null;
        for (int i = 0; i < columns.size(); ++i) {
            ImportColumn<?, Order> column = columns.get(i);
            String field = record.get(i);
            if (column instanceof OrderContractColumn) {
                try {
                    contract = (Contract)column.parseValue(field);
                }
                catch (ImportException e) {
                    continue;
                }
            }
            if (!(column instanceof OrderProductColumn)) continue;
            productName = field.trim();
        }
        if (contract != null && StringUtils.isNotEmpty(productName)) {
            String expectedProductName = contract.getProduct().getName();
            String expectedDisplayProductName = contract.getProduct().getDisplayName();
            if (!expectedProductName.equals(productName) && !expectedDisplayProductName.equals(productName)) {
                errorCollector.addError(Util.getLabel("importException_inconsistentContractAndProduct", contract.getName(), expectedProductName, productName), lineNr);
            }
        }
    }

    private void setDefaultDeliveryArea(Order order) {
        Exchange exchange = this.getAppContext().getService(ActiveExchange.class).getActiveExchange().get();
        if (!exchange.supportsDeliveryAreas() && order.getDeliveryArea() == null) {
            Stream<DeliveryArea> allDAs = this.getAppContext().getSmallDataModel(DeliveryArea.class).getAllEntitiesAsStream();
            order.setDeliveryArea(allDAs.findFirst().orElse(null));
        }
    }

    private void setDefaultAot(Order order) {
        if (order.getAot() == null) {
            order.setAot(this.getAppContext().getService(ProductValidator.class).computeAotEnabled(order.getContract()));
        }
    }

    @Override
    public void validate(Order importedObject, int lineNr, ErrorCollector errorCollector, Map<String, ImportColumn<?, Order>> errorCodeKeysToColumn) {
        OrderValidationService.ValidationResult validationResult;
        if (importedObject.getAccount() == null) {
            errorCollector.addError(Util.getLabel("importException_accountExchangeMismatch"), lineNr);
        }
        if ((validationResult = this.orderValidationService.validateOrder(importedObject, ValidationMode.BASKET)).getResult() != CommonOrderValidationService.ValidationFlag.SUBMIT) {
            for (String key : validationResult.getLocalizedErrorMessageKeys()) {
                if (errorCodeKeysToColumn.get(key) != null) {
                    String errorMessage = Util.getLabel(key, validationResult.getParameters(key));
                    errorCollector.addError(errorMessage, lineNr, errorCodeKeysToColumn.get(key).getColumnNr(), errorCodeKeysToColumn.get(key).getHeader());
                    continue;
                }
                LOG.error("Couldn't resolve error key. {}", (Object)key);
            }
        }
        if (importedObject.getOrderType() == OrderType.OTC_PREARRANGED) {
            errorCollector.addError(Util.getLabel("importException_otcForbidden"), lineNr);
        }
    }
}

