/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.order;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.LongDisplayValueColumn;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMessage;
import java.util.Arrays;
import java.util.Collection;

public class OrderPriceColumn
extends LongDisplayValueColumn<Order>
implements ImportColumn<LongDisplayValue, Order> {
    public OrderPriceColumn(String header) {
        super(header);
    }

    @Override
    public LongDisplayValue getValue(Order objectToExport) {
        return objectToExport.getLimitPrice();
    }

    @Override
    public LongDisplayValue parseValue(String data) throws ImportException {
        return this.parseLongDisplayValue(data);
    }

    @Override
    public void applyValue(LongDisplayValue value, Order importedObject) {
        LongDisplayValue appliedValue = value;
        if (importedObject.getContract() != null && importedObject.getContract().getProduct() != null) {
            appliedValue = value.applyShift(importedObject.getContract().getProduct().getPriceDecimalShift());
        }
        importedObject.setLimitPrice(appliedValue);
    }

    @Override
    public Collection<String> getErrorCodesKeys() {
        return Arrays.asList(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_LIMIT_PRICE.getMessageKey(), ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_PRICE.getMessageKey());
    }
}

