/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.info;

import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.info.SystemEnvironmentWrapper;
import com.google.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentInfo {
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String USE_SYSTEM_PROXIES = "java.net.useSystemProxies";
    private static final String ENV_HTTP_PROXY = "http_proxy";
    private static final String ENV_HTTPS_PROXY = "https_proxy";
    private static final String ENV_NO_PROXY = "no_proxy";
    private static final Logger LOG = LoggerFactory.getLogger(EnvironmentInfo.class);
    private final ApplicationConfigurationService applicationConfigurationService;
    private final SystemEnvironmentWrapper environment;

    @Inject
    public EnvironmentInfo(ApplicationConfigurationService applicationConfigurationService, SystemEnvironmentWrapper environment) {
        this.applicationConfigurationService = applicationConfigurationService;
        this.environment = environment;
    }

    public String getComTraderInfo() {
        return this.applicationConfigurationService.getApplicationProperty("comtrader.version") + "/" + this.applicationConfigurationService.getApplicationProperty("comtrader.buildts");
    }

    public String getOsInfo() {
        return System.getProperty("os.name") + "/" + System.getProperty("os.version") + "/" + System.getProperty("os.arch");
    }

    public String getJvmInfo() {
        return System.getProperty("java.vm.name") + "/" + System.getProperty("java.version");
    }

    public String getTimeZone() {
        return System.getProperty("user.timezone");
    }

    public String getSessionName() {
        String sessionName = System.getenv("sessionname");
        String sessionNameSanitized = (sessionName != null ? sessionName : "").toLowerCase();
        if (sessionNameSanitized.startsWith("rdp")) {
            return "Remote Desktop";
        }
        if (sessionNameSanitized.startsWith("ica")) {
            return "Citrix";
        }
        if (sessionNameSanitized.startsWith("console")) {
            return "Console";
        }
        return sessionName;
    }

    public String getProxyInfo() {
        String proxyHost;
        StringBuilder sb = new StringBuilder();
        String useSystemProxies = SystemPropertyAction.getPropertyOrNull(USE_SYSTEM_PROXIES);
        if (useSystemProxies != null) {
            sb.append("useSystemProxies=");
            sb.append(useSystemProxies);
            sb.append(",");
        }
        if ((proxyHost = SystemPropertyAction.getPropertyOrNull(HTTP_PROXY_HOST)) != null) {
            String proxyPort = SystemPropertyAction.getProperty(HTTP_PROXY_PORT);
            String nonProxyHosts = SystemPropertyAction.getPropertyOrNull(HTTP_NON_PROXY_HOSTS);
            sb.append("http.proxy=");
            sb.append(proxyHost);
            sb.append(":");
            sb.append(proxyPort);
            sb.append(" (nonProxyHosts=");
            sb.append(nonProxyHosts);
            sb.append("),");
        }
        try {
            String envNoProxy;
            String envHttpsProxy;
            String envHttpProxy = this.environment.getEnv(ENV_HTTP_PROXY);
            if (envHttpProxy != null) {
                sb.append("http_proxy=");
                sb.append(envHttpProxy);
                sb.append(",");
            }
            if ((envHttpsProxy = this.environment.getEnv(ENV_HTTPS_PROXY)) != null) {
                sb.append("https_proxy=");
                sb.append(envHttpsProxy);
                sb.append(",");
            }
            if ((envNoProxy = this.environment.getEnv(ENV_NO_PROXY)) != null) {
                sb.append("no_proxy=");
                sb.append(envNoProxy);
            }
        }
        catch (SecurityException e) {
            LOG.error("Error reading system environment variables", e);
        }
        return sb.toString();
    }

    URL getHttpProxyUrl() {
        URL webProxy = null;
        try {
            String envHttpProxy;
            String proxyHost = SystemPropertyAction.getProperty(HTTP_PROXY_HOST);
            if (proxyHost != null) {
                String proxyPort = SystemPropertyAction.getProperty(HTTP_PROXY_PORT);
                webProxy = new URL("http", proxyHost, Integer.parseInt(proxyPort), "");
            }
            if ((envHttpProxy = this.environment.getEnv(ENV_HTTP_PROXY)) != null) {
                webProxy = new URL(envHttpProxy);
            }
        }
        catch (SecurityException | MalformedURLException exception) {
            // empty catch block
        }
        return webProxy;
    }
}

