/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.info;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.util.FormatUtil;

public class HardwareInfo {
    private static final Logger LOG = LoggerFactory.getLogger(HardwareInfo.class);
    private String cpuInfo;
    private String ramInfo;

    public String getCpuInfo() {
        try {
            if (this.cpuInfo == null) {
                CentralProcessor cp = new SystemInfo().getHardware().getProcessor();
                this.cpuInfo = String.format("%s - %d x %s", cp.getProcessorIdentifier().getName(), cp.getPhysicalProcessorCount(), FormatUtil.formatHertz(cp.getProcessorIdentifier().getVendorFreq()));
            }
            return this.cpuInfo;
        }
        catch (RuntimeException e) {
            LOG.error("Could not get CPU info", e);
            this.cpuInfo = "N/A";
            return this.cpuInfo;
        }
    }

    public String getRamInfo() {
        try {
            if (this.ramInfo == null) {
                this.ramInfo = FormatUtil.formatBytes(new SystemInfo().getHardware().getMemory().getTotal());
            }
            return this.ramInfo;
        }
        catch (RuntimeException e) {
            LOG.error("Could not get RAM info", e);
            this.cpuInfo = "N/A";
            return this.cpuInfo;
        }
    }
}

