/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.info;

import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.google.inject.Inject;
import java.util.Optional;

public class SessionInfo {
    private final BackendConnectionGateway backendConnectionGateway;

    @Inject
    public SessionInfo(BackendConnectionGateway backendConnectionGateway) {
        this.backendConnectionGateway = backendConnectionGateway;
    }

    public String getFormattedSessionCreationTime() {
        return Optional.ofNullable(this.backendConnectionGateway.getSession()).map(this::formatSessionCreationTime).orElse("");
    }

    private String formatSessionCreationTime(Session session) {
        return session.getExchange().getId() + "/" + session.getConnectionParameters().getRabbitUser() + " (" + session.getCreatedAt().toString("yyyy-MM-dd'T'HH:mm:ss.SSSZ") + ")";
    }
}

