/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.listener;

import com.deutscheboerse.comxerv.comtrader.core.datamodel.EntityListener;
import com.deutscheboerse.comxerv.comtrader.entities.Message;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageType;
import com.deutscheboerse.comxerv.comtrader.entities.type.SpecialMessage;
import com.deutscheboerse.comxerv.comtrader.service.BroadcastListenerHandlerForClass;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingStartedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.TradeRecallRequestedMessageEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.UrgentMessageEvent;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class MessageBroadcastListener
implements EntityListener<Message> {
    private final UserAlertService userAlertService;
    private final EventBus eventBus;
    private boolean playingSounds;

    @Inject
    public MessageBroadcastListener(UserAlertService userAlertService, BroadcastListenerHandlerForClass broadcastListenerHandlerForClass, EventBus eventBus) {
        this.userAlertService = userAlertService;
        this.eventBus = eventBus;
        broadcastListenerHandlerForClass.registerBackendBroadcastListener(this);
        eventBus.register(this);
    }

    @Override
    public Class<Message> getEntityClass() {
        return Message.class;
    }

    @Override
    public void handleBroadcastEntity(Message message) {
        if (this.playingSounds && (this.isUrgent(message) || this.isRecallTradeMessage(message))) {
            FxUtil.runInFxThread(() -> this.handleUrgentMessage(message));
        }
    }

    private boolean isRecallTradeMessage(Message message) {
        return SpecialMessage.TRADE_RECALL_REQUESTED_ON_BEHALF.equals((Object)message.getSpecialMessage()) || SpecialMessage.TRADE_RECALL_REQUESTED.equals((Object)message.getSpecialMessage());
    }

    private boolean isUrgent(Message message) {
        return MessageSeverity.URGENT == message.getSeverity() || MessageSeverity.HIGH == message.getSeverity() && MessageType.PUBLIC == message.getType() && message.isMrktSupervisionMsg();
    }

    private void handleUrgentMessage(Message message) {
        if (this.isRecallTradeMessage(message)) {
            this.eventBus.post(new TradeRecallRequestedMessageEvent(message));
        } else if (this.isUrgent(message)) {
            this.eventBus.post(new UrgentMessageEvent(message));
        }
        this.userAlertService.showConfirmationDialog(Util.getLabel("marketOperationsMessageHeader"), message.getMessageText(), UserAlertService.Flag.WARNING);
    }

    @Subscribe
    public void handleLoadingStartedEvent(LoadingStartedEvent loadingStarted) {
        this.playingSounds = false;
    }

    @Subscribe
    public void handleLoadingFinishedEvent(LoadingFinishedEvent loadingFinished) {
        this.playingSounds = true;
    }
}

