/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.performancemonitoring;

import com.deutscheboerse.comxerv.comtrader.service.performancemonitoring.LocalLogService;
import com.deutscheboerse.comxerv.comtrader.service.performancemonitoring.RemoteLogServiceProxy;
import com.deutscheboerse.m7.comtrader.remote.log.v2.LogService;
import com.deutscheboerse.m7.comtrader.remote.log.v2.LogServiceException;
import com.deutscheboerse.m7.comtrader.remote.log.v2.data.Client;
import com.deutscheboerse.m7.comtrader.remote.log.v2.data.RequestDuration;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LocalAndRemoteLogService
implements LogService {
    private final LogService localLogService;
    private final LogService remoteLogService;
    private static final Logger LOG = LoggerFactory.getLogger(LocalAndRemoteLogService.class);

    @Inject
    public LocalAndRemoteLogService(LocalLogService localLogService, RemoteLogServiceProxy remoteLogService) {
        this.localLogService = localLogService;
        this.remoteLogService = remoteLogService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Client client, List<RequestDuration> list) throws LogServiceException {
        try {
            this.remoteLogService.store(client, list);
        }
        catch (Exception e) {
            LOG.error("Remote log error", e);
        }
        finally {
            this.localLogService.store(client, list);
        }
    }
}

