/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.version;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NormalizedVersion
implements Comparable<NormalizedVersion> {
    private final List<Integer> elements;
    private static final Logger LOG = LoggerFactory.getLogger(NormalizedVersion.class);

    public NormalizedVersion(String version) {
        String[] numbers;
        if (version == null) {
            version = "";
        }
        ArrayList<Integer> elements = new ArrayList<Integer>();
        String numbersAndDots = version.replaceAll("[^0-9]+", ".");
        for (String number : numbers = numbersAndDots.split("\\.")) {
            if (number == null || number.isEmpty()) continue;
            int maxIntDigits = 9;
            if (number.length() > maxIntDigits) {
                number = number.substring(number.length() - maxIntDigits);
            }
            try {
                elements.add(Integer.valueOf(number));
            }
            catch (NumberFormatException e) {
                LOG.debug("Could not parse version " + numbersAndDots, e);
            }
        }
        this.elements = Collections.unmodifiableList(elements);
    }

    public List<Integer> getElements() {
        return this.elements;
    }

    public String toString() {
        return StringUtils.join(this.elements, ".");
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof NormalizedVersion && this.toString().equals(o.toString());
    }

    @Override
    public int compareTo(NormalizedVersion o) {
        ArrayList<Integer> myElements = new ArrayList<Integer>(this.elements);
        ArrayList<Integer> otherElements = new ArrayList<Integer>(o.getElements());
        while (myElements.size() < otherElements.size()) {
            myElements.add(0);
        }
        while (otherElements.size() < myElements.size()) {
            otherElements.add(0);
        }
        for (int i = 0; i < myElements.size(); ++i) {
            if ((Integer)myElements.get(i) < (Integer)otherElements.get(i)) {
                return -1;
            }
            if ((Integer)myElements.get(i) <= (Integer)otherElements.get(i)) continue;
            return 1;
        }
        return 0;
    }
}

