/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.util;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesEncrypt {
    private static final Logger LOGGER = LoggerFactory.getLogger(AesEncrypt.class);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final int IV_LENGTH = 12;

    private AesEncrypt() {
    }

    private static SecretKey getSecretKey(char[] password, byte[] iv) throws GeneralSecurityException {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(password, iv, 65536, 128);
        SecretKey tmp = secretKeyFactory.generateSecret(spec);
        return new SecretKeySpec(tmp.getEncoded(), "AES");
    }

    public static String encrypt(char[] password, String value) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] iv = new byte[12];
        secureRandom.nextBytes(iv);
        try {
            SecretKey secret = AesEncrypt.getSecretKey(password, iv);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)secret, parameterSpec);
            byte[] ciphertext = cipher.doFinal(value.getBytes(DEFAULT_CHARSET));
            ByteBuffer byteBuffer = ByteBuffer.allocate(iv.length + ciphertext.length);
            byteBuffer.put(iv);
            byteBuffer.put(ciphertext);
            return Base64.getEncoder().encodeToString(byteBuffer.array());
        }
        catch (GeneralSecurityException ex) {
            throw new AesException("Unable to encode", ex);
        }
    }

    public static String decrypt(char[] password, String encrypted) {
        if (encrypted == null || encrypted.isEmpty()) {
            return "";
        }
        byte[] composed = Base64.getDecoder().decode(encrypted);
        ByteBuffer byteBuffer = ByteBuffer.wrap(composed);
        byte[] iv = new byte[12];
        byteBuffer.get(iv);
        byte[] cipherBytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(cipherBytes);
        try {
            SecretKey secret = AesEncrypt.getSecretKey(password, iv);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)secret, parameterSpec);
            return new String(cipher.doFinal(cipherBytes), DEFAULT_CHARSET);
        }
        catch (BadPaddingException ex) {
            LOGGER.debug("Invalid password.", ex);
            return "";
        }
        catch (GeneralSecurityException ex) {
            throw new AesException("Unable to decode", ex);
        }
    }

    public static class AesException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public AesException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

