/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.util;

import com.deutscheboerse.comxerv.comtrader.entities.type.NumberStyleType;
import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.management.MBeanServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);
    private static final Locale DEFAULT_LANGUAGE = Locale.getDefault();
    private static final Locale LANGUAGE_IN_CASE_OF_DEFAULT_NOT_SUPPORTED = Locale.ENGLISH;
    public static final String UNKNOWN_LABEL_MARKER = "???";
    private static Locale currentLocale;
    private static ResourceBundle labels;
    private static NumberStyleType numberStyleType;
    private static boolean groupingSeparator;

    private Util() {
    }

    public static void setLocale(Locale locale) {
        currentLocale = locale;
        labels = null;
    }

    public static void updateNumberStyle(NumberStyleType newNumberStyleType) {
        numberStyleType = newNumberStyleType;
    }

    public static char getDecimalSeparator() {
        return numberStyleType.getDecimalFormat().getDecimalFormatSymbols().getDecimalSeparator();
    }

    public static void updateGroupingSeparator(boolean enabled) {
        groupingSeparator = enabled;
    }

    private static void initLabels() {
        if (labels == null) {
            try {
                labels = ResourceBundle.getBundle("labels.labels", Util.getCurrentOrDefaultLocale());
            }
            catch (MissingResourceException e) {
                LOG.error("Missing resources", e);
                labels = ResourceBundle.getBundle("labels.labels", LANGUAGE_IN_CASE_OF_DEFAULT_NOT_SUPPORTED);
            }
        }
    }

    public static Locale getCurrentLocale() {
        return currentLocale;
    }

    public static Locale getCurrentOrDefaultLocale() {
        return currentLocale == null ? DEFAULT_LANGUAGE : currentLocale;
    }

    public static String getLabel(String key) {
        Util.initLabels();
        if (labels.containsKey(key)) {
            return labels.getString(key);
        }
        LOG.error("Missing resource {}", (Object)key);
        return UNKNOWN_LABEL_MARKER + key + UNKNOWN_LABEL_MARKER;
    }

    public static String getLabel(String key, Object ... args2) {
        Util.initLabels();
        String pattern = Util.getLabel(key);
        MessageFormat messageFormat = new MessageFormat(pattern, labels.getLocale());
        return messageFormat.format(args2);
    }

    public static ResourceBundle getLabels() {
        Util.initLabels();
        return labels;
    }

    public static String format(BigDecimal bigDecimal) {
        return numberStyleType.format(bigDecimal, groupingSeparator);
    }

    public static BigDecimal parse(String numberString) {
        return numberStyleType.parseNumberString(numberString, groupingSeparator);
    }

    public static int getMinimizedDecimalShift(int decimalShift, long smallestUnit) {
        if (smallestUnit < 1L) {
            throw new IllegalArgumentException("smallestUnit < 1");
        }
        if (decimalShift < 0) {
            throw new IllegalArgumentException("decimalShift < 0");
        }
        int smallestUnitShift = 0;
        while (smallestUnit % 10L == 0L) {
            smallestUnit /= 10L;
            ++smallestUnitShift;
        }
        int shift = decimalShift - smallestUnitShift;
        return shift > 0 ? shift : 0;
    }

    public static void setBundle(ResourceBundle newCustomBundle) {
        labels = newCustomBundle;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                LOG.error("Closed with exception", e);
            }
        }
    }

    public static DecimalFormat getDecimalFormat() {
        DecimalFormat formatter = numberStyleType.getDecimalFormat();
        formatter.setGroupingUsed(groupingSeparator);
        return formatter;
    }

    public static boolean heapDump(String dumpFile, boolean live) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            HotSpotDiagnosticMXBean mxBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
            LOG.info("Heap dump will be created to: {}", (Object)dumpFile);
            mxBean.dumpHeap(dumpFile, live);
        }
        catch (IOException e) {
            LOG.error("Cannot create heap dump", e);
            return false;
        }
        return true;
    }

    static {
        numberStyleType = NumberStyleType.EUROPEAN;
        groupingSeparator = false;
    }
}

