/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util;

import com.deutscheboerse.ui.jfx.util.LoggingRunnable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FxUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FxUtil.class);

    private FxUtil() {
    }

    public static Runnable wrapWithRunInFxThread(Runnable runnable) {
        return () -> FxUtil.runInFxThread(runnable);
    }

    public static void runInFxThread(Runnable runnable) {
        FxUtil.runInFxThread(runnable, false);
    }

    public static void runLater(Runnable runnable) {
        FxUtil.runInFxThread(runnable, true);
    }

    private static void runInFxThread(Runnable runnable, boolean forceRunLater) {
        if (Platform.isFxApplicationThread() && !forceRunLater) {
            try {
                runnable.run();
            }
            catch (RuntimeException e) {
                LOG.error("Error in FX-Application thread.", e);
            }
        } else {
            Platform.runLater(new LoggingRunnable(runnable));
        }
    }

    public static Executor getJFXExecutor() {
        return runnable -> {
            if (Platform.isFxApplicationThread()) {
                runnable.run();
            } else {
                Platform.runLater(runnable);
            }
        };
    }

    public static void invokeAndWait(Runnable task, long timeoutMillis) {
        boolean countedDown;
        if (Platform.isFxApplicationThread()) {
            throw new IllegalStateException("invokeAndWait cannot be called from the FX thread");
        }
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference eRef = new AtomicReference();
        Runnable wrappedTask = () -> {
            try {
                task.run();
            }
            catch (RuntimeException e) {
                eRef.set(e);
            }
            finally {
                latch.countDown();
            }
        };
        Platform.runLater(wrappedTask);
        try {
            if (timeoutMillis == 0L) {
                latch.await();
                countedDown = true;
            } else {
                countedDown = latch.await(timeoutMillis, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("invokeAndWait was interrupted", e);
        }
        if (eRef.get() != null) {
            throw (RuntimeException)eRef.get();
        }
        if (!countedDown) {
            throw new IllegalStateException("invokeAndWait timed out");
        }
    }

    public static void checkNotFxThread() {
        if (Platform.isFxApplicationThread()) {
            LOG.error("", new IllegalStateException("This code must not be called from the FX thread!"));
        }
    }
}

