/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util.control;

import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.deutscheboerse.ui.jfx.util.control.ListViewPopup;
import com.deutscheboerse.ui.jfx.util.control.ListViewValueProperty;
import com.deutscheboerse.ui.jfx.util.control.PopupWidth;
import com.deutscheboerse.ui.jfx.util.control.ScrollLessListView;
import com.deutscheboerse.ui.jfx.util.event.KeyBlocker;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuButton;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;

public class ArrowKeyBlockingChoiceBox<T>
extends MenuButton {
    private final StringConverter<T> converter;
    private boolean openOnFocus;
    private final ListViewValueProperty<T> value;
    private final ListViewPopup<T> popup;
    private final ListView<T> listView = new ScrollLessListView<T>();

    public ArrowKeyBlockingChoiceBox(StringConverter<T> converter) {
        StyleUtil.addStyleClasses(this.listView, "popupListView");
        this.openOnFocus = false;
        this.converter = converter;
        this.value = new ListViewValueProperty<T>(this.listView);
        this.popup = new ListViewPopup<T>(this, this.listView);
        this.popup.setPopupWidth(PopupWidth.MAX_OF_POPUP_AND_CONTENT_WIDTH);
        this.textProperty().bind(DependentBinding.get(this::computeText, this.value));
        this.graphicProperty().bind(DependentBinding.get(this::createGraphic, this.value));
        this.addEventFilter(KeyEvent.ANY, new KeyBlocker(KeyCode.LEFT, KeyCode.RIGHT));
        this.focusedProperty().addListener(this::focusChanged);
        this.listView.setCellFactory(this::createListCell);
        this.listView.addEventFilter(KeyEvent.KEY_PRESSED, new SelectItemOnKeyPressedEventHandler<T>(this.listView, converter));
        this.listView.addEventFilter(KeyEvent.KEY_PRESSED, this::handleKeyEvent);
        this.setOnMouseClicked(mouseEvent -> this.showPopup());
        this.setMnemonicParsing(false);
    }

    protected Node createGraphic(T value) {
        return null;
    }

    private void focusChanged(ObservableValue<? extends Boolean> observable2, Boolean oldValue, Boolean newValue) {
        if (newValue.booleanValue() && this.openOnFocus) {
            this.showPopup();
        }
    }

    private void handleKeyEvent(KeyEvent event) {
        boolean hidden;
        boolean tab = event.getCode() == KeyCode.TAB;
        boolean esc = event.getCode() == KeyCode.ESCAPE;
        boolean enter = event.getCode() == KeyCode.ENTER;
        boolean space = event.getCode() == KeyCode.SPACE;
        boolean bl = hidden = !this.popup.isShowing();
        if (tab || space || enter || esc) {
            if (!hidden) {
                this.popup.hide();
            }
            if (tab || hidden && enter) {
                this.fireEvent(event);
            }
        }
    }

    private ListCell<T> createListCell(ListView<T> listView) {
        return new ListCell<T>(){

            @Override
            protected void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (item != null && !empty) {
                    this.setText(ArrowKeyBlockingChoiceBox.this.converter.toString(item));
                    this.setGraphic(ArrowKeyBlockingChoiceBox.this.createGraphic(item));
                } else {
                    this.setText(null);
                    this.setGraphic(null);
                }
                this.setOnMouseClicked(event -> ArrowKeyBlockingChoiceBox.this.hidePopup());
            }
        };
    }

    private String computeText() {
        if (this.value.get() != null) {
            return this.converter.toString(this.value.get());
        }
        return this.getDefaultLabel();
    }

    protected String getDefaultLabel() {
        return "";
    }

    private void hidePopup() {
        this.popup.hide();
    }

    private void showPopup() {
        this.setFocused(true);
        this.popup.showPopup();
    }

    public List<T> getListedItems() {
        return this.listView.getItems();
    }

    public boolean setListedItems(Collection<T> listedItems) {
        return this.listView.getItems().setAll(listedItems);
    }

    public T getValue() {
        return this.value.getValue();
    }

    public void setValue(T value) {
        this.value.setValue(value);
    }

    public ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public BooleanBinding getHasOneOrLessItemsBinding() {
        return Bindings.size(this.listView.getItems()).lessThanOrEqualTo(1);
    }

    public boolean isOpenOnFocus() {
        return this.openOnFocus;
    }

    public void setOpenOnFocus(boolean openOnFocus) {
        this.openOnFocus = openOnFocus;
    }

    public StringConverter<T> getConverter() {
        return this.converter;
    }

    public PopupWidth getPopupWidth() {
        return this.popup.getPopupWidth();
    }

    public ObjectProperty<PopupWidth> popupWidthProperty() {
        return this.popup.popupWidthProperty();
    }

    public void setPopupWidth(PopupWidth popupWidth) {
        this.popup.setPopupWidth(popupWidth);
    }

    protected static class SelectItemOnKeyPressedEventHandler<T>
    implements EventHandler<KeyEvent> {
        private final ListView<T> listView;
        private final StringConverter<T> stringConverter;

        public SelectItemOnKeyPressedEventHandler(ListView<T> listView, StringConverter<T> stringConverter) {
            this.listView = listView;
            this.stringConverter = stringConverter;
        }

        @Override
        public void handle(KeyEvent event) {
            if (event.getText() != null && !event.getText().isEmpty()) {
                String text = event.getText().toLowerCase();
                this.listView.getItems().stream().filter(Objects::nonNull).filter(item -> this.stringConverter.toString(item).toLowerCase(Locale.ENGLISH).startsWith(text)).findFirst().ifPresent(item -> {
                    this.listView.getSelectionModel().select(item);
                    event.consume();
                });
            }
        }
    }
}

