/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class CartesianProductIterator<E>
implements Iterator<List<E>> {
    private final List<Iterable<? extends E>> iterables;
    private final List<Iterator<? extends E>> iterators;
    private List<E> previousTuple;

    @SafeVarargs
    public CartesianProductIterator(Iterable<? extends E> ... iterables) {
        Objects.requireNonNull(iterables, "iterables");
        this.iterables = new ArrayList<Iterable<? extends E>>(iterables.length);
        this.iterators = new ArrayList<Iterator<? extends E>>(iterables.length);
        for (Iterable<E> iterable : iterables) {
            Objects.requireNonNull(iterable, "iterable");
            this.iterables.add(iterable);
            Iterator<E> iterator2 = iterable.iterator();
            if (!iterator2.hasNext()) {
                this.iterators.clear();
                break;
            }
            this.iterators.add(iterator2);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterators.stream().anyMatch(Iterator::hasNext);
    }

    @Override
    public List<E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.previousTuple == null) {
            this.previousTuple = new ArrayList(this.iterables.size());
            for (Iterator<E> iterator2 : this.iterators) {
                this.previousTuple.add(iterator2.next());
            }
            return new ArrayList<E>(this.previousTuple);
        }
        for (int i = this.iterators.size() - 1; i >= 0; --i) {
            Iterator<E> iterator3 = this.iterators.get(i);
            if (iterator3.hasNext()) {
                this.previousTuple.set(i, iterator3.next());
                return new ArrayList<E>(this.previousTuple);
            }
            iterator3 = this.iterables.get(i).iterator();
            this.iterators.set(i, iterator3);
            this.previousTuple.set(i, iterator3.next());
        }
        throw new IllegalStateException("reached unreachable code");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

