/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.primitive.LongSets;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.set.primitive.AbstractLongSet;

public abstract class AbstractImmutableLongSet
extends AbstractLongSet
implements ImmutableLongSet {
    @Override
    public ImmutableLongSet newWith(long element) {
        return LongHashSet.newSet(this).with(element).toImmutable();
    }

    @Override
    public ImmutableLongSet newWithout(long element) {
        return LongHashSet.newSet(this).without(element).toImmutable();
    }

    @Override
    public ImmutableLongSet newWithAll(LongIterable elements) {
        return LongHashSet.newSet(this).withAll(elements).toImmutable();
    }

    @Override
    public ImmutableLongSet newWithoutAll(LongIterable elements) {
        return LongHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    @Override
    public LongSet freeze() {
        return this;
    }

    @Override
    public ImmutableLongSet toImmutable() {
        return this;
    }

    @Override
    public RichIterable<LongIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add(this);
            } else {
                LongIterator iterator2 = this.longIterator();
                while (iterator2.hasNext()) {
                    MutableLongSet batch = LongSets.mutable.empty();
                    for (int i = 0; i < size && iterator2.hasNext(); ++i) {
                        batch.add(iterator2.next());
                    }
                    result.add(batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }
}

