/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.eclipse.collections.api.map.primitive.MutableLongLongMap;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.BTreeMap;
import org.mapdb.BTreeMapJava;
import org.mapdb.ConcurrencyAware;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.HTreeMap;
import org.mapdb.IndexTreeList;
import org.mapdb.IndexTreeListJava;
import org.mapdb.IndexTreeLongLongMap;
import org.mapdb.MapModificationListener;
import org.mapdb.Pump;
import org.mapdb.QueueLong;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.StoreTx;
import org.mapdb.Utils;
import org.mapdb.elsa.ElsaClassCallback;
import org.mapdb.elsa.ElsaClassInfoResolver;
import org.mapdb.elsa.ElsaSerializerBase;
import org.mapdb.elsa.ElsaSerializerPojo;
import org.mapdb.elsa.ElsaStack;
import org.mapdb.serializer.GroupSerializer;
import org.mapdb.serializer.GroupSerializerObjectArray;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012*\u0002.3\b\u0016\u0018\u0000 \u0096\u00012\u00020\u00012\u00020\u0002: \u0090\u0001\u0091\u0001\u0092\u0001\u0093\u0001\u0094\u0001\u0095\u0001\u0096\u0001\u0097\u0001\u0098\u0001\u0099\u0001\u009a\u0001\u009b\u0001\u009c\u0001\u009d\u0001\u009e\u0001\u009f\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u0018J\u0016\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u00182\u0006\u0010F\u001a\u00020\u0006J\u000e\u0010G\u001a\u00020H2\u0006\u0010E\u001a\u00020\u0018J\u0016\u0010G\u001a\u00020H2\u0006\u0010E\u001a\u00020\u00182\u0006\u0010F\u001a\u00020\u000bJ\u000e\u0010I\u001a\u00020J2\u0006\u0010E\u001a\u00020\u0018J\u0016\u0010I\u001a\u00020J2\u0006\u0010E\u001a\u00020\u00182\u0006\u0010F\u001a\u00020KJ\u000e\u0010L\u001a\u00020M2\u0006\u0010E\u001a\u00020\u0018J\u0018\u0010L\u001a\u00020M2\u0006\u0010E\u001a\u00020\u00182\b\u0010F\u001a\u0004\u0018\u00010\u0018J\u0016\u0010N\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170O2\u0006\u0010E\u001a\u00020\u0018J(\u0010N\u001a\b\u0012\u0004\u0012\u0002HP0O\"\u0004\b\u0000\u0010P2\u0006\u0010E\u001a\u00020\u00182\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002HP0\u000eJ7\u0010N\u001a\b\u0012\u0004\u0012\u0002HP0O\"\u0004\b\u0000\u0010P2\u0006\u0010E\u001a\u00020\u00182\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002HP0\u000e2\b\u0010F\u001a\u0004\u0018\u0001HP\u00a2\u0006\u0002\u0010RJ\u0010\u0010S\u001a\u00020T2\u0006\u0010E\u001a\u00020\u0018H\u0004J\b\u0010U\u001a\u00020TH\u0004J\b\u0010V\u001a\u00020TH\u0016J\b\u0010W\u001a\u00020TH\u0016J\u0006\u0010X\u001a\u00020TJ\u0012\u0010Y\u001a\u00020T2\n\u0010Z\u001a\u0006\u0012\u0002\b\u00030@J\u0014\u0010[\u001a\u00020T2\n\u0010Z\u001a\u0006\u0012\u0002\b\u00030@H\u0002J\u000e\u0010\\\u001a\u00020\u00062\u0006\u0010E\u001a\u00020\u0018J\u0019\u0010]\u001a\u0002HP\"\u0004\b\u0000\u0010P2\u0006\u0010E\u001a\u00020\u0018\u00a2\u0006\u0002\u0010^J\u0014\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00170`J\f\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00180bJ\u0010\u0010c\u001a\u0004\u0018\u00010\u00182\u0006\u0010d\u001a\u00020\u0017J\u0006\u0010e\u001a\u00020\u0004J\u0016\u0010f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030g2\u0006\u0010E\u001a\u00020\u0018JB\u0010f\u001a\u000e\u0012\u0004\u0012\u0002Hh\u0012\u0004\u0012\u0002Hi0g\"\u0004\b\u0000\u0010h\"\u0004\b\u0001\u0010i2\u0006\u0010E\u001a\u00020\u00182\f\u0010j\u001a\b\u0012\u0004\u0012\u0002Hh0\u000e2\f\u0010k\u001a\b\u0012\u0004\u0012\u0002Hi0\u000eJ\u0012\u0010l\u001a\u0006\u0012\u0002\b\u00030m2\u0006\u0010E\u001a\u00020\u0018J(\u0010l\u001a\b\u0012\u0004\u0012\u0002HP0m\"\u0004\b\u0000\u0010P2\u0006\u0010E\u001a\u00020\u00182\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002HP0\u000eJ\u0016\u0010n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170o2\u0006\u0010E\u001a\u00020\u0018J(\u0010n\u001a\b\u0012\u0004\u0012\u0002HP0o\"\u0004\b\u0000\u0010P2\u0006\u0010E\u001a\u00020\u00182\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002HP0\u000eJ\u0010\u0010p\u001a\u00020q2\u0006\u0010E\u001a\u00020\u0018H\u0002J\u0006\u0010r\u001a\u00020\u0006J\u0013\u0010s\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a2\u0006\u0002\u0010tJ\u0012\u0010u\u001a\u0004\u0018\u00010\u00182\u0006\u0010E\u001a\u00020\u0018H\u0004J/\u0010v\u001a\u0004\u0018\u0001HP\"\u0004\b\u0000\u0010P2\u0012\u0010w\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180x2\u0006\u0010y\u001a\u00020\u0018\u00a2\u0006\u0002\u0010zJ\u0012\u0010{\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180xJ\u0014\u0010|\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180xH\u0004J\u001a\u0010}\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180`2\u0006\u0010E\u001a\u00020\u0018J*\u0010~\u001a\u00020T2\u0012\u0010w\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180x2\u0006\u0010y\u001a\u00020\u00182\u0006\u0010\u007f\u001a\u00020\u0017J\u001b\u0010\u0080\u0001\u001a\u00020T2\u0012\u0010w\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180xJ\u001d\u0010\u0081\u0001\u001a\u00020T2\u0012\u0010w\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180xH\u0004J\r\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020\u00180bJ\"\u0010\u0083\u0001\u001a\u001b\u0012\u0004\u0012\u00020\u0018\u0012\u0011\u0012\u000f\u0012\u0004\u0012\u00020\u0018\u0012\u0005\u0012\u00030\u0084\u00010`0`H\u0002J\u001d\u0010\u0085\u0001\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00170@0\u000fH\u0002\u00a2\u0006\u0003\u0010\u0086\u0001J\u0015\u0010\u0087\u0001\u001a\b\u0012\u0004\u0012\u00020\u00170\u000fH\u0002\u00a2\u0006\u0003\u0010\u0088\u0001J\u0007\u0010\u0089\u0001\u001a\u00020TJ\u0018\u0010\u008a\u0001\u001a\u000b\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u008b\u00012\u0006\u0010E\u001a\u00020\u0018JF\u0010\u008a\u0001\u001a\u000f\u0012\u0004\u0012\u0002Hh\u0012\u0004\u0012\u0002Hi0\u008b\u0001\"\u0004\b\u0000\u0010h\"\u0004\b\u0001\u0010i2\u0006\u0010E\u001a\u00020\u00182\r\u0010j\u001a\t\u0012\u0004\u0012\u0002Hh0\u008c\u00012\r\u0010k\u001a\t\u0012\u0004\u0012\u0002Hi0\u008c\u0001J\u0014\u0010\u008d\u0001\u001a\u0007\u0012\u0002\b\u00030\u008e\u00012\u0006\u0010E\u001a\u00020\u0018J+\u0010\u008d\u0001\u001a\t\u0012\u0004\u0012\u0002HP0\u008e\u0001\"\u0004\b\u0000\u0010P2\u0006\u0010E\u001a\u00020\u00182\r\u0010Q\u001a\t\u0012\u0004\u0012\u0002HP0\u008c\u0001J\t\u0010\u008f\u0001\u001a\u00020TH\u0002R \u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00170\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010(R\u0016\u0010)\u001a\u0004\u0018\u00010*X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0010\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010/R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00104R(\u00105\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001706X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0010\u0010=\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010(RB\u0010?\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 A*\b\u0012\u0002\b\u0003\u0018\u00010@0@ A*\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 A*\b\u0012\u0002\b\u0003\u0018\u00010@0@\u0018\u00010B0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a0\u0001"}, d2={"Lorg/mapdb/DB;", "Ljava/io/Closeable;", "Lorg/mapdb/ConcurrencyAware;", "store", "Lorg/mapdb/Store;", "storeOpened", "", "isThreadSafe", "classLoader", "Ljava/lang/ClassLoader;", "shutdownHook", "", "(Lorg/mapdb/Store;ZZLjava/lang/ClassLoader;I)V", "classInfoSerializer", "Lorg/mapdb/Serializer;", "", "Lorg/mapdb/elsa/ElsaSerializerPojo$ClassInfo;", "getClassInfoSerializer", "()Lorg/mapdb/Serializer;", "getClassLoader", "()Ljava/lang/ClassLoader;", "classSingletonCat", "Ljava/util/IdentityHashMap;", "", "", "classSingletonRev", "Ljava/util/HashMap;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "defaultSerializer", "Lorg/mapdb/serializer/GroupSerializerObjectArray;", "getDefaultSerializer", "()Lorg/mapdb/serializer/GroupSerializerObjectArray;", "elsaSerializer", "Lorg/mapdb/elsa/ElsaSerializerPojo;", "executors", "", "Ljava/util/concurrent/ExecutorService;", "getExecutors", "()Ljava/util/Set;", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "nameDeser", "org/mapdb/DB$nameDeser$1", "Lorg/mapdb/DB$nameDeser$1;", "nameRegex", "Lkotlin/text/Regex;", "nameSer", "org/mapdb/DB$nameSer$1", "Lorg/mapdb/DB$nameSer$1;", "namesInstanciated", "Lcom/google/common/cache/Cache;", "getNamesInstanciated", "()Lcom/google/common/cache/Cache;", "setNamesInstanciated", "(Lcom/google/common/cache/Cache;)V", "getShutdownHook", "()I", "shutdownReference", "getStoreOpened", "unknownClasses", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "", "atomicBoolean", "Lorg/mapdb/DB$AtomicBooleanMaker;", "name", "value", "atomicInteger", "Lorg/mapdb/DB$AtomicIntegerMaker;", "atomicLong", "Lorg/mapdb/DB$AtomicLongMaker;", "", "atomicString", "Lorg/mapdb/DB$AtomicStringMaker;", "atomicVar", "Lorg/mapdb/DB$AtomicVarMaker;", "E", "serializer", "(Ljava/lang/String;Lorg/mapdb/Serializer;Ljava/lang/Object;)Lorg/mapdb/DB$AtomicVarMaker;", "checkName", "", "checkNotClosed", "checkThreadSafe", "close", "commit", "defaultSerializerRegisterClass", "clazz", "defaultSerializerRegisterClass_noLock", "exists", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "getAll", "", "getAllNames", "", "getNameForObject", "e", "getStore", "hashMap", "Lorg/mapdb/DB$HashMapMaker;", "K", "V", "keySerializer", "valueSerializer", "hashSet", "Lorg/mapdb/DB$HashSetMaker;", "indexTreeList", "Lorg/mapdb/DB$IndexTreeListMaker;", "indexTreeLongLongMap", "Lorg/mapdb/DB$IndexTreeLongLongMapMaker;", "isClosed", "loadClassInfos", "()[Lorg/mapdb/elsa/ElsaSerializerPojo$ClassInfo;", "nameCatalogGet", "nameCatalogGetClass", "nameCatalog", "Ljava/util/SortedMap;", "key", "(Ljava/util/SortedMap;Ljava/lang/String;)Ljava/lang/Object;", "nameCatalogLoad", "nameCatalogLoadLocked", "nameCatalogParamsFor", "nameCatalogPutClass", "obj", "nameCatalogSave", "nameCatalogSaveLocked", "nameCatalogVerifyGetMessages", "nameCatalogVerifyTree", "Lorg/mapdb/DB$CatVal;", "namedClasses", "()[Ljava/lang/Class;", "pojoSingletons", "()[Ljava/lang/Object;", "rollback", "treeMap", "Lorg/mapdb/DB$TreeMapMaker;", "Lorg/mapdb/serializer/GroupSerializer;", "treeSet", "Lorg/mapdb/DB$TreeSetMaker;", "unknownClassesSave", "AtomicBooleanMaker", "AtomicIntegerMaker", "AtomicLongMaker", "AtomicStringMaker", "AtomicVarMaker", "CatVal", "Companion", "HashMapMaker", "HashSetMaker", "IndexTreeListMaker", "IndexTreeLongLongMapMaker", "Keys", "Maker", "TreeMapMaker", "TreeMapSink", "TreeSetMaker", "mapdb"})
@SourceDebugExtension(value={"SMAP\nDB.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DB.kt\norg/mapdb/DB\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Utils.kt\norg/mapdb/Utils\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1878:1\n11065#2:1879\n11400#2,3:1880\n11065#2:1883\n11400#2,3:1884\n13309#2,2:1887\n99#3,7:1889\n88#3,7:1896\n88#3,7:1912\n88#3,7:1919\n88#3,4:1926\n93#3,2:1934\n88#3,7:1936\n99#3,7:1950\n88#3,7:1966\n526#4:1903\n511#4,6:1904\n494#4,7:1943\n1855#5,2:1910\n1855#5,2:1930\n1855#5,2:1932\n766#5:1957\n857#5,2:1958\n1549#5:1960\n1620#5,3:1961\n1855#5,2:1964\n766#5:1974\n857#5,2:1975\n1549#5:1977\n1620#5,3:1978\n1#6:1973\n*S KotlinDebug\n*F\n+ 1 DB.kt\norg/mapdb/DB\n*L\n195#1:1879\n195#1:1880,3\n196#1:1883\n196#1:1884,3\n280#1:1887,2\n341#1:1889,7\n355#1:1896,7\n432#1:1912,7\n443#1:1919,7\n460#1:1926,4\n460#1:1934,2\n477#1:1936,7\n505#1:1950,7\n1679#1:1966,7\n414#1:1903\n414#1:1904,6\n502#1:1943,7\n425#1:1910,2\n464#1:1930,2\n466#1:1932,2\n513#1:1957\n513#1:1958,2\n514#1:1960\n514#1:1961,3\n519#1:1964,2\n1842#1:1974\n1842#1:1975,2\n1842#1:1977\n1842#1:1978,3\n*E\n"})
public class DB
implements Closeable,
ConcurrencyAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Store store;
    private final boolean storeOpened;
    private final boolean isThreadSafe;
    @NotNull
    private final ClassLoader classLoader;
    private final int shutdownHook;
    @Nullable
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private Cache<String, Object> namesInstanciated;
    @NotNull
    private final IdentityHashMap<Object, String> classSingletonCat;
    @NotNull
    private final HashMap<String, Object> classSingletonRev;
    private final Set<Class<?>> unknownClasses;
    @NotNull
    private final nameSer.1 nameSer;
    @NotNull
    private final nameDeser.1 nameDeser;
    @NotNull
    private final ElsaSerializerPojo elsaSerializer;
    @NotNull
    private final GroupSerializerObjectArray<Object> defaultSerializer;
    @NotNull
    private final Serializer<ElsaSerializerPojo.ClassInfo[]> classInfoSerializer;
    @Nullable
    private final Object shutdownReference;
    @NotNull
    private final Set<ExecutorService> executors;
    @NotNull
    private final Regex nameRegex;
    @NotNull
    private static final Serializer<SortedMap<String, String>> NAME_CATALOG_SERIALIZER = new Serializer<SortedMap<String, String>>(){

        @Nullable
        public SortedMap<String, String> deserialize(@NotNull DataInput2 input, int available) {
            Intrinsics.checkNotNullParameter(input, "input");
            int size = input.unpackInt();
            TreeMap<String, String> ret = new TreeMap<String, String>();
            for (int i = 0; i < size; ++i) {
                ret.put(input.readUTF(), input.readUTF());
            }
            return ret;
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull SortedMap<String, String> value) {
            Intrinsics.checkNotNullParameter(out, "out");
            Intrinsics.checkNotNullParameter(value, "value");
            out.packInt(value.size());
            Map $this$forEach$iv = value;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<K, V>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<K, V> element$iv;
                Map.Entry<K, V> e = element$iv = iterator2.next();
                boolean bl = false;
                out.writeUTF((String)e.getKey());
                out.writeUTF((String)e.getValue());
            }
        }
    };
    private static final int NAMED_SERIALIZATION_HEADER = 1;
    private static final Map<Object, Object> shutdownHooks = Collections.synchronizedMap(new IdentityHashMap());
    @NotNull
    private static AtomicBoolean shutdownHookInstalled = new AtomicBoolean(false);

    public DB(@NotNull Store store, boolean storeOpened, boolean isThreadSafe, @NotNull ClassLoader classLoader, int shutdownHook) {
        Object object;
        List<String> msgs;
        Collection<Pair<Class<? extends Object>, Integer>> collection;
        Class<? extends Object> it;
        Object object2;
        Class<? extends Object>[] $this$mapTo$iv$iv;
        Class<? extends Object>[] $this$map$iv;
        Intrinsics.checkNotNullParameter(store, "store");
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        this.store = store;
        this.storeOpened = storeOpened;
        this.isThreadSafe = isThreadSafe;
        this.classLoader = classLoader;
        this.shutdownHook = shutdownHook;
        this.lock = this.isThreadSafe() ? new ReentrantReadWriteLock() : null;
        this.closed = new AtomicBoolean(false);
        Cache cache = CacheBuilder.newBuilder().concurrencyLevel(1).weakValues().build();
        Intrinsics.checkNotNullExpressionValue(cache, "build(...)");
        this.namesInstanciated = cache;
        this.classSingletonCat = new IdentityHashMap();
        this.classSingletonRev = new HashMap();
        this.unknownClasses = Collections.synchronizedSet(new HashSet());
        this.nameSer = new ElsaSerializerBase.Ser<Object>(this){
            final /* synthetic */ DB this$0;
            {
                this.this$0 = $receiver;
            }

            public void serialize(@NotNull DataOutput out, @NotNull Object value, @Nullable ElsaStack objectStack) {
                Intrinsics.checkNotNullParameter(out, "out");
                Intrinsics.checkNotNullParameter(value, "value");
                String string = this.this$0.getNameForObject(value);
                if (string == null) {
                    throw new DBException.SerializationError("Could not serialize named object, it was not instantiated by this db");
                }
                String name = string;
                out.writeUTF(name);
            }
        };
        this.nameDeser = new ElsaSerializerBase.Deser<Object>(this){
            final /* synthetic */ DB this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public Object deserialize(@NotNull DataInput input, @NotNull ElsaStack objectStack) {
                Intrinsics.checkNotNullParameter(input, "input");
                Intrinsics.checkNotNullParameter(objectStack, "objectStack");
                String name = input.readUTF();
                Intrinsics.checkNotNull(name);
                return this.this$0.get(name);
            }
        };
        Class<? extends Object>[] classArray = this.namedClasses();
        Object[] objectArray = this.pojoSingletons();
        int n = 0;
        DB dB = this;
        boolean $i$f$map = false;
        void var8_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (Class<? extends Object> item$iv$iv : $this$mapTo$iv$iv) {
            void var14_26 = item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object2.add(new Pair<void, nameSer.1>((void)it, this.nameSer));
        }
        object2 = (List)destination$iv$iv;
        $this$map$iv = this.namedClasses();
        object2 = MapsKt.toMap((Iterable)object2);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        int n2 = $this$mapTo$iv$iv.length;
        for (int i = 0; i < n2; ++i) {
            Class<? extends Object> item$iv$iv;
            it = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair<Class<? extends Object>, Integer>(it, NAMED_SERIALIZATION_HEADER));
        }
        collection = (List)destination$iv$iv;
        ElsaClassInfoResolver elsaClassInfoResolver = new ElsaClassInfoResolver(this){
            final /* synthetic */ DB this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public int classToId(@NotNull String className) {
                ElsaSerializerPojo.ClassInfo[] classInfos;
                Intrinsics.checkNotNullParameter(className, "className");
                ElsaSerializerPojo.ClassInfo[] $this$forEachIndexed$iv = classInfos = DB.access$loadClassInfos(this.this$0);
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (ElsaSerializerPojo.ClassInfo item$iv : $this$forEachIndexed$iv) {
                    void classInfo;
                    int n = index$iv++;
                    ElsaSerializerPojo.ClassInfo classInfo2 = item$iv;
                    int i = n;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(classInfo.name, className)) continue;
                    return i;
                }
                return -1;
            }

            @Nullable
            public ElsaSerializerPojo.ClassInfo getClassInfo(int classId) {
                return DB.access$loadClassInfos(this.this$0)[classId];
            }
        };
        ElsaClassCallback elsaClassCallback = arg_0 -> DB.elsaSerializer$lambda$2(this, arg_0);
        Map<Integer, ElsaSerializerBase.Deser> map = MapsKt.mapOf(new Pair<Integer, nameDeser.1>(NAMED_SERIALIZATION_HEADER, this.nameDeser));
        Map<Class, Integer> map2 = MapsKt.toMap((Iterable)collection);
        Object object3 = object2;
        Object[] objectArray2 = objectArray;
        int n3 = n;
        dB.elsaSerializer = new ElsaSerializerPojo(n3, objectArray2, (Map<Class, ElsaSerializerBase.Ser>)object3, map2, map, elsaClassCallback, elsaClassInfoResolver);
        this.defaultSerializer = new GroupSerializerObjectArray<Object>(this){
            final /* synthetic */ DB this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public Object deserialize(@NotNull DataInput2 input, int available) {
                Intrinsics.checkNotNullParameter(input, "input");
                return DB.access$getElsaSerializer$p(this.this$0).deserialize(input);
            }

            public void serialize(@NotNull DataOutput2 out, @NotNull Object value) {
                Intrinsics.checkNotNullParameter(out, "out");
                Intrinsics.checkNotNullParameter(value, "value");
                DB.access$getElsaSerializer$p(this.this$0).serialize(out, value);
            }
        };
        this.classInfoSerializer = new Serializer<ElsaSerializerPojo.ClassInfo[]>(this){
            final /* synthetic */ DB this$0;
            {
                this.this$0 = $receiver;
            }

            public void serialize(@NotNull DataOutput2 out, @NotNull ElsaSerializerPojo.ClassInfo[] ci) {
                Intrinsics.checkNotNullParameter(out, "out");
                Intrinsics.checkNotNullParameter(ci, "ci");
                out.packInt(ci.length);
                for (ElsaSerializerPojo.ClassInfo c : ci) {
                    DB.access$getElsaSerializer$p(this.this$0).classInfoSerialize(out, c);
                }
            }

            @NotNull
            public ElsaSerializerPojo.ClassInfo[] deserialize(@NotNull DataInput2 input, int available) {
                Intrinsics.checkNotNullParameter(input, "input");
                int n = 0;
                int n2 = input.unpackInt();
                ElsaSerializerPojo.ClassInfo[] classInfoArray = new ElsaSerializerPojo.ClassInfo[n2];
                while (n < n2) {
                    int n3 = n++;
                    Intrinsics.checkNotNullExpressionValue(DB.access$getElsaSerializer$p(this.this$0).classInfoDeserialize(input), "classInfoDeserialize(...)");
                }
                return classInfoArray;
            }
        };
        if (!this.storeOpened) {
            if (this.store.isReadOnly()) {
                throw new DBException.WrongConfiguration("Can not create new store in read-only mode");
            }
            long nameCatalogRecid = this.store.put(new TreeMap(), NAME_CATALOG_SERIALIZER);
            if (1L != nameCatalogRecid) {
                throw new DBException.WrongConfiguration("Store does not support Reserved Recids: " + this.store.getClass());
            }
            long classCatalogRecid = this.store.put(new ElsaSerializerPojo.ClassInfo[0], this.classInfoSerializer);
            if (2L != classCatalogRecid) {
                throw new DBException.WrongConfiguration("Store does not support Reserved Recids: " + this.store.getClass());
            }
            for (long recid2 = 3L; recid2 < 9L; ++recid2) {
                GroupSerializer<Long> groupSerializer = Serializer.LONG_PACKED;
                Intrinsics.checkNotNullExpressionValue(groupSerializer, "LONG_PACKED");
                long recid22 = this.store.put(null, (Serializer)groupSerializer);
                if (recid2 == recid22) continue;
                throw new DBException.WrongConfiguration("Store does not support Reserved Recids: " + this.store.getClass());
            }
            this.store.commit();
        }
        if (!(msgs = CollectionsKt.toList(this.nameCatalogVerifyGetMessages())).isEmpty()) {
            throw new DBException.NewMapDBFormat("Name Catalog has some new unsupported features: " + msgs);
        }
        Field[] fieldArray = Serializer.class.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue(fieldArray, "getDeclaredFields(...)");
        Object[] $this$forEach$iv = fieldArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field f = (Field)element$iv;
            boolean bl = false;
            String name = Serializer.class.getCanonicalName() + '#' + f.getName();
            Object obj = f.get(null);
            this.classSingletonCat.put(obj, name);
            this.classSingletonRev.put(name, obj);
        }
        String defSerName = "org.mapdb.DB#defaultSerializer";
        this.classSingletonCat.put(this.defaultSerializer, defSerName);
        this.classSingletonRev.put(defSerName, this.defaultSerializer);
        switch (this.shutdownHook) {
            case 0: {
                object = null;
                break;
            }
            case 1: {
                object = this;
                break;
            }
            case 2: {
                object = new WeakReference<DB>(this);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.shutdownReference = object;
        if (this.shutdownReference != null) {
            Companion.addShutdownHook(this.shutdownReference);
        }
        Set set = Collections.synchronizedSet(new LinkedHashSet());
        Intrinsics.checkNotNullExpressionValue(set, "synchronizedSet(...)");
        this.executors = set;
        this.nameRegex = new Regex("[A-Z0-9._-]");
    }

    public /* synthetic */ DB(Store store, boolean bl, boolean bl2, ClassLoader classLoader, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl2 = true;
        }
        if ((n2 & 8) != 0) {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            Intrinsics.checkNotNullExpressionValue(classLoader2, "getContextClassLoader(...)");
            classLoader = classLoader2;
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        this(store, bl, bl2, classLoader, n);
    }

    protected final boolean getStoreOpened() {
        return this.storeOpened;
    }

    @Override
    public boolean isThreadSafe() {
        return this.isThreadSafe;
    }

    @NotNull
    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public final int getShutdownHook() {
        return this.shutdownHook;
    }

    @NotNull
    public final Store getStore() {
        this.checkNotClosed();
        return this.store;
    }

    @Nullable
    protected final ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    protected final void checkNotClosed() {
        if (this.closed.get()) {
            throw new IllegalAccessError("DB was closed");
        }
    }

    @NotNull
    protected final Cache<String, Object> getNamesInstanciated() {
        return this.namesInstanciated;
    }

    protected final void setNamesInstanciated(@NotNull Cache<String, Object> cache) {
        Intrinsics.checkNotNullParameter(cache, "<set-?>");
        this.namesInstanciated = cache;
    }

    private final Class<? extends Object>[] namedClasses() {
        Class[] classArray = new Class[]{BTreeMap.class, HTreeMap.class, HTreeMap.KeySet.class, BTreeMapJava.KeySet.class, Atomic.Integer.class, Atomic.Long.class, Atomic.String.class, Atomic.Boolean.class, Atomic.Var.class, IndexTreeList.class};
        return classArray;
    }

    @NotNull
    public final GroupSerializerObjectArray<Object> getDefaultSerializer() {
        return this.defaultSerializer;
    }

    @NotNull
    protected final Serializer<ElsaSerializerPojo.ClassInfo[]> getClassInfoSerializer() {
        return this.classInfoSerializer;
    }

    private final Object[] pojoSingletons() {
        Object[] objectArray = new Object[44];
        objectArray[0] = this;
        objectArray[1] = this.defaultSerializer;
        Intrinsics.checkNotNullExpressionValue(Serializer.CHAR, "CHAR");
        Intrinsics.checkNotNullExpressionValue(Serializer.STRING_ORIGHASH, "STRING_ORIGHASH");
        Intrinsics.checkNotNullExpressionValue(Serializer.STRING, "STRING");
        Intrinsics.checkNotNullExpressionValue(Serializer.STRING_DELTA, "STRING_DELTA");
        Intrinsics.checkNotNullExpressionValue(Serializer.STRING_DELTA2, "STRING_DELTA2");
        Intrinsics.checkNotNullExpressionValue(Serializer.STRING_INTERN, "STRING_INTERN");
        Intrinsics.checkNotNullExpressionValue(Serializer.STRING_ASCII, "STRING_ASCII");
        Intrinsics.checkNotNullExpressionValue(Serializer.STRING_NOSIZE, "STRING_NOSIZE");
        Intrinsics.checkNotNullExpressionValue(Serializer.LONG, "LONG");
        Intrinsics.checkNotNullExpressionValue(Serializer.LONG_PACKED, "LONG_PACKED");
        Intrinsics.checkNotNullExpressionValue(Serializer.LONG_DELTA, "LONG_DELTA");
        Intrinsics.checkNotNullExpressionValue(Serializer.INTEGER, "INTEGER");
        Intrinsics.checkNotNullExpressionValue(Serializer.INTEGER_PACKED, "INTEGER_PACKED");
        Intrinsics.checkNotNullExpressionValue(Serializer.INTEGER_DELTA, "INTEGER_DELTA");
        Intrinsics.checkNotNullExpressionValue(Serializer.BOOLEAN, "BOOLEAN");
        Intrinsics.checkNotNullExpressionValue(Serializer.RECID, "RECID");
        Intrinsics.checkNotNullExpressionValue(Serializer.RECID_ARRAY, "RECID_ARRAY");
        Intrinsics.checkNotNullExpressionValue(Serializer.ILLEGAL_ACCESS, "ILLEGAL_ACCESS");
        Intrinsics.checkNotNullExpressionValue(Serializer.BYTE_ARRAY, "BYTE_ARRAY");
        Intrinsics.checkNotNullExpressionValue(Serializer.BYTE_ARRAY_DELTA, "BYTE_ARRAY_DELTA");
        Intrinsics.checkNotNullExpressionValue(Serializer.BYTE_ARRAY_DELTA2, "BYTE_ARRAY_DELTA2");
        Intrinsics.checkNotNullExpressionValue(Serializer.BYTE_ARRAY_NOSIZE, "BYTE_ARRAY_NOSIZE");
        Intrinsics.checkNotNullExpressionValue(Serializer.CHAR_ARRAY, "CHAR_ARRAY");
        Intrinsics.checkNotNullExpressionValue(Serializer.INT_ARRAY, "INT_ARRAY");
        Intrinsics.checkNotNullExpressionValue(Serializer.LONG_ARRAY, "LONG_ARRAY");
        Intrinsics.checkNotNullExpressionValue(Serializer.DOUBLE_ARRAY, "DOUBLE_ARRAY");
        Intrinsics.checkNotNullExpressionValue(Serializer.JAVA, "JAVA");
        Intrinsics.checkNotNullExpressionValue(Serializer.ELSA, "ELSA");
        Intrinsics.checkNotNullExpressionValue(Serializer.UUID, "UUID");
        Intrinsics.checkNotNullExpressionValue(Serializer.BYTE, "BYTE");
        Intrinsics.checkNotNullExpressionValue(Serializer.FLOAT, "FLOAT");
        Intrinsics.checkNotNullExpressionValue(Serializer.DOUBLE, "DOUBLE");
        Intrinsics.checkNotNullExpressionValue(Serializer.SHORT, "SHORT");
        Intrinsics.checkNotNullExpressionValue(Serializer.SHORT_ARRAY, "SHORT_ARRAY");
        Intrinsics.checkNotNullExpressionValue(Serializer.FLOAT_ARRAY, "FLOAT_ARRAY");
        Intrinsics.checkNotNullExpressionValue(Serializer.BIG_INTEGER, "BIG_INTEGER");
        Intrinsics.checkNotNullExpressionValue(Serializer.BIG_DECIMAL, "BIG_DECIMAL");
        Intrinsics.checkNotNullExpressionValue(Serializer.CLASS, "CLASS");
        Intrinsics.checkNotNullExpressionValue(Serializer.DATE, "DATE");
        Intrinsics.checkNotNullExpressionValue(Collections.EMPTY_LIST, "EMPTY_LIST");
        Intrinsics.checkNotNullExpressionValue(Collections.EMPTY_SET, "EMPTY_SET");
        Intrinsics.checkNotNullExpressionValue(Collections.EMPTY_MAP, "EMPTY_MAP");
        return objectArray;
    }

    private final ElsaSerializerPojo.ClassInfo[] loadClassInfos() {
        ElsaSerializerPojo.ClassInfo[] classInfoArray = this.store.get(2L, this.classInfoSerializer);
        Intrinsics.checkNotNull(classInfoArray);
        return classInfoArray;
    }

    @NotNull
    protected final Set<ExecutorService> getExecutors() {
        return this.executors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SortedMap<String, String> nameCatalogLoad() {
        SortedMap<String, String> sortedMap;
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockRead = false;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            boolean bl = false;
            this.checkNotClosed();
            sortedMap = this.nameCatalogLoadLocked();
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
        return sortedMap;
    }

    @NotNull
    protected final SortedMap<String, String> nameCatalogLoadLocked() {
        Utils.INSTANCE.assertReadLock(this.lock);
        SortedMap<String, String> sortedMap = this.store.get(1L, NAME_CATALOG_SERIALIZER);
        if (sortedMap == null) {
            throw new DBException.WrongConfiguration("Could not open store, it has no Named Catalog");
        }
        return sortedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void nameCatalogSave(@NotNull SortedMap<String, String> nameCatalog) {
        Intrinsics.checkNotNullParameter(nameCatalog, "nameCatalog");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            this.checkNotClosed();
            this.nameCatalogSaveLocked(nameCatalog);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    protected final void nameCatalogSaveLocked(@NotNull SortedMap<String, String> nameCatalog) {
        Intrinsics.checkNotNullParameter(nameCatalog, "nameCatalog");
        Utils.INSTANCE.assertWriteLock(this.lock);
        this.store.update(1L, nameCatalog, NAME_CATALOG_SERIALIZER);
    }

    protected final void checkName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        if (StringsKt.contains$default((CharSequence)name, '#', false, 2, null)) {
            throw new DBException.WrongConfiguration("Name contains illegal character, '#' is not allowed.");
        }
        CharSequence charSequence = name;
        if (!this.nameRegex.matches(charSequence)) {
            throw new DBException.WrongConfiguration("Name contains illegal character");
        }
    }

    @Nullable
    protected final String nameCatalogGet(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return (String)this.nameCatalogLoadLocked().get(name);
    }

    public final void nameCatalogPutClass(@NotNull SortedMap<String, String> nameCatalog, @NotNull String key, @NotNull Object obj) {
        Intrinsics.checkNotNullParameter(nameCatalog, "nameCatalog");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(obj, "obj");
        String value = this.classSingletonCat.get(obj);
        if (value == null) {
            // empty if block
        }
        if (value != null) {
            nameCatalog.put(key, value);
        }
    }

    @Nullable
    public final <E> E nameCatalogGetClass(@NotNull SortedMap<String, String> nameCatalog, @NotNull String key) {
        Intrinsics.checkNotNullParameter(nameCatalog, "nameCatalog");
        Intrinsics.checkNotNullParameter(key, "key");
        String string = (String)nameCatalog.get(key);
        if (string == null) {
            return null;
        }
        String clazz = string;
        Object singleton = this.classSingletonRev.get(clazz);
        if (singleton != null) {
            return (E)singleton;
        }
        throw new DBException.WrongConfiguration("Could not load object: " + clazz);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> nameCatalogParamsFor(@NotNull String name) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(name, "name");
        TreeMap ret = new TreeMap();
        Map map = this.nameCatalogLoad();
        TreeMap treeMap2 = ret;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, "<get-key>(...)");
            if (!StringsKt.startsWith$default((String)k, name + '#', false, 2, null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        treeMap2.putAll(destination$iv$iv);
        Map<String, String> map2 = Collections.unmodifiableMap(ret);
        Intrinsics.checkNotNullExpressionValue(map2, "unmodifiableMap(...)");
        return map2;
    }

    private final void unknownClassesSave() {
        Utils.INSTANCE.assertWriteLock(this.lock);
        Set<Class<?>> set = this.unknownClasses;
        Intrinsics.checkNotNullExpressionValue(set, "unknownClasses");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class it = (Class)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            this.defaultSerializerRegisterClass_noLock(it);
        }
        this.unknownClasses.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            this.checkNotClosed();
            this.unknownClassesSave();
            this.store.commit();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollback() {
        if (!(this.store instanceof StoreTx)) {
            throw new UnsupportedOperationException("Store does not support rollback");
        }
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            this.checkNotClosed();
            this.unknownClasses.clear();
            ((StoreTx)this.store).rollback();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    public final boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (this.shutdownReference != null) {
            shutdownHooks.remove(this.shutdownReference);
        }
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            ExecutorService it;
            boolean bl = false;
            this.unknownClassesSave();
            Iterable $this$forEach$iv = this.executors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ExecutorService)element$iv;
                boolean bl2 = false;
                it.shutdown();
            }
            $this$forEach$iv = this.executors;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ExecutorService)element$iv;
                boolean bl3 = false;
                while (!it.awaitTermination(1L, TimeUnit.DAYS)) {
                }
            }
            this.executors.clear();
            this.store.close();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final <E> E get(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        var2_2 = Utils.INSTANCE;
        lock$iv = this.lock;
        $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            block39: {
                block28: {
                    block31: {
                        block33: {
                            block30: {
                                block35: {
                                    block37: {
                                        block32: {
                                            block29: {
                                                block34: {
                                                    block36: {
                                                        block38: {
                                                            $i$a$-lockWrite-DB$get$1 = false;
                                                            this.checkNotClosed();
                                                            v0 = var7_7 = (type = this.nameCatalogGet(name + Keys.INSTANCE.getType()));
                                                            if (v0 == null) break block28;
                                                            switch (v0.hashCode()) {
                                                                case 23865181: {
                                                                    if (!var7_7.equals("AtomicBoolean")) {
                                                                        ** break;
                                                                    }
                                                                    break block29;
                                                                }
                                                                case 2132139879: {
                                                                    if (!var7_7.equals("AtomicLong")) {
                                                                        ** break;
                                                                    }
                                                                    break block30;
                                                                }
                                                                case 285670804: {
                                                                    if (!var7_7.equals("IndexTreeLongLongMap")) {
                                                                        ** break;
                                                                    }
                                                                    break block31;
                                                                }
                                                                case -1932803762: {
                                                                    if (var7_7.equals("HashMap")) break;
                                                                    ** break;
                                                                }
                                                                case 1917205619: {
                                                                    if (!var7_7.equals("AtomicInteger")) {
                                                                        ** break;
                                                                    }
                                                                    break block32;
                                                                }
                                                                case -1299487698: {
                                                                    if (!var7_7.equals("IndexTreeList")) {
                                                                        ** break;
                                                                    }
                                                                    break block33;
                                                                }
                                                                case 600988612: {
                                                                    if (!var7_7.equals("TreeSet")) {
                                                                        ** break;
                                                                    }
                                                                    break block34;
                                                                }
                                                                case 492169788: {
                                                                    if (!var7_7.equals("AtomicString")) {
                                                                        ** break;
                                                                    }
                                                                    break block35;
                                                                }
                                                                case 600982718: {
                                                                    if (!var7_7.equals("TreeMap")) {
                                                                        ** break;
                                                                    }
                                                                    break block36;
                                                                }
                                                                case 1731355868: {
                                                                    if (!var7_7.equals("AtomicVar")) {
                                                                        ** break;
                                                                    }
                                                                    break block37;
                                                                }
                                                                case -1932797868: {
                                                                    if (!var7_7.equals("HashSet")) {
                                                                        ** break;
                                                                    }
                                                                    break block38;
                                                                }
                                                            }
                                                            v1 = this.hashMap(name).open();
                                                            break block39;
                                                        }
                                                        v1 = this.hashSet(name).open();
                                                        break block39;
                                                    }
                                                    v1 = this.treeMap(name).open();
                                                    break block39;
                                                }
                                                v1 = this.treeSet(name).open();
                                                break block39;
                                            }
                                            v1 = this.atomicBoolean(name).open();
                                            break block39;
                                        }
                                        v1 = this.atomicInteger(name).open();
                                        break block39;
                                    }
                                    v1 = this.atomicVar(name).open();
                                    break block39;
                                }
                                v1 = this.atomicString(name).open();
                                break block39;
                            }
                            v1 = this.atomicLong(name).open();
                            break block39;
                        }
                        v1 = this.indexTreeList(name).open();
                        break block39;
                    }
                    v1 = this.indexTreeLongLongMap(name).open();
                    break block39;
                }
                v1 = null;
                break block39;
lbl92:
                // 12 sources

                v1 = new DBException.WrongConfiguration("Collection has unknown type: " + type);
            }
            var9_8 = v1;
            return (E)var9_8;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    @Nullable
    public final String getNameForObject(@NotNull Object e) {
        Intrinsics.checkNotNullParameter(e, "e");
        ConcurrentMap<String, Object> concurrentMap = this.namesInstanciated.asMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "asMap(...)");
        Map $this$filterValues$iv = concurrentMap;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            Object it = entry$iv.getValue();
            boolean bl = false;
            if (!(it == e)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return (String)CollectionsKt.firstOrNull(((Map)result$iv).keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean exists(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockRead = false;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            boolean bl = false;
            this.checkNotClosed();
            boolean bl2 = this.nameCatalogGet(name + Keys.INSTANCE.getType()) != null;
            return bl2;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<String> getAllNames() {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Set<String> set = this.nameCatalogLoad().keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!StringsKt.endsWith$default(it, Keys.INSTANCE.getType(), false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            String[] stringArray = new String[]{"#"};
            collection.add((String)StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null).get(0));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Map<String, Object> getAll() {
        TreeMap ret = new TreeMap();
        Iterable<String> $this$forEach$iv = this.getAllNames();
        boolean $i$f$forEach = false;
        Iterator<String> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            String element$iv;
            String it = element$iv = iterator2.next();
            boolean bl = false;
            ret.put(it, this.get(it));
        }
        return ret;
    }

    @NotNull
    public final HashMapMaker<?, ?> hashMap(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new HashMapMaker(this, name, false, null, 12, null);
    }

    @NotNull
    public final <K, V> HashMapMaker<K, V> hashMap(@NotNull String name, @NotNull Serializer<K> keySerializer, @NotNull Serializer<V> valueSerializer) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(keySerializer, "keySerializer");
        Intrinsics.checkNotNullParameter(valueSerializer, "valueSerializer");
        return new HashMapMaker(this, name, false, null, 12, null).keySerializer(keySerializer).valueSerializer(valueSerializer);
    }

    @NotNull
    public final TreeMapMaker<?, ?> treeMap(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new TreeMapMaker(this, name, false, 4, null);
    }

    @NotNull
    public final <K, V> TreeMapMaker<K, V> treeMap(@NotNull String name, @NotNull GroupSerializer<K> keySerializer, @NotNull GroupSerializer<V> valueSerializer) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(keySerializer, "keySerializer");
        Intrinsics.checkNotNullParameter(valueSerializer, "valueSerializer");
        return new TreeMapMaker(this, name, false, 4, null).keySerializer(keySerializer).valueSerializer(valueSerializer);
    }

    @NotNull
    public final TreeSetMaker<?> treeSet(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new TreeSetMaker(this, name);
    }

    @NotNull
    public final <E> TreeSetMaker<E> treeSet(@NotNull String name, @NotNull GroupSerializer<E> serializer) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        return new TreeSetMaker(this, name).serializer(serializer);
    }

    @NotNull
    public final HashSetMaker<?> hashSet(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new HashSetMaker(this, name, null, 4, null);
    }

    @NotNull
    public final <E> HashSetMaker<E> hashSet(@NotNull String name, @NotNull Serializer<E> serializer) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        return new HashSetMaker(this, name, null, 4, null).serializer(serializer);
    }

    @NotNull
    public final AtomicIntegerMaker atomicInteger(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new AtomicIntegerMaker(this, name, 0, 4, null);
    }

    @NotNull
    public final AtomicIntegerMaker atomicInteger(@NotNull String name, int value) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new AtomicIntegerMaker(this, name, value);
    }

    @NotNull
    public final AtomicLongMaker atomicLong(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new AtomicLongMaker(this, name, 0L, 4, null);
    }

    @NotNull
    public final AtomicLongMaker atomicLong(@NotNull String name, long value) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new AtomicLongMaker(this, name, value);
    }

    @NotNull
    public final AtomicBooleanMaker atomicBoolean(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new AtomicBooleanMaker(this, name, false, 4, null);
    }

    @NotNull
    public final AtomicBooleanMaker atomicBoolean(@NotNull String name, boolean value) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new AtomicBooleanMaker(this, name, value);
    }

    @NotNull
    public final AtomicStringMaker atomicString(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new AtomicStringMaker(this, name, null, 4, null);
    }

    @NotNull
    public final AtomicStringMaker atomicString(@NotNull String name, @Nullable String value) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new AtomicStringMaker(this, name, value);
    }

    @NotNull
    public final AtomicVarMaker<Object> atomicVar(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.atomicVar(name, (Serializer)this.defaultSerializer);
    }

    @NotNull
    public final <E> AtomicVarMaker<E> atomicVar(@NotNull String name, @NotNull Serializer<E> serializer) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        return new AtomicVarMaker(this, name, serializer, null, 8, null);
    }

    @NotNull
    public final <E> AtomicVarMaker<E> atomicVar(@NotNull String name, @NotNull Serializer<E> serializer, @Nullable E value) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        return new AtomicVarMaker<E>(this, name, serializer, value);
    }

    private final IndexTreeLongLongMapMaker indexTreeLongLongMap(String name) {
        return new IndexTreeLongLongMapMaker(this, name);
    }

    @NotNull
    public final <E> IndexTreeListMaker<E> indexTreeList(@NotNull String name, @NotNull Serializer<E> serializer) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        return new IndexTreeListMaker<E>(this, name, serializer);
    }

    @NotNull
    public final IndexTreeListMaker<Object> indexTreeList(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.indexTreeList(name, (Serializer)this.defaultSerializer);
    }

    @Override
    public void checkThreadSafe() {
        ConcurrencyAware.DefaultImpls.checkThreadSafe(this);
        if (!this.store.isThreadSafe()) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void defaultSerializerRegisterClass(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            this.checkNotClosed();
            this.defaultSerializerRegisterClass_noLock(clazz);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    private final void defaultSerializerRegisterClass_noLock(Class<?> clazz) {
        ElsaSerializerPojo.ClassInfo classInfo;
        String className;
        ElsaSerializerPojo.ClassInfo[] infos;
        block2: {
            Utils.INSTANCE.assertWriteLock(this.lock);
            infos = this.loadClassInfos();
            className = clazz.getName();
            ElsaSerializerPojo.ClassInfo[] classInfoArray = infos;
            int n = classInfoArray.length;
            for (int i = 0; i < n; ++i) {
                ElsaSerializerPojo.ClassInfo classInfo2;
                ElsaSerializerPojo.ClassInfo it = classInfo2 = classInfoArray[i];
                boolean bl = false;
                if (!Intrinsics.areEqual(it.name, className)) continue;
                classInfo = classInfo2;
                break block2;
            }
            classInfo = null;
        }
        if (classInfo != null) {
            return;
        }
        ElsaSerializerPojo.ClassInfo[] classInfoArray = Arrays.copyOf(infos, infos.length + 1);
        Intrinsics.checkNotNullExpressionValue(classInfoArray, "copyOf(...)");
        infos = classInfoArray;
        int n = infos.length - 1;
        ElsaSerializerPojo.ClassInfo classInfo3 = this.elsaSerializer.makeClassInfo(className);
        Intrinsics.checkNotNullExpressionValue(classInfo3, "makeClassInfo(...)");
        infos[n] = classInfo3;
        this.store.update(2L, infos, this.classInfoSerializer);
    }

    private final Map<String, Map<String, CatVal>> nameCatalogVerifyTree() {
        Function1 all2 = nameCatalogVerifyTree.all.1.INSTANCE;
        Function1 recid2 = nameCatalogVerifyTree.recid.1.INSTANCE;
        Function1 recidOptional2 = nameCatalogVerifyTree.recidOptional.1.INSTANCE;
        Function1 function1 = nameCatalogVerifyTree.long.1.INSTANCE;
        Function1 function12 = nameCatalogVerifyTree.int.1.INSTANCE;
        Function1 recidArray = all2;
        Function1 serializer = all2;
        Function1 function13 = nameCatalogVerifyTree.boolean.1.INSTANCE;
        Pair[] pairArray = new Pair[11];
        Pair[] pairArray2 = new Pair[]{new Pair<String, CatVal>(Keys.INSTANCE.getKeySerializer(), new CatVal(serializer, false)), new Pair<String, CatVal>(Keys.INSTANCE.getValueSerializer(), new CatVal(serializer, false)), new Pair<String, CatVal>(Keys.INSTANCE.getRootRecids(), new CatVal(recidArray, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getValueInline(), new CatVal(function13, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getHashSeed(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getConcShift(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getLevels(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getDirShift(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getRemoveCollapsesIndexTree(), new CatVal(function13, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getCounterRecids(), new CatVal(recidArray, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireCreateQueue(), new CatVal(all2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireUpdateQueue(), new CatVal(all2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireGetQueue(), new CatVal(all2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireCreateTTL(), new CatVal(function1, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireUpdateTTL(), new CatVal(function1, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireGetTTL(), new CatVal(function1, false, 2, null))};
        pairArray[0] = new Pair("HashMap", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{new Pair<String, CatVal>(Keys.INSTANCE.getSerializer(), new CatVal(serializer, false)), new Pair<String, CatVal>(Keys.INSTANCE.getRootRecids(), new CatVal(recidArray, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getHashSeed(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getConcShift(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getDirShift(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getLevels(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getRemoveCollapsesIndexTree(), new CatVal(function13, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getCounterRecids(), new CatVal(recidArray, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireCreateQueue(), new CatVal(all2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireGetQueue(), new CatVal(all2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireCreateTTL(), new CatVal(function1, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireGetTTL(), new CatVal(function1, false, 2, null))};
        pairArray[1] = new Pair("HashSet", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{new Pair<String, CatVal>(Keys.INSTANCE.getKeySerializer(), new CatVal(serializer, false)), new Pair<String, CatVal>(Keys.INSTANCE.getValueSerializer(), new CatVal(serializer, false)), new Pair<String, CatVal>(Keys.INSTANCE.getRootRecidRecid(), new CatVal(recid2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getCounterRecid(), new CatVal(recidOptional2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getMaxNodeSize(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getValueInline(), new CatVal(function13, false, 2, null))};
        pairArray[2] = new Pair("TreeMap", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{new Pair<String, CatVal>(Keys.INSTANCE.getSerializer(), new CatVal(serializer, false)), new Pair<String, CatVal>(Keys.INSTANCE.getRootRecidRecid(), new CatVal(recid2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getCounterRecid(), new CatVal(recidOptional2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getMaxNodeSize(), new CatVal(function12, false, 2, null))};
        pairArray[3] = new Pair("TreeSet", MapsKt.mapOf(pairArray2));
        pairArray[4] = new Pair<String, Map<String, CatVal>>("AtomicBoolean", MapsKt.mapOf(new Pair<String, CatVal>(Keys.INSTANCE.getRecid(), new CatVal(recid2, false, 2, null))));
        pairArray[5] = new Pair<String, Map<String, CatVal>>("AtomicInteger", MapsKt.mapOf(new Pair<String, CatVal>(Keys.INSTANCE.getRecid(), new CatVal(recid2, false, 2, null))));
        pairArray2 = new Pair[]{new Pair<String, CatVal>(Keys.INSTANCE.getRecid(), new CatVal(recid2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getSerializer(), new CatVal(serializer, false))};
        pairArray[6] = new Pair("AtomicVar", MapsKt.mapOf(pairArray2));
        pairArray[7] = new Pair<String, Map<String, CatVal>>("AtomicString", MapsKt.mapOf(new Pair<String, CatVal>(Keys.INSTANCE.getRecid(), new CatVal(recid2, false, 2, null))));
        pairArray[8] = new Pair<String, Map<String, CatVal>>("AtomicLong", MapsKt.mapOf(new Pair<String, CatVal>(Keys.INSTANCE.getRecid(), new CatVal(recid2, false, 2, null))));
        pairArray2 = new Pair[]{new Pair<String, CatVal>(Keys.INSTANCE.getSerializer(), new CatVal(serializer, false)), new Pair<String, CatVal>(Keys.INSTANCE.getDirShift(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getLevels(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getRemoveCollapsesIndexTree(), new CatVal(function13, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getCounterRecid(), new CatVal(recid2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getRootRecid(), new CatVal(recid2, false, 2, null))};
        pairArray[9] = new Pair("IndexTreeList", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{new Pair<String, CatVal>(Keys.INSTANCE.getDirShift(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getLevels(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getRemoveCollapsesIndexTree(), new CatVal(function13, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getRootRecid(), new CatVal(recid2, false, 2, null))};
        pairArray[10] = new Pair("IndexTreeLongLongMap", MapsKt.mapOf(pairArray2));
        return MapsKt.mapOf(pairArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<String> nameCatalogVerifyGetMessages() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean bl;
        String it;
        void $this$filterTo$iv$iv;
        ArrayList ret = new ArrayList();
        Map<String, Map<String, CatVal>> ver = this.nameCatalogVerifyTree();
        SortedMap<String, String> catalog = this.nameCatalogLoad();
        Set<String> set = catalog.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object entry : $this$filterTo$iv$iv) {
            it = (String)entry;
            bl = false;
            Intrinsics.checkNotNull(it);
            if (!StringsKt.endsWith$default(it, Keys.INSTANCE.getType(), false, 2, null)) continue;
            destination$iv$iv.add(entry);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            it = (String)t;
            Collection collection = destination$iv$iv;
            bl = false;
            Intrinsics.checkNotNull(it);
            String string = it.substring(0, StringsKt.lastIndexOf$default((CharSequence)it, '#', 0, false, 6, null));
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            collection.add(string);
        }
        Set<String> names = CollectionsKt.toSet((List)destination$iv$iv);
        HashSet known = new HashSet();
        for (String name : names) {
            ((Collection)known).add(name + Keys.INSTANCE.getType());
            String type = (String)catalog.get(name + Keys.INSTANCE.getType());
            Map<String, CatVal> reqParams = ver.get(type);
            if (reqParams == null) {
                ((Collection)ret).add(name + Keys.INSTANCE.getType() + ": unknown type '" + type + '\'');
                continue;
            }
            for (Map.Entry entry : reqParams.entrySet()) {
                String param = (String)entry.getKey();
                CatVal catVal = (CatVal)entry.getValue();
                ((Collection)known).add(name + param);
                String value = (String)catalog.get(name + param);
                if (value == null) {
                    if (!catVal.getRequired()) continue;
                    ((Collection)ret).add(name + param + ": required parameter not found");
                    continue;
                }
                String msg = catVal.getMsg().invoke(value);
                if (msg == null) continue;
                ((Collection)ret).add(name + param + ": " + msg);
            }
        }
        for (String param : catalog.keySet()) {
            if (known.contains(param)) continue;
            ((Collection)ret).add(param + ": unknown parameter");
        }
        return ret;
    }

    private static final void elsaSerializer$lambda$2(DB this$0, Class it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.unknownClasses.add(it);
    }

    public static final /* synthetic */ ElsaSerializerPojo.ClassInfo[] access$loadClassInfos(DB $this) {
        return $this.loadClassInfos();
    }

    public static final /* synthetic */ ElsaSerializerPojo access$getElsaSerializer$p(DB $this) {
        return $this.elsaSerializer;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0012\u001a\u00020\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0014H\u0014J\u001c\u0010\u0015\u001a\u00020\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0014H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/mapdb/DB$AtomicBooleanMaker;", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/Atomic$Boolean;", "db", "Lorg/mapdb/DB;", "name", "", "value", "", "(Lorg/mapdb/DB;Ljava/lang/String;Z)V", "getDb", "()Lorg/mapdb/DB;", "getName", "()Ljava/lang/String;", "type", "getType", "getValue", "()Z", "create2", "catalog", "Ljava/util/SortedMap;", "open2", "mapdb"})
    public static final class AtomicBooleanMaker
    extends Maker<Atomic.Boolean> {
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        private final boolean value;
        @NotNull
        private final String type;

        public AtomicBooleanMaker(@NotNull DB db, @NotNull String name, boolean value) {
            Intrinsics.checkNotNullParameter(db, "db");
            Intrinsics.checkNotNullParameter(name, "name");
            this.db = db;
            this.name = name;
            this.value = value;
            this.type = "AtomicBoolean";
        }

        public /* synthetic */ AtomicBooleanMaker(DB dB, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(dB, string, bl);
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        protected final boolean getValue() {
            return this.value;
        }

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @Override
        @NotNull
        protected Atomic.Boolean create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            Store store = this.getDb().store;
            Boolean bl = this.value;
            GroupSerializer<Boolean> groupSerializer = Serializer.BOOLEAN;
            Intrinsics.checkNotNullExpressionValue(groupSerializer, "BOOLEAN");
            long recid2 = store.put(bl, (Serializer)groupSerializer);
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getRecid(), String.valueOf(recid2));
            return new Atomic.Boolean(this.getDb().store, recid2);
        }

        @Override
        @NotNull
        protected Atomic.Boolean open2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getRecid());
            Intrinsics.checkNotNull(v);
            long recid2 = Long.parseLong((String)v);
            return new Atomic.Boolean(this.getDb().store, recid2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0012\u001a\u00020\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0014H\u0014J\u001c\u0010\u0015\u001a\u00020\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0014H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/mapdb/DB$AtomicIntegerMaker;", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/Atomic$Integer;", "db", "Lorg/mapdb/DB;", "name", "", "value", "", "(Lorg/mapdb/DB;Ljava/lang/String;I)V", "getDb", "()Lorg/mapdb/DB;", "getName", "()Ljava/lang/String;", "type", "getType", "getValue", "()I", "create2", "catalog", "Ljava/util/SortedMap;", "open2", "mapdb"})
    public static final class AtomicIntegerMaker
    extends Maker<Atomic.Integer> {
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        private final int value;
        @NotNull
        private final String type;

        public AtomicIntegerMaker(@NotNull DB db, @NotNull String name, int value) {
            Intrinsics.checkNotNullParameter(db, "db");
            Intrinsics.checkNotNullParameter(name, "name");
            this.db = db;
            this.name = name;
            this.value = value;
            this.type = "AtomicInteger";
        }

        public /* synthetic */ AtomicIntegerMaker(DB dB, String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            this(dB, string, n);
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        protected final int getValue() {
            return this.value;
        }

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @Override
        @NotNull
        protected Atomic.Integer create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            Store store = this.getDb().store;
            Integer n = this.value;
            GroupSerializer<Integer> groupSerializer = Serializer.INTEGER;
            Intrinsics.checkNotNullExpressionValue(groupSerializer, "INTEGER");
            long recid2 = store.put(n, (Serializer)groupSerializer);
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getRecid(), String.valueOf(recid2));
            return new Atomic.Integer(this.getDb().store, recid2);
        }

        @Override
        @NotNull
        protected Atomic.Integer open2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getRecid());
            Intrinsics.checkNotNull(v);
            long recid2 = Long.parseLong((String)v);
            return new Atomic.Integer(this.getDb().store, recid2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0012\u001a\u00020\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0014H\u0014J\u001c\u0010\u0015\u001a\u00020\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0014H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/mapdb/DB$AtomicLongMaker;", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/Atomic$Long;", "db", "Lorg/mapdb/DB;", "name", "", "value", "", "(Lorg/mapdb/DB;Ljava/lang/String;J)V", "getDb", "()Lorg/mapdb/DB;", "getName", "()Ljava/lang/String;", "type", "getType", "getValue", "()J", "create2", "catalog", "Ljava/util/SortedMap;", "open2", "mapdb"})
    public static final class AtomicLongMaker
    extends Maker<Atomic.Long> {
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        private final long value;
        @NotNull
        private final String type;

        public AtomicLongMaker(@NotNull DB db, @NotNull String name, long value) {
            Intrinsics.checkNotNullParameter(db, "db");
            Intrinsics.checkNotNullParameter(name, "name");
            this.db = db;
            this.name = name;
            this.value = value;
            this.type = "AtomicLong";
        }

        public /* synthetic */ AtomicLongMaker(DB dB, String string, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                l = 0L;
            }
            this(dB, string, l);
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        protected final long getValue() {
            return this.value;
        }

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @Override
        @NotNull
        protected Atomic.Long create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            Store store = this.getDb().store;
            Long l = this.value;
            GroupSerializer<Long> groupSerializer = Serializer.LONG;
            Intrinsics.checkNotNullExpressionValue(groupSerializer, "LONG");
            long recid2 = store.put(l, (Serializer)groupSerializer);
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getRecid(), String.valueOf(recid2));
            return new Atomic.Long(this.getDb().store, recid2);
        }

        @Override
        @NotNull
        protected Atomic.Long open2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getRecid());
            Intrinsics.checkNotNull(v);
            long recid2 = Long.parseLong((String)v);
            return new Atomic.Long(this.getDb().store, recid2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0012H\u0014J\u001c\u0010\u0013\u001a\u00020\u00022\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0012H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/mapdb/DB$AtomicStringMaker;", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/Atomic$String;", "db", "Lorg/mapdb/DB;", "name", "", "value", "(Lorg/mapdb/DB;Ljava/lang/String;Ljava/lang/String;)V", "getDb", "()Lorg/mapdb/DB;", "getName", "()Ljava/lang/String;", "type", "getType", "getValue", "create2", "catalog", "Ljava/util/SortedMap;", "open2", "mapdb"})
    public static final class AtomicStringMaker
    extends Maker<Atomic.String> {
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        @Nullable
        private final String value;
        @NotNull
        private final String type;

        public AtomicStringMaker(@NotNull DB db, @NotNull String name, @Nullable String value) {
            Intrinsics.checkNotNullParameter(db, "db");
            Intrinsics.checkNotNullParameter(name, "name");
            this.db = db;
            this.name = name;
            this.value = value;
            this.type = "AtomicString";
        }

        public /* synthetic */ AtomicStringMaker(DB dB, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(dB, string, string2);
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        @Nullable
        protected final String getValue() {
            return this.value;
        }

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @Override
        @NotNull
        protected Atomic.String create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            Store store = this.getDb().store;
            Serializer<String> serializer = Serializer.STRING_NOSIZE;
            Intrinsics.checkNotNullExpressionValue(serializer, "STRING_NOSIZE");
            long recid2 = store.put(this.value, serializer);
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getRecid(), String.valueOf(recid2));
            return new Atomic.String(this.getDb().store, recid2);
        }

        @Override
        @NotNull
        protected Atomic.String open2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getRecid());
            Intrinsics.checkNotNull(v);
            long recid2 = Long.parseLong((String)v);
            return new Atomic.String(this.getDb().store, recid2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000bJ\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0019H\u0014J\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0019H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0018\u0010\n\u001a\u0004\u0018\u00018\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lorg/mapdb/DB$AtomicVarMaker;", "E", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/Atomic$Var;", "db", "Lorg/mapdb/DB;", "name", "", "serializer", "Lorg/mapdb/Serializer;", "value", "(Lorg/mapdb/DB;Ljava/lang/String;Lorg/mapdb/Serializer;Ljava/lang/Object;)V", "getDb", "()Lorg/mapdb/DB;", "getName", "()Ljava/lang/String;", "getSerializer", "()Lorg/mapdb/Serializer;", "type", "getType", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "create2", "catalog", "Ljava/util/SortedMap;", "open2", "mapdb"})
    public static final class AtomicVarMaker<E>
    extends Maker<Atomic.Var<E>> {
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        @NotNull
        private final Serializer<E> serializer;
        @Nullable
        private final E value;
        @NotNull
        private final String type;

        public AtomicVarMaker(@NotNull DB db, @NotNull String name, @NotNull Serializer<E> serializer, @Nullable E value) {
            Intrinsics.checkNotNullParameter(db, "db");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(serializer, "serializer");
            this.db = db;
            this.name = name;
            this.serializer = serializer;
            this.value = value;
            this.type = "AtomicVar";
        }

        public /* synthetic */ AtomicVarMaker(DB dB, String string, Serializer serializer, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                GroupSerializerObjectArray<Object> groupSerializerObjectArray = dB.getDefaultSerializer();
                Intrinsics.checkNotNull(groupSerializerObjectArray, "null cannot be cast to non-null type org.mapdb.Serializer<E of org.mapdb.DB.AtomicVarMaker>");
                serializer = groupSerializerObjectArray;
            }
            if ((n & 8) != 0) {
                object = null;
            }
            this(dB, string, serializer, object);
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        @NotNull
        protected final Serializer<E> getSerializer() {
            return this.serializer;
        }

        @Nullable
        protected final E getValue() {
            return this.value;
        }

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @Override
        @NotNull
        protected Atomic.Var<E> create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            long recid2 = this.getDb().store.put(this.value, this.serializer);
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getRecid(), String.valueOf(recid2));
            this.getDb().nameCatalogPutClass(catalog, this.getName() + Keys.INSTANCE.getSerializer(), this.serializer);
            return new Atomic.Var<E>(this.getDb().store, recid2, this.serializer);
        }

        @Override
        @NotNull
        protected Atomic.Var<E> open2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getRecid());
            Intrinsics.checkNotNull(v);
            long recid2 = Long.parseLong((String)v);
            Serializer<E> serializer = (Serializer<E>)this.getDb().nameCatalogGetClass(catalog, this.getName() + Keys.INSTANCE.getSerializer());
            if (serializer == null) {
                serializer = this.serializer;
            }
            Serializer<E> serializer2 = serializer;
            return new Atomic.Var<E>(this.getDb().store, recid2, serializer2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\b\u0018\u00002\u00020\u0001B%\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/mapdb/DB$CatVal;", "", "msg", "Lkotlin/Function1;", "", "required", "", "(Lkotlin/jvm/functions/Function1;Z)V", "getMsg", "()Lkotlin/jvm/functions/Function1;", "getRequired", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "mapdb"})
    protected static final class CatVal {
        @NotNull
        private final Function1<String, String> msg;
        private final boolean required;

        public CatVal(@NotNull Function1<? super String, String> msg, boolean required) {
            Intrinsics.checkNotNullParameter(msg, "msg");
            this.msg = msg;
            this.required = required;
        }

        public /* synthetic */ CatVal(Function1 function1, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(function1, bl);
        }

        @NotNull
        public final Function1<String, String> getMsg() {
            return this.msg;
        }

        public final boolean getRequired() {
            return this.required;
        }

        @NotNull
        public final Function1<String, String> component1() {
            return this.msg;
        }

        public final boolean component2() {
            return this.required;
        }

        @NotNull
        public final CatVal copy(@NotNull Function1<? super String, String> msg, boolean required) {
            Intrinsics.checkNotNullParameter(msg, "msg");
            return new CatVal(msg, required);
        }

        public static /* synthetic */ CatVal copy$default(CatVal catVal, Function1 function1, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = catVal.msg;
            }
            if ((n & 2) != 0) {
                bl = catVal.required;
            }
            return catVal.copy(function1, bl);
        }

        @NotNull
        public String toString() {
            return "CatVal(msg=" + this.msg + ", required=" + this.required + ')';
        }

        public int hashCode() {
            int result = this.msg.hashCode();
            result = result * 31 + Boolean.hashCode(this.required);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CatVal)) {
                return false;
            }
            CatVal catVal = (CatVal)other;
            if (!Intrinsics.areEqual(this.msg, catVal.msg)) {
                return false;
            }
            return this.required == catVal.required;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R&\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000RN\u0010\u000f\u001aB\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00010\u0001\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00010\u0001 \u0011* \u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00010\u0001\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/mapdb/DB$Companion;", "", "()V", "NAMED_SERIALIZATION_HEADER", "", "getNAMED_SERIALIZATION_HEADER", "()I", "NAME_CATALOG_SERIALIZER", "Lorg/mapdb/Serializer;", "Ljava/util/SortedMap;", "", "getNAME_CATALOG_SERIALIZER", "()Lorg/mapdb/Serializer;", "shutdownHookInstalled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "shutdownHooks", "", "kotlin.jvm.PlatformType", "", "addShutdownHook", "", "ref", "mapdb"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Serializer<SortedMap<String, String>> getNAME_CATALOG_SERIALIZER() {
            return NAME_CATALOG_SERIALIZER;
        }

        protected final int getNAMED_SERIALIZATION_HEADER() {
            return NAMED_SERIALIZATION_HEADER;
        }

        protected final void addShutdownHook(@NotNull Object ref) {
            Intrinsics.checkNotNullParameter(ref, "ref");
            if (shutdownHookInstalled.compareAndSet(false, true)) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        Collection $this$toTypedArray$iv = DB.access$getShutdownHooks$cp().keySet();
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        for (Object o : thisCollection$iv.toArray(new Object[0])) {
                            try {
                                Object a = o;
                                if (a instanceof Reference) {
                                    a = ((Reference)a).get();
                                }
                                if (!(a instanceof DB)) continue;
                                ((DB)a).close();
                            }
                            catch (Throwable e) {
                                Utils.INSTANCE.getLOG().log(Level.SEVERE, "DB.close() thrown exception in shutdown hook.", e);
                            }
                        }
                    }
                });
            }
            shutdownHooks.put(ref, ref);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u0003BD\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012#\b\u0002\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u0007\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\f\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u0014\u0010;\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J(\u0010<\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0>H\u0014J\u0014\u0010?\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u001a\u0010@\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010A\u001a\u00020\u0019J\"\u0010@\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010A\u001a\u00020\u00192\u0006\u0010B\u001a\u00020CJ\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u001a\u0010D\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010A\u001a\u00020\u0019J\"\u0010D\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010A\u001a\u00020\u00192\u0006\u0010B\u001a\u00020CJ\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u001a\u0010E\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010A\u001a\u00020\u0019J\"\u0010E\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010A\u001a\u00020\u00192\u0006\u0010B\u001a\u00020CJ\u001a\u0010F\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010G\u001a\u00020\u0016J\u001c\u0010H\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010I\u001a\u0004\u0018\u00010\u001bJ\u001a\u0010J\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010K\u001a\u00020\u0019J\u001a\u0010L\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010M\u001a\u00020\u0019J(\u0010N\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0014\u0010O\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010 J\u001a\u0010P\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010Q\u001a\u00020\u0019J\u001a\u0010R\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010R\u001a\u00020\rJ&\u0010S\u001a\u000e\u0012\u0004\u0012\u0002HT\u0012\u0004\u0012\u00028\u00010\u0000\"\u0004\b\u0002\u0010T2\f\u0010S\u001a\b\u0012\u0004\u0012\u0002HT0&J*\u0010U\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010V\u001a\u00020\r2\u0006\u0010W\u001a\u00020\r2\u0006\u0010X\u001a\u00020\rJ&\u0010Y\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0012\u0010Z\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010*J\u0014\u0010[\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J(\u0010\\\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0>H\u0014J\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u0012\u0010^\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J5\u0010_\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002!\u0010_\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u000e\u0012\b\b\u0007\u0012\u0004\b\b(0\u0012\u0004\u0012\u00028\u00010\fJ&\u0010`\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002HT0\u0000\"\u0004\b\u0002\u0010T2\f\u0010`\u001a\b\u0012\u0004\u0012\u0002HT0&J\b\u0010a\u001a\u00020bH\u0014R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010$R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010*0)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R/\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u0007\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R-\u0010/\u001a!\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u000e\u0012\b\b\u0007\u0012\u0004\b\b(0\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00028\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u00020\bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00107\u00a8\u0006c"}, d2={"Lorg/mapdb/DB$HashMapMaker;", "K", "V", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/HTreeMap;", "db", "Lorg/mapdb/DB;", "name", "", "hasValues", "", "_storeFactory", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "segment", "Lorg/mapdb/Store;", "(Lorg/mapdb/DB;Ljava/lang/String;ZLkotlin/jvm/functions/Function1;)V", "_concShift", "_counterEnable", "_dirShift", "_expireCompactThreshold", "", "Ljava/lang/Double;", "_expireCreateTTL", "", "_expireExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "_expireExecutorPeriod", "_expireGetTTL", "_expireMaxSize", "_expireOverflow", "", "_expireStoreSize", "_expireUpdateTTL", "_hashSeed", "Ljava/lang/Integer;", "_keySerializer", "Lorg/mapdb/Serializer;", "_levels", "_modListeners", "", "Lorg/mapdb/MapModificationListener;", "_removeCollapsesIndexTree", "get_storeFactory", "()Lkotlin/jvm/functions/Function1;", "_valueInline", "_valueLoader", "key", "_valueSerializer", "getDb", "()Lorg/mapdb/DB;", "getHasValues", "()Z", "getName", "()Ljava/lang/String;", "type", "getType", "counterEnable", "create", "create2", "catalog", "Ljava/util/SortedMap;", "createOrOpen", "expireAfterCreate", "ttl", "unit", "Ljava/util/concurrent/TimeUnit;", "expireAfterGet", "expireAfterUpdate", "expireCompactThreshold", "freeFraction", "expireExecutor", "executor", "expireExecutorPeriod", "period", "expireMaxSize", "maxSize", "expireOverflow", "overflowMap", "expireStoreSize", "storeSize", "hashSeed", "keySerializer", "A", "layout", "concurrency", "dirSize", "levels", "modificationListener", "listener", "open", "open2", "removeCollapsesIndexTreeDisable", "valueInline", "valueLoader", "valueSerializer", "verify", "", "mapdb"})
    @SourceDebugExtension(value={"SMAP\nDB.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DB.kt\norg/mapdb/DB$HashMapMaker\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1878:1\n37#2,2:1879\n37#2,2:1889\n1549#3:1881\n1620#3,3:1882\n1549#3:1885\n1620#3,3:1886\n1549#3:1891\n1620#3,3:1892\n*S KotlinDebug\n*F\n+ 1 DB.kt\norg/mapdb/DB$HashMapMaker\n*L\n862#1:1879,2\n950#1:1889,2\n884#1:1881\n884#1:1882,3\n888#1:1885\n888#1:1886,3\n903#1:1891\n903#1:1892,3\n*E\n"})
    public static final class HashMapMaker<K, V>
    extends Maker<HTreeMap<K, V>> {
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        private final boolean hasValues;
        @NotNull
        private final Function1<Integer, Store> _storeFactory;
        @NotNull
        private final String type;
        @NotNull
        private Serializer<K> _keySerializer;
        @NotNull
        private Serializer<V> _valueSerializer;
        private boolean _valueInline;
        private int _concShift;
        private int _dirShift;
        private int _levels;
        @Nullable
        private Integer _hashSeed;
        private long _expireCreateTTL;
        private long _expireUpdateTTL;
        private long _expireGetTTL;
        @Nullable
        private ScheduledExecutorService _expireExecutor;
        private long _expireExecutorPeriod;
        private long _expireMaxSize;
        private long _expireStoreSize;
        @Nullable
        private Double _expireCompactThreshold;
        private boolean _counterEnable;
        @Nullable
        private Function1<? super K, ? extends V> _valueLoader;
        @NotNull
        private List<MapModificationListener<K, V>> _modListeners;
        @Nullable
        private Map<K, V> _expireOverflow;
        private boolean _removeCollapsesIndexTree;

        public HashMapMaker(@NotNull DB db, @NotNull String name, boolean hasValues, @NotNull Function1<? super Integer, ? extends Store> _storeFactory) {
            Intrinsics.checkNotNullParameter(db, "db");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(_storeFactory, "_storeFactory");
            this.db = db;
            this.name = name;
            this.hasValues = hasValues;
            this._storeFactory = _storeFactory;
            this.type = "HashMap";
            GroupSerializerObjectArray<Object> groupSerializerObjectArray = this.getDb().getDefaultSerializer();
            Intrinsics.checkNotNull(groupSerializerObjectArray, "null cannot be cast to non-null type org.mapdb.Serializer<K of org.mapdb.DB.HashMapMaker>");
            this._keySerializer = groupSerializerObjectArray;
            GroupSerializerObjectArray<Object> groupSerializerObjectArray2 = this.getDb().getDefaultSerializer();
            Intrinsics.checkNotNull(groupSerializerObjectArray2, "null cannot be cast to non-null type org.mapdb.Serializer<V of org.mapdb.DB.HashMapMaker>");
            this._valueSerializer = groupSerializerObjectArray2;
            this._concShift = 3;
            this._dirShift = 7;
            this._levels = 4;
            this._expireExecutorPeriod = 10000L;
            this._modListeners = new ArrayList();
            this._removeCollapsesIndexTree = true;
        }

        public /* synthetic */ HashMapMaker(final DB dB, String string, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                function1 = new Function1<Integer, Store>(){

                    @Override
                    @NotNull
                    public final Store invoke(int i) {
                        return dB.store;
                    }
                };
            }
            this(dB, string, bl, function1);
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        protected final boolean getHasValues() {
            return this.hasValues;
        }

        @NotNull
        protected final Function1<Integer, Store> get_storeFactory() {
            return this._storeFactory;
        }

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @NotNull
        public final <A> HashMapMaker<A, V> keySerializer(@NotNull Serializer<A> keySerializer) {
            Intrinsics.checkNotNullParameter(keySerializer, "keySerializer");
            this._keySerializer = keySerializer;
            Intrinsics.checkNotNull(this, "null cannot be cast to non-null type org.mapdb.DB.HashMapMaker<A of org.mapdb.DB.HashMapMaker.keySerializer, V of org.mapdb.DB.HashMapMaker>");
            return this;
        }

        @NotNull
        public final <A> HashMapMaker<K, A> valueSerializer(@NotNull Serializer<A> valueSerializer) {
            Intrinsics.checkNotNullParameter(valueSerializer, "valueSerializer");
            this._valueSerializer = valueSerializer;
            Intrinsics.checkNotNull(this, "null cannot be cast to non-null type org.mapdb.DB.HashMapMaker<K of org.mapdb.DB.HashMapMaker, A of org.mapdb.DB.HashMapMaker.valueSerializer>");
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> valueInline() {
            this._valueInline = true;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> removeCollapsesIndexTreeDisable() {
            this._removeCollapsesIndexTree = false;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> hashSeed(int hashSeed) {
            this._hashSeed = hashSeed;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> layout(int concurrency, int dirSize, int levels) {
            this._concShift = HashMapMaker.layout$toShift(concurrency);
            this._dirShift = HashMapMaker.layout$toShift(dirSize);
            this._levels = levels;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterCreate() {
            return this.expireAfterCreate(-1L);
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterCreate(long ttl) {
            this._expireCreateTTL = ttl;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterCreate(long ttl, @NotNull TimeUnit unit) {
            Intrinsics.checkNotNullParameter((Object)unit, "unit");
            return this.expireAfterCreate(unit.toMillis(ttl));
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterUpdate() {
            return this.expireAfterUpdate(-1L);
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterUpdate(long ttl) {
            this._expireUpdateTTL = ttl;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterUpdate(long ttl, @NotNull TimeUnit unit) {
            Intrinsics.checkNotNullParameter((Object)unit, "unit");
            return this.expireAfterUpdate(unit.toMillis(ttl));
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterGet() {
            return this.expireAfterGet(-1L);
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterGet(long ttl) {
            this._expireGetTTL = ttl;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterGet(long ttl, @NotNull TimeUnit unit) {
            Intrinsics.checkNotNullParameter((Object)unit, "unit");
            return this.expireAfterGet(unit.toMillis(ttl));
        }

        @NotNull
        public final HashMapMaker<K, V> expireExecutor(@Nullable ScheduledExecutorService executor) {
            this._expireExecutor = executor;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> expireExecutorPeriod(long period) {
            this._expireExecutorPeriod = period;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> expireCompactThreshold(double freeFraction) {
            this._expireCompactThreshold = freeFraction;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> expireMaxSize(long maxSize) {
            this._expireMaxSize = maxSize;
            return this.counterEnable();
        }

        @NotNull
        public final HashMapMaker<K, V> expireStoreSize(long storeSize) {
            this._expireStoreSize = storeSize;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> expireOverflow(@NotNull Map<K, V> overflowMap) {
            Intrinsics.checkNotNullParameter(overflowMap, "overflowMap");
            this._expireOverflow = overflowMap;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> valueLoader(@NotNull Function1<? super K, ? extends V> valueLoader) {
            Intrinsics.checkNotNullParameter(valueLoader, "valueLoader");
            this._valueLoader = valueLoader;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> counterEnable() {
            this._counterEnable = true;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> modificationListener(@NotNull MapModificationListener<K, V> listener) {
            block1: {
                Intrinsics.checkNotNullParameter(listener, "listener");
                if (this._modListeners == null) {
                    this._modListeners = new ArrayList();
                }
                List<MapModificationListener<K, V>> list = this._modListeners;
                if (list == null) break block1;
                list.add(listener);
            }
            return this;
        }

        @Override
        protected void verify() {
            if (this._expireOverflow != null && this._valueLoader != null) {
                throw new DBException.WrongConfiguration("ExpireOverflow and ValueLoader can not be used at the same time");
            }
            Map<K, V> expireOverflow = this._expireOverflow;
            if (expireOverflow != null) {
                this._valueLoader = new Function1<K, V>(expireOverflow){
                    final /* synthetic */ Map<K, V> $expireOverflow;
                    {
                        this.$expireOverflow = $expireOverflow;
                        super(1);
                    }

                    @Nullable
                    public final V invoke(K key) {
                        return this.$expireOverflow.get(key);
                    }
                };
                MapModificationListener<Object, Object> listener = (arg_0, arg_1, arg_2, arg_3) -> HashMapMaker.verify$lambda$1(expireOverflow, this, arg_0, arg_1, arg_2, arg_3);
                this._modListeners.add(listener);
            }
            if (this._expireExecutor != null) {
                Set<ExecutorService> set = this.getDb().getExecutors();
                ScheduledExecutorService scheduledExecutorService = this._expireExecutor;
                Intrinsics.checkNotNull(scheduledExecutorService);
                set.add(scheduledExecutorService);
            }
        }

        @Override
        @NotNull
        protected HTreeMap<K, V> create2(@NotNull SortedMap<String, String> catalog) {
            MapModificationListener[] mapModificationListenerArray;
            int n;
            QueueLong[] queueLongArray;
            QueueLong[] expireUpdateQueues;
            QueueLong[] queueLongArray2;
            QueueLong[] expireCreateQueues;
            QueueLong[] queueLongArray3;
            long[] lArray;
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            int segmentCount = 1 << this._concShift;
            Integer n2 = this._hashSeed;
            int hashSeed = n2 != null ? n2.intValue() : new SecureRandom().nextInt();
            int n3 = 0;
            Store[] storeArray = new Store[segmentCount];
            Function1<Integer, Store> function1 = this._storeFactory;
            while (n3 < segmentCount) {
                int n4 = n3++;
                storeArray[n4] = function1.invoke(n4);
            }
            Store[] stores = storeArray;
            long[] rootRecids = new long[segmentCount];
            String rootRecidsStr = "";
            for (int i = 0; i < segmentCount; ++i) {
                long rootRecid;
                Store store = stores[i];
                long[] lArray2 = IndexTreeListJava.dirEmpty();
                Serializer<long[]> serializer = IndexTreeListJava.dirSer;
                Intrinsics.checkNotNullExpressionValue(serializer, "dirSer");
                rootRecids[i] = rootRecid = store.put(lArray2, serializer);
                rootRecidsStr = rootRecidsStr + (i == 0 ? "" : ",") + rootRecid;
            }
            this.getDb().nameCatalogPutClass(catalog, this.getName() + (this.hasValues ? Keys.INSTANCE.getKeySerializer() : Keys.INSTANCE.getSerializer()), this._keySerializer);
            if (this.hasValues) {
                this.getDb().nameCatalogPutClass(catalog, this.getName() + Keys.INSTANCE.getValueSerializer(), this._valueSerializer);
            }
            if (this.hasValues) {
                ((Map)catalog).put(this.getName() + Keys.INSTANCE.getValueInline(), String.valueOf(this._valueInline));
            }
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getRootRecids(), rootRecidsStr);
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getHashSeed(), String.valueOf(hashSeed));
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getConcShift(), String.valueOf(this._concShift));
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getDirShift(), String.valueOf(this._dirShift));
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getLevels(), String.valueOf(this._levels));
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getRemoveCollapsesIndexTree(), String.valueOf(this._removeCollapsesIndexTree));
            if (this._counterEnable) {
                int n5 = 0;
                long[] lArray3 = new long[segmentCount];
                while (n5 < segmentCount) {
                    int n6 = n5++;
                    Store store = stores[n6];
                    Long l = 0L;
                    GroupSerializer<Long> groupSerializer = Serializer.LONG_PACKED;
                    Intrinsics.checkNotNullExpressionValue(groupSerializer, "LONG_PACKED");
                    lArray3[n6] = store.put(l, (Serializer)groupSerializer);
                }
                long[] cr = lArray3;
                ((Map)catalog).put(this.getName() + Keys.INSTANCE.getCounterRecids(), LongArrayList.newListWith(Arrays.copyOf(cr, cr.length)).makeString("", ",", ""));
                lArray = cr;
            } else {
                ((Map)catalog).put(this.getName() + Keys.INSTANCE.getCounterRecids(), "");
                lArray = null;
            }
            long[] counterRecids = lArray;
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getExpireCreateTTL(), String.valueOf(this._expireCreateTTL));
            if (this.hasValues) {
                ((Map)catalog).put(this.getName() + Keys.INSTANCE.getExpireUpdateTTL(), String.valueOf(this._expireUpdateTTL));
            }
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getExpireGetTTL(), String.valueOf(this._expireGetTTL));
            LongArrayList createQ = new LongArrayList();
            LongArrayList updateQ = new LongArrayList();
            LongArrayList getQ = new LongArrayList();
            if (this._expireCreateTTL == 0L) {
                queueLongArray3 = null;
            } else {
                int n7 = 0;
                QueueLong[] queueLongArray4 = new QueueLong[segmentCount];
                while (n7 < segmentCount) {
                    int n8 = n7++;
                    queueLongArray4[n8] = HashMapMaker.create2$emptyLongQueue(stores, n8, createQ);
                }
                queueLongArray3 = expireCreateQueues = queueLongArray4;
            }
            if (this._expireUpdateTTL == 0L) {
                queueLongArray2 = null;
            } else {
                int n9 = 0;
                QueueLong[] queueLongArray5 = new QueueLong[segmentCount];
                while (n9 < segmentCount) {
                    int n10 = n9++;
                    queueLongArray5[n10] = HashMapMaker.create2$emptyLongQueue(stores, n10, updateQ);
                }
                queueLongArray2 = expireUpdateQueues = queueLongArray5;
            }
            if (this._expireGetTTL == 0L) {
                queueLongArray = null;
            } else {
                int n11 = 0;
                QueueLong[] queueLongArray6 = new QueueLong[segmentCount];
                while (n11 < segmentCount) {
                    n = n11++;
                    queueLongArray6[n] = HashMapMaker.create2$emptyLongQueue(stores, n, getQ);
                }
                queueLongArray = queueLongArray6;
            }
            QueueLong[] expireGetQueues = queueLongArray;
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getExpireCreateQueue(), createQ.makeString("", ",", ""));
            if (this.hasValues) {
                ((Map)catalog).put(this.getName() + Keys.INSTANCE.getExpireUpdateQueue(), updateQ.makeString("", ",", ""));
            }
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getExpireGetQueue(), getQ.makeString("", ",", ""));
            int n12 = 0;
            n = 1 << this._concShift;
            MutableLongLongMap[] mutableLongLongMapArray = new MutableLongLongMap[n];
            while (n12 < n) {
                int n13 = n12++;
                mutableLongLongMapArray[n13] = new IndexTreeLongLongMap(stores[n13], rootRecids[n13], this._dirShift, this._levels, this._removeCollapsesIndexTree);
            }
            MutableLongLongMap[] indexTrees = mutableLongLongMapArray;
            boolean bl = this.getDb().isThreadSafe();
            if (this._modListeners.isEmpty()) {
                mapModificationListenerArray = null;
            } else {
                Collection $this$toTypedArray$iv = this._modListeners;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                mapModificationListenerArray = thisCollection$iv.toArray(new MapModificationListener[0]);
            }
            return new HTreeMap<K, V>(this._keySerializer, this._valueSerializer, this._valueInline, this._concShift, this._dirShift, this._levels, stores, indexTrees, hashSeed, counterRecids, this._expireCreateTTL, this._expireUpdateTTL, this._expireGetTTL, this._expireMaxSize, this._expireStoreSize, expireCreateQueues, expireUpdateQueues, expireGetQueues, this._expireExecutor, this._expireExecutorPeriod, this._expireCompactThreshold, bl, this._valueLoader, mapModificationListenerArray, this.getDb(), this.hasValues);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected HTreeMap<K, V> open2(@NotNull SortedMap<String, String> catalog) {
            MapModificationListener[] mapModificationListenerArray;
            void var12_19;
            long l;
            long[] lArray;
            Collection collection;
            String[] $this$mapTo$iv$iv;
            boolean bl;
            Serializer<V> serializer;
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getConcShift());
            Intrinsics.checkNotNull(v);
            this._concShift = Integer.parseInt((String)v);
            int segmentCount = 1 << this._concShift;
            int n = 0;
            Store[] storeArray = new Store[segmentCount];
            String[] stringArray = this._storeFactory;
            while (n < segmentCount) {
                int n2 = n++;
                storeArray[n2] = stringArray.invoke(n2);
            }
            Store[] stores = storeArray;
            Serializer<K> serializer2 = (Serializer<K>)this.getDb().nameCatalogGetClass(catalog, this.getName() + (this.hasValues ? Keys.INSTANCE.getKeySerializer() : Keys.INSTANCE.getSerializer()));
            if (serializer2 == null) {
                serializer2 = this._keySerializer = this._keySerializer;
            }
            if (!this.hasValues) {
                GroupSerializer<Boolean> groupSerializer = BTreeMap.Companion.getNO_VAL_SERIALIZER$mapdb();
                Intrinsics.checkNotNull(groupSerializer, "null cannot be cast to non-null type org.mapdb.Serializer<V of org.mapdb.DB.HashMapMaker>");
                serializer = (Serializer<V>)groupSerializer;
            } else {
                serializer = (Serializer<V>)this.getDb().nameCatalogGetClass(catalog, this.getName() + Keys.INSTANCE.getValueSerializer());
                if (serializer == null) {
                    serializer = this._valueSerializer = this._valueSerializer;
                }
            }
            if (this.hasValues) {
                Object v2 = catalog.get(this.getName() + Keys.INSTANCE.getValueInline());
                Intrinsics.checkNotNull(v2);
                bl = Boolean.parseBoolean((String)v2);
            } else {
                bl = true;
            }
            this._valueInline = bl;
            Object v3 = catalog.get(this.getName() + Keys.INSTANCE.getHashSeed());
            Intrinsics.checkNotNull(v3);
            int hashSeed = Integer.parseInt((String)v3);
            Object v4 = catalog.get(this.getName() + Keys.INSTANCE.getRootRecids());
            Intrinsics.checkNotNull(v4);
            stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)v4, stringArray, false, 0, 6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo22 = false;
            for (Object t : $this$mapTo$iv$iv) {
                Iterator it;
                String string = (String)t;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(Long.parseLong((String)((Object)it)));
            }
            long[] rootRecids = CollectionsKt.toLongArray((List)destination$iv$iv);
            Object v5 = catalog.get(this.getName() + Keys.INSTANCE.getCounterRecids());
            Intrinsics.checkNotNull(v5);
            String counterRecidsStr = (String)v5;
            if (Intrinsics.areEqual("", counterRecidsStr)) {
                lArray = null;
            } else {
                void $this$mapTo$iv$iv2;
                $this$mapTo$iv$iv = new String[]{","};
                Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)counterRecidsStr, $this$mapTo$iv$iv, false, 0, 6, null);
                boolean $i$f$map2 = false;
                Iterable $i$f$mapTo22 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean bl2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    String n3 = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(Long.parseLong((String)it));
                }
                lArray = CollectionsKt.toLongArray((List)destination$iv$iv2);
            }
            long[] counterRecids = lArray;
            Object v6 = catalog.get(this.getName() + Keys.INSTANCE.getDirShift());
            Intrinsics.checkNotNull(v6);
            this._dirShift = Integer.parseInt((String)v6);
            Object v7 = catalog.get(this.getName() + Keys.INSTANCE.getLevels());
            Intrinsics.checkNotNull(v7);
            this._levels = Integer.parseInt((String)v7);
            Object v8 = catalog.get(this.getName() + Keys.INSTANCE.getRemoveCollapsesIndexTree());
            Intrinsics.checkNotNull(v8);
            this._removeCollapsesIndexTree = Boolean.parseBoolean((String)v8);
            Object v9 = catalog.get(this.getName() + Keys.INSTANCE.getExpireCreateTTL());
            Intrinsics.checkNotNull(v9);
            this._expireCreateTTL = Long.parseLong((String)v9);
            if (this.hasValues) {
                Object v10 = catalog.get(this.getName() + Keys.INSTANCE.getExpireUpdateTTL());
                Intrinsics.checkNotNull(v10);
                l = Long.parseLong((String)v10);
            } else {
                l = 0L;
            }
            this._expireUpdateTTL = l;
            Object v11 = catalog.get(this.getName() + Keys.INSTANCE.getExpireGetTTL());
            Intrinsics.checkNotNull(v11);
            this._expireGetTTL = Long.parseLong((String)v11);
            QueueLong[] expireCreateQueues = HashMapMaker.open2$queues(catalog, segmentCount, stores, this._expireCreateTTL, this.getName() + Keys.INSTANCE.getExpireCreateQueue());
            QueueLong[] expireUpdateQueues = HashMapMaker.open2$queues(catalog, segmentCount, stores, this._expireUpdateTTL, this.getName() + Keys.INSTANCE.getExpireUpdateQueue());
            QueueLong[] expireGetQueues = HashMapMaker.open2$queues(catalog, segmentCount, stores, this._expireGetTTL, this.getName() + Keys.INSTANCE.getExpireGetQueue());
            boolean bl3 = false;
            int it = 1 << this._concShift;
            MutableLongLongMap[] item$iv$iv = new MutableLongLongMap[it];
            while (var12_19 < it) {
                void var15_28 = var12_19++;
                item$iv$iv[var15_28] = new IndexTreeLongLongMap(stores[var15_28], rootRecids[var15_28], this._dirShift, this._levels, this._removeCollapsesIndexTree);
            }
            MutableLongLongMap[] indexTrees = item$iv$iv;
            boolean bl4 = this.getDb().isThreadSafe();
            if (this._modListeners.isEmpty()) {
                mapModificationListenerArray = null;
            } else {
                Collection collection2 = this._modListeners;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = collection2;
                mapModificationListenerArray = thisCollection$iv.toArray(new MapModificationListener[0]);
            }
            return new HTreeMap<K, V>(this._keySerializer, this._valueSerializer, this._valueInline, this._concShift, this._dirShift, this._levels, stores, indexTrees, hashSeed, counterRecids, this._expireCreateTTL, this._expireUpdateTTL, this._expireGetTTL, this._expireMaxSize, this._expireStoreSize, expireCreateQueues, expireUpdateQueues, expireGetQueues, this._expireExecutor, this._expireExecutorPeriod, this._expireCompactThreshold, bl4, this._valueLoader, mapModificationListenerArray, this.getDb(), this.hasValues);
        }

        @Override
        @NotNull
        public HTreeMap<K, V> create() {
            return (HTreeMap)super.create();
        }

        @Override
        @NotNull
        public HTreeMap<K, V> createOrOpen() {
            return (HTreeMap)super.createOrOpen();
        }

        @Override
        @NotNull
        public HTreeMap<K, V> open() {
            return (HTreeMap)super.open();
        }

        private static final int layout$toShift(int value) {
            return 31 - Integer.numberOfLeadingZeros(DataIO.nextPowTwo(Math.max(1, value)));
        }

        private static final String verify$lambda$1$lambda$0() {
            return "Key also removed from overflow Map, but value in overflow Map differs";
        }

        private static final void verify$lambda$1(Map $expireOverflow, HashMapMaker this$0, Object key, Object oldVal, Object newVal, boolean triggered) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Intrinsics.checkNotNullParameter(key, "key");
            if (!triggered && newVal == null && oldVal != null) {
                Object oldVal2 = $expireOverflow.remove(key);
                if (oldVal2 != null && this$0._valueSerializer.equals(oldVal, oldVal2)) {
                    Utils.INSTANCE.getLOG().warning(HashMapMaker::verify$lambda$1$lambda$0);
                }
            } else if (triggered && newVal == null) {
                $expireOverflow.put(key, oldVal);
            }
        }

        private static final QueueLong create2$emptyLongQueue(Store[] stores, int segment, LongArrayList qq) {
            Store store = stores[segment];
            long q = store.put(null, QueueLong.Node.SERIALIZER.INSTANCE);
            Long l = q;
            GroupSerializer<Long> groupSerializer = Serializer.RECID;
            Intrinsics.checkNotNullExpressionValue(groupSerializer, "RECID");
            long tailRecid = store.put(l, (Serializer)groupSerializer);
            Long l2 = q;
            GroupSerializer<Long> groupSerializer2 = Serializer.RECID;
            Intrinsics.checkNotNullExpressionValue(groupSerializer2, "RECID");
            long headRecid = store.put(l2, (Serializer)groupSerializer2);
            Long l3 = 0L;
            GroupSerializer<Long> groupSerializer3 = Serializer.RECID;
            Intrinsics.checkNotNullExpressionValue(groupSerializer3, "RECID");
            long headPrevRecid = store.put(l3, (Serializer)groupSerializer3);
            qq.add(tailRecid);
            qq.add(headRecid);
            qq.add(headPrevRecid);
            return new QueueLong(store, tailRecid, headRecid, headPrevRecid);
        }

        /*
         * WARNING - void declaration
         */
        private static final QueueLong[] open2$queues(SortedMap<String, String> $catalog, int segmentCount, Store[] stores, long ttl, String queuesName) {
            void $this$mapTo$iv$iv;
            if (ttl == 0L) {
                return null;
            }
            Object v = $catalog.get(queuesName);
            Intrinsics.checkNotNull(v);
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)v, stringArray, false, 0, 6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Long.parseLong((String)it));
            }
            long[] rr = CollectionsKt.toLongArray((List)destination$iv$iv);
            if (rr.length != segmentCount * 3) {
                throw new DBException.WrongConfiguration("wrong segment count");
            }
            int n = 0;
            QueueLong[] queueLongArray = new QueueLong[segmentCount];
            while (n < segmentCount) {
                int n2 = n++;
                queueLongArray[n2] = new QueueLong(stores[n2], rr[n2 * 3 + 0], rr[n2 * 3 + 1], rr[n2 * 3 + 2]);
            }
            return queueLongArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B:\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012#\b\u0002\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\u0006\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\t\u00a2\u0006\u0002\u0010\u000eJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001fH\u0014J\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010!\u001a\u00020\"J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010!\u001a\u00020\"J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\u0010*\u001a\u0004\u0018\u00010+J\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010-\u001a\u00020\"J\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010/\u001a\u00020\"J\u0014\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00101\u001a\u00020\"J\u0014\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00102\u001a\u00020\nJ$\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\nJ\"\u00107\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001fH\u0014J\f\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J \u00109\u001a\b\u0012\u0004\u0012\u0002H:0\u0000\"\u0004\b\u0001\u0010:2\f\u00109\u001a\b\u0012\u0004\u0012\u0002H:0;J\b\u0010<\u001a\u00020=H\u0014R/\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\u0006\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006>"}, d2={"Lorg/mapdb/DB$HashSetMaker;", "E", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/HTreeMap$KeySet;", "db", "Lorg/mapdb/DB;", "name", "", "_storeFactory", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "segment", "Lorg/mapdb/Store;", "(Lorg/mapdb/DB;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "get_storeFactory", "()Lkotlin/jvm/functions/Function1;", "getDb", "()Lorg/mapdb/DB;", "maker", "Lorg/mapdb/DB$HashMapMaker;", "", "getMaker", "()Lorg/mapdb/DB$HashMapMaker;", "getName", "()Ljava/lang/String;", "type", "getType", "counterEnable", "create2", "catalog", "Ljava/util/SortedMap;", "expireAfterCreate", "ttl", "", "unit", "Ljava/util/concurrent/TimeUnit;", "expireAfterGet", "expireCompactThreshold", "freeFraction", "", "expireExecutor", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "expireExecutorPeriod", "period", "expireMaxSize", "maxSize", "expireStoreSize", "storeSize", "hashSeed", "layout", "concurrency", "dirSize", "levels", "open2", "removeCollapsesIndexTreeDisable", "serializer", "A", "Lorg/mapdb/Serializer;", "verify", "", "mapdb"})
    public static final class HashSetMaker<E>
    extends Maker<HTreeMap.KeySet<E>> {
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        @NotNull
        private final Function1<Integer, Store> _storeFactory;
        @NotNull
        private final HashMapMaker<E, Object> maker;
        @NotNull
        private final String type;

        public HashSetMaker(@NotNull DB db, @NotNull String name, @NotNull Function1<? super Integer, ? extends Store> _storeFactory) {
            Intrinsics.checkNotNullParameter(db, "db");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(_storeFactory, "_storeFactory");
            this.db = db;
            this.name = name;
            this._storeFactory = _storeFactory;
            this.maker = new HashMapMaker(this.getDb(), this.getName(), false, this._storeFactory);
            this.maker.valueSerializer(BTreeMap.Companion.getNO_VAL_SERIALIZER$mapdb()).valueInline();
            this.type = "HashSet";
        }

        public /* synthetic */ HashSetMaker(final DB dB, String string, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                function1 = new Function1<Integer, Store>(){

                    @Override
                    @NotNull
                    public final Store invoke(int i) {
                        return dB.store;
                    }
                };
            }
            this(dB, string, function1);
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        @NotNull
        protected final Function1<Integer, Store> get_storeFactory() {
            return this._storeFactory;
        }

        @NotNull
        protected final HashMapMaker<E, Object> getMaker() {
            return this.maker;
        }

        @NotNull
        public final <A> HashSetMaker<A> serializer(@NotNull Serializer<A> serializer) {
            Intrinsics.checkNotNullParameter(serializer, "serializer");
            this.maker.keySerializer(serializer);
            Intrinsics.checkNotNull(this, "null cannot be cast to non-null type org.mapdb.DB.HashSetMaker<A of org.mapdb.DB.HashSetMaker.serializer>");
            return this;
        }

        @NotNull
        public final HashSetMaker<E> counterEnable() {
            this.maker.counterEnable();
            return this;
        }

        @NotNull
        public final HashSetMaker<E> removeCollapsesIndexTreeDisable() {
            this.maker.removeCollapsesIndexTreeDisable();
            return this;
        }

        @NotNull
        public final HashSetMaker<E> hashSeed(int hashSeed) {
            this.maker.hashSeed(hashSeed);
            return this;
        }

        @NotNull
        public final HashSetMaker<E> layout(int concurrency, int dirSize, int levels) {
            this.maker.layout(concurrency, dirSize, levels);
            return this;
        }

        @NotNull
        public final HashSetMaker<E> expireAfterCreate() {
            return this.expireAfterCreate(-1L);
        }

        @NotNull
        public final HashSetMaker<E> expireAfterCreate(long ttl) {
            this.maker.expireAfterCreate(ttl);
            return this;
        }

        @NotNull
        public final HashSetMaker<E> expireAfterCreate(long ttl, @NotNull TimeUnit unit) {
            Intrinsics.checkNotNullParameter((Object)unit, "unit");
            return this.expireAfterCreate(unit.toMillis(ttl));
        }

        @NotNull
        public final HashSetMaker<E> expireAfterGet() {
            return this.expireAfterGet(-1L);
        }

        @NotNull
        public final HashSetMaker<E> expireAfterGet(long ttl) {
            this.maker.expireAfterGet(ttl);
            return this;
        }

        @NotNull
        public final HashSetMaker<E> expireAfterGet(long ttl, @NotNull TimeUnit unit) {
            Intrinsics.checkNotNullParameter((Object)unit, "unit");
            return this.expireAfterGet(unit.toMillis(ttl));
        }

        @NotNull
        public final HashSetMaker<E> expireExecutor(@Nullable ScheduledExecutorService executor) {
            this.maker.expireExecutor(executor);
            return this;
        }

        @NotNull
        public final HashSetMaker<E> expireExecutorPeriod(long period) {
            this.maker.expireExecutorPeriod(period);
            return this;
        }

        @NotNull
        public final HashSetMaker<E> expireCompactThreshold(double freeFraction) {
            this.maker.expireCompactThreshold(freeFraction);
            return this;
        }

        @NotNull
        public final HashSetMaker<E> expireMaxSize(long maxSize) {
            this.maker.expireMaxSize(maxSize);
            return this;
        }

        @NotNull
        public final HashSetMaker<E> expireStoreSize(long storeSize) {
            this.maker.expireStoreSize(storeSize);
            return this;
        }

        @Override
        protected void verify() {
            this.maker.%%%verify$mapdb();
        }

        @Override
        @NotNull
        protected HTreeMap.KeySet<E> open2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            Set set = ((HTreeMap)this.maker.%%%open2$mapdb(catalog)).keySet();
            Intrinsics.checkNotNull(set, "null cannot be cast to non-null type org.mapdb.HTreeMap.KeySet<E of org.mapdb.DB.HashSetMaker>");
            return (HTreeMap.KeySet)set;
        }

        @Override
        @NotNull
        protected HTreeMap.KeySet<E> create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            Set set = ((HTreeMap)this.maker.%%%create2$mapdb(catalog)).keySet();
            Intrinsics.checkNotNull(set, "null cannot be cast to non-null type org.mapdb.HTreeMap.KeySet<E of org.mapdb.DB.HashSetMaker>");
            return (HTreeMap.KeySet)set;
        }

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001aH\u0014J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fJ\"\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001aH\u0014J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006 "}, d2={"Lorg/mapdb/DB$IndexTreeListMaker;", "E", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/IndexTreeList;", "db", "Lorg/mapdb/DB;", "name", "", "serializer", "Lorg/mapdb/Serializer;", "(Lorg/mapdb/DB;Ljava/lang/String;Lorg/mapdb/Serializer;)V", "_dirShift", "", "_levels", "_removeCollapsesIndexTree", "", "getDb", "()Lorg/mapdb/DB;", "getName", "()Ljava/lang/String;", "getSerializer", "()Lorg/mapdb/Serializer;", "type", "getType", "create2", "catalog", "Ljava/util/SortedMap;", "layout", "dirSize", "levels", "open2", "removeCollapsesIndexTreeDisable", "mapdb"})
    public static final class IndexTreeListMaker<E>
    extends Maker<IndexTreeList<E>> {
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        @NotNull
        private final Serializer<E> serializer;
        private int _dirShift;
        private int _levels;
        private boolean _removeCollapsesIndexTree;
        @NotNull
        private final String type;

        public IndexTreeListMaker(@NotNull DB db, @NotNull String name, @NotNull Serializer<E> serializer) {
            Intrinsics.checkNotNullParameter(db, "db");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(serializer, "serializer");
            this.db = db;
            this.name = name;
            this.serializer = serializer;
            this._dirShift = 7;
            this._levels = 4;
            this._removeCollapsesIndexTree = true;
            this.type = "IndexTreeList";
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        @NotNull
        protected final Serializer<E> getSerializer() {
            return this.serializer;
        }

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @NotNull
        public final IndexTreeListMaker<E> layout(int dirSize, int levels) {
            this._dirShift = IndexTreeListMaker.layout$toShift(dirSize);
            this._levels = levels;
            return this;
        }

        @NotNull
        public final IndexTreeListMaker<E> removeCollapsesIndexTreeDisable() {
            this._removeCollapsesIndexTree = false;
            return this;
        }

        @Override
        @NotNull
        protected IndexTreeList<E> create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getDirShift(), String.valueOf(this._dirShift));
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getLevels(), String.valueOf(this._levels));
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getRemoveCollapsesIndexTree(), String.valueOf(this._removeCollapsesIndexTree));
            this.getDb().nameCatalogPutClass(catalog, this.getName() + Keys.INSTANCE.getSerializer(), this.serializer);
            Store store = this.getDb().store;
            Long l = 0L;
            GroupSerializer<Long> groupSerializer = Serializer.LONG_PACKED;
            Intrinsics.checkNotNullExpressionValue(groupSerializer, "LONG_PACKED");
            long counterRecid = store.put(l, (Serializer)groupSerializer);
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getCounterRecid(), String.valueOf(counterRecid));
            Store store2 = this.getDb().store;
            long[] lArray = IndexTreeListJava.dirEmpty();
            Serializer<long[]> serializer = IndexTreeListJava.dirSer;
            Intrinsics.checkNotNullExpressionValue(serializer, "dirSer");
            long rootRecid = store2.put(lArray, serializer);
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getRootRecid(), String.valueOf(rootRecid));
            IndexTreeLongLongMap map = new IndexTreeLongLongMap(this.getDb().store, rootRecid, this._dirShift, this._levels, this._removeCollapsesIndexTree);
            Store store3 = this.getDb().store;
            Serializer<E> serializer2 = this.serializer;
            boolean bl = this.getDb().isThreadSafe();
            return new IndexTreeList<E>(store3, serializer2, map, counterRecid, bl);
        }

        @Override
        @NotNull
        protected IndexTreeList<E> open2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            Store store = this.getDb().store;
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getDirShift());
            Intrinsics.checkNotNull(v);
            int n = Integer.parseInt((String)v);
            Object v2 = catalog.get(this.getName() + Keys.INSTANCE.getLevels());
            Intrinsics.checkNotNull(v2);
            int bl = Integer.parseInt((String)v2);
            Object v3 = catalog.get(this.getName() + Keys.INSTANCE.getRootRecid());
            Intrinsics.checkNotNull(v3);
            long l = Long.parseLong((String)v3);
            Object v4 = catalog.get(this.getName() + Keys.INSTANCE.getRemoveCollapsesIndexTree());
            Intrinsics.checkNotNull(v4);
            boolean bl2 = Boolean.parseBoolean((String)v4);
            IndexTreeLongLongMap map = new IndexTreeLongLongMap(store, l, n, bl, bl2);
            store = this.getDb().store;
            Serializer<E> serializer = (Serializer<E>)this.getDb().nameCatalogGetClass(catalog, this.getName() + Keys.INSTANCE.getSerializer());
            if (serializer == null) {
                serializer = this.serializer;
            }
            Serializer<E> serializer2 = serializer;
            boolean bl3 = this.getDb().isThreadSafe();
            Object v5 = catalog.get(this.getName() + Keys.INSTANCE.getCounterRecid());
            Intrinsics.checkNotNull(v5);
            l = Long.parseLong((String)v5);
            return new IndexTreeList<E>(store, serializer2, map, l, bl3);
        }

        private static final int layout$toShift(int value) {
            return 31 - Integer.numberOfLeadingZeros(DataIO.nextPowTwo(Math.max(1, value)));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0013\u001a\u00020\u00022\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0015H\u0014J\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tJ\u001c\u0010\u0019\u001a\u00020\u00022\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0015H\u0014J\u0006\u0010\u001a\u001a\u00020\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/mapdb/DB$IndexTreeLongLongMapMaker;", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/IndexTreeLongLongMap;", "db", "Lorg/mapdb/DB;", "name", "", "(Lorg/mapdb/DB;Ljava/lang/String;)V", "_dirShift", "", "_levels", "_removeCollapsesIndexTree", "", "getDb", "()Lorg/mapdb/DB;", "getName", "()Ljava/lang/String;", "type", "getType", "create2", "catalog", "Ljava/util/SortedMap;", "layout", "dirSize", "levels", "open2", "removeCollapsesIndexTreeDisable", "mapdb"})
    public static final class IndexTreeLongLongMapMaker
    extends Maker<IndexTreeLongLongMap> {
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        private int _dirShift;
        private int _levels;
        private boolean _removeCollapsesIndexTree;
        @NotNull
        private final String type;

        public IndexTreeLongLongMapMaker(@NotNull DB db, @NotNull String name) {
            Intrinsics.checkNotNullParameter(db, "db");
            Intrinsics.checkNotNullParameter(name, "name");
            this.db = db;
            this.name = name;
            this._dirShift = 7;
            this._levels = 4;
            this._removeCollapsesIndexTree = true;
            this.type = "IndexTreeLongLongMap";
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @NotNull
        public final IndexTreeLongLongMapMaker layout(int dirSize, int levels) {
            this._dirShift = IndexTreeLongLongMapMaker.layout$toShift(dirSize);
            this._levels = levels;
            return this;
        }

        @NotNull
        public final IndexTreeLongLongMapMaker removeCollapsesIndexTreeDisable() {
            this._removeCollapsesIndexTree = false;
            return this;
        }

        @Override
        @NotNull
        protected IndexTreeLongLongMap create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getDirShift(), String.valueOf(this._dirShift));
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getLevels(), String.valueOf(this._levels));
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getRemoveCollapsesIndexTree(), String.valueOf(this._removeCollapsesIndexTree));
            Store store = this.getDb().store;
            long[] lArray = IndexTreeListJava.dirEmpty();
            Serializer<long[]> serializer = IndexTreeListJava.dirSer;
            Intrinsics.checkNotNullExpressionValue(serializer, "dirSer");
            long rootRecid = store.put(lArray, serializer);
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getRootRecid(), String.valueOf(rootRecid));
            return new IndexTreeLongLongMap(this.getDb().store, rootRecid, this._dirShift, this._levels, this._removeCollapsesIndexTree);
        }

        @Override
        @NotNull
        protected IndexTreeLongLongMap open2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            Store store = this.getDb().store;
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getDirShift());
            Intrinsics.checkNotNull(v);
            int n = Integer.parseInt((String)v);
            Object v2 = catalog.get(this.getName() + Keys.INSTANCE.getLevels());
            Intrinsics.checkNotNull(v2);
            int n2 = Integer.parseInt((String)v2);
            Object v3 = catalog.get(this.getName() + Keys.INSTANCE.getRootRecid());
            Intrinsics.checkNotNull(v3);
            long l = Long.parseLong((String)v3);
            Object v4 = catalog.get(this.getName() + Keys.INSTANCE.getRemoveCollapsesIndexTree());
            Intrinsics.checkNotNull(v4);
            boolean bl = Boolean.parseBoolean((String)v4);
            return new IndexTreeLongLongMap(store, l, n, n2, bl);
        }

        private static final int layout$toShift(int value) {
            return 31 - Integer.numberOfLeadingZeros(DataIO.nextPowTwo(Math.max(1, value)));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b3\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0014\u0010\u001b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0014\u0010\u001d\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0014\u0010\u001f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0014\u0010!\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0014\u0010#\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u0014\u0010%\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u0014\u0010'\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0006R\u0014\u0010)\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0006R\u0014\u0010+\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0006R\u0014\u0010-\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0006R\u0014\u0010/\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0006R\u0014\u00101\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0006R\u0014\u00103\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0006R\u0014\u00105\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0006\u00a8\u00067"}, d2={"Lorg/mapdb/DB$Keys;", "", "()V", "concShift", "", "getConcShift", "()Ljava/lang/String;", "counterRecid", "getCounterRecid", "counterRecids", "getCounterRecids", "dirShift", "getDirShift", "expireCreateQueue", "getExpireCreateQueue", "expireCreateTTL", "getExpireCreateTTL", "expireGetQueue", "getExpireGetQueue", "expireGetTTL", "getExpireGetTTL", "expireUpdateQueue", "getExpireUpdateQueue", "expireUpdateTTL", "getExpireUpdateTTL", "hashSeed", "getHashSeed", "keySerializer", "getKeySerializer", "levels", "getLevels", "maxNodeSize", "getMaxNodeSize", "recid", "getRecid", "removeCollapsesIndexTree", "getRemoveCollapsesIndexTree", "rootRecid", "getRootRecid", "rootRecidRecid", "getRootRecidRecid", "rootRecids", "getRootRecids", "segmentRecids", "getSegmentRecids", "serializer", "getSerializer", "size", "getSize", "type", "getType", "valueInline", "getValueInline", "valueSerializer", "getValueSerializer", "mapdb"})
    public static final class Keys {
        @NotNull
        public static final Keys INSTANCE = new Keys();
        @NotNull
        private static final String type = "#type";
        @NotNull
        private static final String keySerializer = "#keySerializer";
        @NotNull
        private static final String valueSerializer = "#valueSerializer";
        @NotNull
        private static final String serializer = "#serializer";
        @NotNull
        private static final String valueInline = "#valueInline";
        @NotNull
        private static final String counterRecids = "#counterRecids";
        @NotNull
        private static final String hashSeed = "#hashSeed";
        @NotNull
        private static final String segmentRecids = "#segmentRecids";
        @NotNull
        private static final String expireCreateTTL = "#expireCreateTTL";
        @NotNull
        private static final String expireUpdateTTL = "#expireUpdateTTL";
        @NotNull
        private static final String expireGetTTL = "#expireGetTTL";
        @NotNull
        private static final String expireCreateQueue = "#expireCreateQueue";
        @NotNull
        private static final String expireUpdateQueue = "#expireUpdateQueue";
        @NotNull
        private static final String expireGetQueue = "#expireGetQueue";
        @NotNull
        private static final String rootRecids = "#rootRecids";
        @NotNull
        private static final String rootRecid = "#rootRecid";
        @NotNull
        private static final String concShift = "#concShift";
        @NotNull
        private static final String dirShift = "#dirShift";
        @NotNull
        private static final String levels = "#levels";
        @NotNull
        private static final String removeCollapsesIndexTree = "#removeCollapsesIndexTree";
        @NotNull
        private static final String rootRecidRecid = "#rootRecidRecid";
        @NotNull
        private static final String counterRecid = "#counterRecid";
        @NotNull
        private static final String maxNodeSize = "#maxNodeSize";
        @NotNull
        private static final String size = "#size";
        @NotNull
        private static final String recid = "#recid";

        private Keys() {
        }

        @NotNull
        public final String getType() {
            return type;
        }

        @NotNull
        public final String getKeySerializer() {
            return keySerializer;
        }

        @NotNull
        public final String getValueSerializer() {
            return valueSerializer;
        }

        @NotNull
        public final String getSerializer() {
            return serializer;
        }

        @NotNull
        public final String getValueInline() {
            return valueInline;
        }

        @NotNull
        public final String getCounterRecids() {
            return counterRecids;
        }

        @NotNull
        public final String getHashSeed() {
            return hashSeed;
        }

        @NotNull
        public final String getSegmentRecids() {
            return segmentRecids;
        }

        @NotNull
        public final String getExpireCreateTTL() {
            return expireCreateTTL;
        }

        @NotNull
        public final String getExpireUpdateTTL() {
            return expireUpdateTTL;
        }

        @NotNull
        public final String getExpireGetTTL() {
            return expireGetTTL;
        }

        @NotNull
        public final String getExpireCreateQueue() {
            return expireCreateQueue;
        }

        @NotNull
        public final String getExpireUpdateQueue() {
            return expireUpdateQueue;
        }

        @NotNull
        public final String getExpireGetQueue() {
            return expireGetQueue;
        }

        @NotNull
        public final String getRootRecids() {
            return rootRecids;
        }

        @NotNull
        public final String getRootRecid() {
            return rootRecid;
        }

        @NotNull
        public final String getConcShift() {
            return concShift;
        }

        @NotNull
        public final String getDirShift() {
            return dirShift;
        }

        @NotNull
        public final String getLevels() {
            return levels;
        }

        @NotNull
        public final String getRemoveCollapsesIndexTree() {
            return removeCollapsesIndexTree;
        }

        @NotNull
        public final String getRootRecidRecid() {
            return rootRecidRecid;
        }

        @NotNull
        public final String getCounterRecid() {
            return counterRecid;
        }

        @NotNull
        public final String getMaxNodeSize() {
            return maxNodeSize;
        }

        @NotNull
        public final String getSize() {
            return size;
        }

        @NotNull
        public final String getRecid() {
            return recid;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J#\u0010\u000e\u001a\u00028\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0010H\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J#\u0010\u0013\u001a\u00028\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0010H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0012J\r\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\r\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J!\u0010\u001a\u001a\u00028\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0010H$\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\r\u0010\u001c\u001a\u00028\u0000H\u0017\u00a2\u0006\u0002\u0010\u0019J\u0017\u0010\u001d\u001a\u00028\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u001eH\u0004\u00a2\u0006\u0002\u0010\u001fJ\r\u0010 \u001a\u00028\u0000H\u0017\u00a2\u0006\u0002\u0010\u0019J\r\u0010!\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J!\u0010\"\u001a\u00028\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0010H$\u00a2\u0006\u0002\u0010\u0012J\b\u0010#\u001a\u00020\u0016H\u0014R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006$"}, d2={"Lorg/mapdb/DB$Maker;", "E", "", "()V", "db", "Lorg/mapdb/DB;", "getDb", "()Lorg/mapdb/DB;", "name", "", "getName", "()Ljava/lang/String;", "type", "getType", "%%%create2", "catalog", "Ljava/util/SortedMap;", "%%%create2$mapdb", "(Ljava/util/SortedMap;)Ljava/lang/Object;", "%%%open2", "%%%open2$mapdb", "%%%verify", "", "%%%verify$mapdb", "create", "()Ljava/lang/Object;", "create2", "createOrOpen", "make", "make2", "", "(Ljava/lang/Boolean;)Ljava/lang/Object;", "makeOrGet", "open", "open2", "verify", "mapdb"})
    @SourceDebugExtension(value={"SMAP\nDB.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DB.kt\norg/mapdb/DB$Maker\n+ 2 Utils.kt\norg/mapdb/Utils\n*L\n1#1,1878:1\n88#2,7:1879\n*S KotlinDebug\n*F\n+ 1 DB.kt\norg/mapdb/DB$Maker\n*L\n1372#1:1879,7\n*E\n"})
    public static abstract class Maker<E> {
        public E create() {
            return this.make2(true);
        }

        @Deprecated(message="use createOrOpen() method", replaceWith=@ReplaceWith(expression="createOrOpen()", imports={}))
        public E make() {
            return this.make2(null);
        }

        @Deprecated(message="use createOrOpen() method", replaceWith=@ReplaceWith(expression="createOrOpen()", imports={}))
        public E makeOrGet() {
            return this.make2(null);
        }

        public E createOrOpen() {
            return this.make2(null);
        }

        public E open() {
            return this.make2(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final E make2(@Nullable Boolean create) {
            Utils utils = Utils.INSTANCE;
            ReadWriteLock lock$iv = this.getDb().getLock();
            boolean $i$f$lockWrite = false;
            if (lock$iv != null) {
                lock$iv.writeLock().lock();
            }
            try {
                boolean bl = false;
                this.getDb().checkNotClosed();
                this.verify();
                SortedMap<String, String> catalog = this.getDb().nameCatalogLoad();
                String typeFromDb = (String)catalog.get(this.getName() + Keys.INSTANCE.getType());
                if (create != null) {
                    if (typeFromDb != null && create.booleanValue()) {
                        throw new DBException.WrongConfiguration("Named record already exists: " + this.getName());
                    }
                    if (!create.booleanValue() && typeFromDb == null) {
                        throw new DBException.WrongConfiguration("Named record does not exist: " + this.getName());
                    }
                }
                if (typeFromDb != null && !Intrinsics.areEqual(this.getType(), typeFromDb)) {
                    throw new DBException.WrongConfiguration("Wrong type for named record '" + this.getName() + "'. Expected '" + this.getType() + "', but catalog has '" + typeFromDb + '\'');
                }
                Object ref = this.getDb().getNamesInstanciated().getIfPresent(this.getName());
                if (ref != null) {
                    Object object = ref;
                    return (E)object;
                }
                if (typeFromDb != null) {
                    E ret = this.open2(catalog);
                    this.getDb().getNamesInstanciated().put(this.getName(), ret);
                    E e = ret;
                    return e;
                }
                if (this.getDb().store.isReadOnly()) {
                    throw new UnsupportedOperationException("Read-only");
                }
                catalog.put(this.getName() + Keys.INSTANCE.getType(), this.getType());
                E ret = this.create2(catalog);
                this.getDb().nameCatalogSaveLocked(catalog);
                this.getDb().getNamesInstanciated().put(this.getName(), ret);
                E e = ret;
                return e;
            }
            finally {
                if (lock$iv != null) {
                    lock$iv.writeLock().unlock();
                }
            }
        }

        protected void verify() {
        }

        protected abstract E create2(@NotNull SortedMap<String, String> var1);

        protected abstract E open2(@NotNull SortedMap<String, String> var1);

        public final void %%%verify$mapdb() {
            this.verify();
        }

        public final E %%%create2$mapdb(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            return this.create2(catalog);
        }

        public final E %%%open2$mapdb(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            return this.open2(catalog);
        }

        @NotNull
        protected abstract DB getDb();

        @NotNull
        protected abstract String getName();

        @NotNull
        protected abstract String getType();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u0003B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J(\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0*H\u0014J,\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0018\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010.0-J\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000100J\u0014\u00101\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J&\u00102\u001a\u000e\u0012\u0004\u0012\u0002H3\u0012\u0004\u0012\u00028\u00010\u0000\"\u0004\b\u0002\u001032\f\u00102\u001a\b\u0012\u0004\u0012\u0002H30\u0011J\u001a\u00104\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u00105\u001a\u00020\u0013J&\u00106\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0016J\u0014\u00108\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J(\u00109\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0*H\u0014J&\u0010:\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H30\u0000\"\u0004\b\u0002\u001032\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H30\u0011J\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0016\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0018\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u0019\u001a\u001f\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u001b\u0012\b\b\u0007\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#\u00a8\u0006<"}, d2={"Lorg/mapdb/DB$TreeMapMaker;", "K", "V", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/BTreeMap;", "db", "Lorg/mapdb/DB;", "name", "", "hasValues", "", "(Lorg/mapdb/DB;Ljava/lang/String;Z)V", "_counterEnable", "_counterRecid", "", "Ljava/lang/Long;", "_keySerializer", "Lorg/mapdb/serializer/GroupSerializer;", "_maxNodeSize", "", "_modListeners", "", "Lorg/mapdb/MapModificationListener;", "_rootRecidRecid", "_valueInline", "_valueLoader", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "key", "_valueSerializer", "getDb", "()Lorg/mapdb/DB;", "getHasValues", "()Z", "getName", "()Ljava/lang/String;", "type", "getType", "counterEnable", "create", "create2", "catalog", "Ljava/util/SortedMap;", "createFrom", "iterator", "", "Lkotlin/Pair;", "createFromSink", "Lorg/mapdb/DB$TreeMapSink;", "createOrOpen", "keySerializer", "A", "maxNodeSize", "size", "modificationListener", "listener", "open", "open2", "valueSerializer", "valuesOutsideNodesEnable", "mapdb"})
    @SourceDebugExtension(value={"SMAP\nDB.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DB.kt\norg/mapdb/DB$TreeMapMaker\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1878:1\n37#2,2:1879\n37#2,2:1881\n*S KotlinDebug\n*F\n+ 1 DB.kt\norg/mapdb/DB$TreeMapMaker\n*L\n1119#1:1879,2\n1161#1:1881,2\n*E\n"})
    public static final class TreeMapMaker<K, V>
    extends Maker<BTreeMap<K, V>> {
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        private final boolean hasValues;
        @NotNull
        private final String type;
        @NotNull
        private GroupSerializer<K> _keySerializer;
        @NotNull
        private GroupSerializer<V> _valueSerializer;
        private int _maxNodeSize;
        private boolean _counterEnable;
        @Nullable
        private Function1<? super K, ? extends V> _valueLoader;
        @Nullable
        private List<MapModificationListener<K, V>> _modListeners;
        @Nullable
        private Long _rootRecidRecid;
        @Nullable
        private Long _counterRecid;
        private boolean _valueInline;

        public TreeMapMaker(@NotNull DB db, @NotNull String name, boolean hasValues) {
            Intrinsics.checkNotNullParameter(db, "db");
            Intrinsics.checkNotNullParameter(name, "name");
            this.db = db;
            this.name = name;
            this.hasValues = hasValues;
            this.type = "TreeMap";
            GroupSerializerObjectArray<Object> groupSerializerObjectArray = this.getDb().getDefaultSerializer();
            Intrinsics.checkNotNull(groupSerializerObjectArray, "null cannot be cast to non-null type org.mapdb.serializer.GroupSerializer<K of org.mapdb.DB.TreeMapMaker>");
            this._keySerializer = groupSerializerObjectArray;
            GroupSerializer groupSerializer = this.hasValues ? (GroupSerializer)this.getDb().getDefaultSerializer() : BTreeMap.Companion.getNO_VAL_SERIALIZER$mapdb();
            Intrinsics.checkNotNull(groupSerializer, "null cannot be cast to non-null type org.mapdb.serializer.GroupSerializer<V of org.mapdb.DB.TreeMapMaker>");
            this._valueSerializer = groupSerializer;
            this._maxNodeSize = 32;
            this._valueInline = true;
        }

        public /* synthetic */ TreeMapMaker(DB dB, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(dB, string, bl);
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        protected final boolean getHasValues() {
            return this.hasValues;
        }

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @NotNull
        public final <A> TreeMapMaker<A, V> keySerializer(@NotNull GroupSerializer<A> keySerializer) {
            Intrinsics.checkNotNullParameter(keySerializer, "keySerializer");
            this._keySerializer = keySerializer;
            Intrinsics.checkNotNull(this, "null cannot be cast to non-null type org.mapdb.DB.TreeMapMaker<A of org.mapdb.DB.TreeMapMaker.keySerializer, V of org.mapdb.DB.TreeMapMaker>");
            return this;
        }

        @NotNull
        public final <A> TreeMapMaker<K, A> valueSerializer(@NotNull GroupSerializer<A> valueSerializer) {
            Intrinsics.checkNotNullParameter(valueSerializer, "valueSerializer");
            if (!this.hasValues) {
                throw new DBException.WrongConfiguration("Set, no vals");
            }
            this._valueSerializer = valueSerializer;
            Intrinsics.checkNotNull(this, "null cannot be cast to non-null type org.mapdb.DB.TreeMapMaker<K of org.mapdb.DB.TreeMapMaker, A of org.mapdb.DB.TreeMapMaker.valueSerializer>");
            return this;
        }

        @NotNull
        public final TreeMapMaker<K, V> maxNodeSize(int size) {
            this._maxNodeSize = size;
            return this;
        }

        @NotNull
        public final TreeMapMaker<K, V> counterEnable() {
            this._counterEnable = true;
            return this;
        }

        @NotNull
        public final TreeMapMaker<K, V> valuesOutsideNodesEnable() {
            this._valueInline = false;
            return this;
        }

        @NotNull
        public final TreeMapMaker<K, V> modificationListener(@NotNull MapModificationListener<K, V> listener) {
            block1: {
                Intrinsics.checkNotNullParameter(listener, "listener");
                if (this._modListeners == null) {
                    this._modListeners = new ArrayList();
                }
                List<MapModificationListener<K, V>> list = this._modListeners;
                if (list == null) break block1;
                list.add(listener);
            }
            return this;
        }

        @NotNull
        public final BTreeMap<K, V> createFrom(@NotNull Iterator<? extends Pair<? extends K, ? extends V>> iterator2) {
            Intrinsics.checkNotNullParameter(iterator2, "iterator");
            TreeMapSink<K, V> consumer = this.createFromSink();
            while (iterator2.hasNext()) {
                consumer.put(iterator2.next());
            }
            return (BTreeMap)consumer.create();
        }

        @NotNull
        public final TreeMapSink<K, V> createFromSink() {
            Pump pump = Pump.INSTANCE;
            Store store = this.getDb().store;
            GroupSerializer<K> groupSerializer = this._keySerializer;
            GroupSerializer<V> groupSerializer2 = this._valueSerializer;
            int n = this._maxNodeSize * 3 / 4;
            int n2 = this._maxNodeSize * 3 / 4;
            boolean bl = this._valueInline;
            Pump.Sink consumer = Pump.treeMap$default(pump, store, groupSerializer, groupSerializer2, null, n2, n, false, bl, 72, null);
            return new TreeMapSink<K, V>(consumer, this){
                final /* synthetic */ Pump.Sink<Pair<K, V>, Unit> $consumer;
                final /* synthetic */ TreeMapMaker<K, V> this$0;
                {
                    this.$consumer = $consumer;
                    this.this$0 = $receiver;
                }

                public void put(@NotNull Pair<? extends K, ? extends V> e) {
                    Intrinsics.checkNotNullParameter(e, "e");
                    this.$consumer.put(e);
                }

                @NotNull
                public BTreeMap<K, V> create() {
                    Long l;
                    this.$consumer.create();
                    Long l2 = this.$consumer.getRootRecidRecid$mapdb();
                    if (l2 == null) {
                        throw new AssertionError();
                    }
                    TreeMapMaker.access$set_rootRecidRecid$p(this.this$0, l2);
                    if (TreeMapMaker.access$get_counterEnable$p(this.this$0)) {
                        Store store = DB.access$getStore$p(this.this$0.getDb());
                        Long l3 = this.$consumer.getCounter$mapdb();
                        GroupSerializer<Long> groupSerializer = Serializer.LONG;
                        Intrinsics.checkNotNullExpressionValue(groupSerializer, "LONG");
                        l = store.put(l3, (Serializer)groupSerializer);
                    } else {
                        l = 0L;
                    }
                    TreeMapMaker.access$set_counterRecid$p(this.this$0, l);
                    return (BTreeMap)this.this$0.make2(true);
                }
            };
        }

        @Override
        @NotNull
        protected BTreeMap<K, V> create2(@NotNull SortedMap<String, String> catalog) {
            MapModificationListener[] mapModificationListenerArray;
            long l;
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            this.getDb().nameCatalogPutClass(catalog, this.getName() + (this.hasValues ? Keys.INSTANCE.getKeySerializer() : Keys.INSTANCE.getSerializer()), this._keySerializer);
            if (this.hasValues) {
                this.getDb().nameCatalogPutClass(catalog, this.getName() + Keys.INSTANCE.getValueSerializer(), this._valueSerializer);
                ((Map)catalog).put(this.getName() + Keys.INSTANCE.getValueInline(), String.valueOf(this._valueInline));
            }
            Long l2 = this._rootRecidRecid;
            long rootRecidRecid2 = l2 != null ? l2.longValue() : BTreeMap.Companion.putEmptyRoot$mapdb(this.getDb().store, this._keySerializer, this._valueSerializer);
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getRootRecidRecid(), String.valueOf(rootRecidRecid2));
            if (this._counterEnable) {
                Long l3 = this._counterRecid;
                if (l3 != null) {
                    l = l3;
                } else {
                    Store store = this.getDb().store;
                    Long l4 = 0L;
                    GroupSerializer<Long> groupSerializer = Serializer.LONG;
                    Intrinsics.checkNotNullExpressionValue(groupSerializer, "LONG");
                    l = store.put(l4, (Serializer)groupSerializer);
                }
            } else {
                l = 0L;
            }
            long counterRecid2 = l;
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getCounterRecid(), String.valueOf(counterRecid2));
            ((Map)catalog).put(this.getName() + Keys.INSTANCE.getMaxNodeSize(), String.valueOf(this._maxNodeSize));
            GroupSerializer<K> groupSerializer = this._keySerializer;
            GroupSerializer<V> groupSerializer2 = this._valueSerializer;
            Store store = this.getDb().store;
            int n = this._maxNodeSize;
            GroupSerializer<K> groupSerializer3 = this._keySerializer;
            boolean bl = this.getDb().isThreadSafe();
            boolean bl2 = this.hasValues;
            boolean bl3 = this._valueInline;
            if (this._modListeners == null) {
                mapModificationListenerArray = null;
            } else {
                List<MapModificationListener<K, V>> list = this._modListeners;
                Intrinsics.checkNotNull(list);
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                mapModificationListenerArray = thisCollection$iv.toArray(new MapModificationListener[0]);
            }
            MapModificationListener[] mapModificationListenerArray2 = mapModificationListenerArray;
            return new BTreeMap<K, V>(groupSerializer, groupSerializer2, rootRecidRecid2, store, bl3, n, (Comparator)groupSerializer3, bl, counterRecid2, bl2, mapModificationListenerArray2);
        }

        @Override
        @NotNull
        protected BTreeMap<K, V> open2(@NotNull SortedMap<String, String> catalog) {
            MapModificationListener[] mapModificationListenerArray;
            String string;
            GroupSerializer<V> groupSerializer;
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getRootRecidRecid());
            Intrinsics.checkNotNull(v);
            long rootRecidRecid2 = Long.parseLong((String)v);
            GroupSerializer<K> groupSerializer2 = (GroupSerializer<K>)this.getDb().nameCatalogGetClass(catalog, this.getName() + (this.hasValues ? Keys.INSTANCE.getKeySerializer() : Keys.INSTANCE.getSerializer()));
            if (groupSerializer2 == null) {
                groupSerializer2 = this._keySerializer = this._keySerializer;
            }
            if (!this.hasValues) {
                GroupSerializer<V> groupSerializer3 = BTreeMap.Companion.getNO_VAL_SERIALIZER$mapdb();
                groupSerializer = groupSerializer3;
                Intrinsics.checkNotNull(groupSerializer3, "null cannot be cast to non-null type org.mapdb.serializer.GroupSerializer<V of org.mapdb.DB.TreeMapMaker>");
            } else {
                groupSerializer = (GroupSerializer<V>)this.getDb().nameCatalogGetClass(catalog, this.getName() + Keys.INSTANCE.getValueSerializer());
                if (groupSerializer == null) {
                    groupSerializer = this._valueSerializer;
                }
            }
            this._valueSerializer = groupSerializer;
            Object v2 = catalog.get(this.getName() + Keys.INSTANCE.getCounterRecid());
            Intrinsics.checkNotNull(v2);
            long counterRecid2 = Long.parseLong((String)v2);
            Object v3 = catalog.get(this.getName() + Keys.INSTANCE.getMaxNodeSize());
            Intrinsics.checkNotNull(v3);
            this._maxNodeSize = Integer.parseInt((String)v3);
            if (!Intrinsics.areEqual(this._valueSerializer, BTreeMap.Companion.getNO_VAL_SERIALIZER$mapdb()) && catalog.get(this.getName() + Keys.INSTANCE.getValueInline()) == null && !this.getDb().store.isReadOnly()) {
                ((Map)catalog).put(this.getName() + Keys.INSTANCE.getValueInline(), "true");
                this.getDb().nameCatalogSaveLocked(catalog);
            }
            if ((string = (String)catalog.get(this.getName() + Keys.INSTANCE.getValueInline())) == null) {
                string = "true";
            }
            this._valueInline = Boolean.parseBoolean(string);
            GroupSerializer<K> groupSerializer4 = this._keySerializer;
            GroupSerializer<V> groupSerializer5 = this._valueSerializer;
            Store store = this.getDb().store;
            int n = this._maxNodeSize;
            GroupSerializer<K> groupSerializer6 = this._keySerializer;
            boolean bl = this.getDb().isThreadSafe();
            boolean bl2 = this.hasValues;
            boolean bl3 = this._valueInline;
            if (this._modListeners == null) {
                mapModificationListenerArray = null;
            } else {
                List<MapModificationListener<K, V>> list = this._modListeners;
                Intrinsics.checkNotNull(list);
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                mapModificationListenerArray = thisCollection$iv.toArray(new MapModificationListener[0]);
            }
            MapModificationListener[] mapModificationListenerArray2 = mapModificationListenerArray;
            return new BTreeMap<K, V>(groupSerializer4, groupSerializer5, rootRecidRecid2, store, bl3, n, (Comparator)groupSerializer6, bl, counterRecid2, bl2, mapModificationListenerArray2);
        }

        @Override
        @NotNull
        public BTreeMap<K, V> create() {
            return (BTreeMap)super.create();
        }

        @Override
        @NotNull
        public BTreeMap<K, V> createOrOpen() {
            return (BTreeMap)super.createOrOpen();
        }

        @Override
        @NotNull
        public BTreeMap<K, V> open() {
            return (BTreeMap)super.open();
        }

        public static final /* synthetic */ void access$set_rootRecidRecid$p(TreeMapMaker $this, Long l) {
            $this._rootRecidRecid = l;
        }

        public static final /* synthetic */ void access$set_counterRecid$p(TreeMapMaker $this, Long l) {
            $this._counterRecid = l;
        }

        public static final /* synthetic */ boolean access$get_counterEnable$p(TreeMapMaker $this) {
            return $this._counterEnable;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00050\u0003B\u0005\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\f\u001a\u00020\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/mapdb/DB$TreeMapSink;", "K", "V", "Lorg/mapdb/Pump$Sink;", "Lkotlin/Pair;", "Lorg/mapdb/BTreeMap;", "()V", "put", "", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "putAll", "map", "Ljava/util/SortedMap;", "mapdb"})
    @SourceDebugExtension(value={"SMAP\nDB.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DB.kt\norg/mapdb/DB$TreeMapSink\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1878:1\n215#2,2:1879\n*S KotlinDebug\n*F\n+ 1 DB.kt\norg/mapdb/DB$TreeMapSink\n*L\n982#1:1879,2\n*E\n"})
    public static abstract class TreeMapSink<K, V>
    extends Pump.Sink<Pair<? extends K, ? extends V>, BTreeMap<K, V>> {
        public final void put(K key, V value) {
            this.put(new Pair<K, V>(key, value));
        }

        public final void putAll(@NotNull SortedMap<K, V> map) {
            Intrinsics.checkNotNullParameter(map, "map");
            Map $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry e = element$iv = iterator2.next();
                boolean bl = false;
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017H\u0014J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017H\u0014J \u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0000\"\u0004\b\u0001\u0010\u001d2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001eJ\b\u0010\u001f\u001a\u00020 H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006!"}, d2={"Lorg/mapdb/DB$TreeSetMaker;", "E", "Lorg/mapdb/DB$Maker;", "Ljava/util/NavigableSet;", "db", "Lorg/mapdb/DB;", "name", "", "(Lorg/mapdb/DB;Ljava/lang/String;)V", "getDb", "()Lorg/mapdb/DB;", "maker", "Lorg/mapdb/DB$TreeMapMaker;", "", "getMaker", "()Lorg/mapdb/DB$TreeMapMaker;", "getName", "()Ljava/lang/String;", "type", "getType", "counterEnable", "create2", "catalog", "Ljava/util/SortedMap;", "maxNodeSize", "size", "", "open2", "serializer", "A", "Lorg/mapdb/serializer/GroupSerializer;", "verify", "", "mapdb"})
    public static final class TreeSetMaker<E>
    extends Maker<NavigableSet<E>> {
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        @NotNull
        private final TreeMapMaker<E, Object> maker;
        @NotNull
        private final String type;

        public TreeSetMaker(@NotNull DB db, @NotNull String name) {
            Intrinsics.checkNotNullParameter(db, "db");
            Intrinsics.checkNotNullParameter(name, "name");
            this.db = db;
            this.name = name;
            this.maker = new TreeMapMaker(this.getDb(), this.getName(), false);
            this.type = "TreeSet";
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        @NotNull
        protected final TreeMapMaker<E, Object> getMaker() {
            return this.maker;
        }

        @NotNull
        public final <A> TreeSetMaker<A> serializer(@NotNull GroupSerializer<A> serializer) {
            Intrinsics.checkNotNullParameter(serializer, "serializer");
            this.maker.keySerializer(serializer);
            Intrinsics.checkNotNull(this, "null cannot be cast to non-null type org.mapdb.DB.TreeSetMaker<A of org.mapdb.DB.TreeSetMaker.serializer>");
            return this;
        }

        @NotNull
        public final TreeSetMaker<E> maxNodeSize(int size) {
            this.maker.maxNodeSize(size);
            return this;
        }

        @NotNull
        public final TreeSetMaker<E> counterEnable() {
            this.maker.counterEnable();
            return this;
        }

        @Override
        protected void verify() {
            this.maker.%%%verify$mapdb();
        }

        @Override
        @NotNull
        protected NavigableSet<E> open2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            Set set = ((BTreeMap)this.maker.%%%open2$mapdb(catalog)).keySet();
            Intrinsics.checkNotNull(set, "null cannot be cast to non-null type java.util.NavigableSet<E of org.mapdb.DB.TreeSetMaker>");
            return (NavigableSet)set;
        }

        @Override
        @NotNull
        protected NavigableSet<E> create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkNotNullParameter(catalog, "catalog");
            Set set = ((BTreeMap)this.maker.%%%create2$mapdb(catalog)).keySet();
            Intrinsics.checkNotNull(set, "null cannot be cast to non-null type java.util.NavigableSet<E of org.mapdb.DB.TreeSetMaker>");
            return (NavigableSet)set;
        }

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }
    }
}

