/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.ComXervLoadContext;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadTask;
import com.deutscheboerse.comxerv.comtrader.entities.TradeSettlement;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeSettlementProcessor;
import com.deutscheboerse.comxerv.comtrader.util.concurrent.SlicedSerialTask;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.Interval;

public abstract class AbstractLoadTradeSettlementsTask
extends LoadTask {
    protected final TradeSettlementProcessor tradeSettlementProcessor = this.getLoadContext().getAppContext().getService(TradeSettlementProcessor.class);

    protected AbstractLoadTradeSettlementsTask(ComXervLoadContext loadContext) {
        super(loadContext);
    }

    protected boolean hasPermissionsForTradeSettlements() {
        return this.getLoadContext().getOwnUser().hasPermissionsForTradeSettlementInfoForTrader();
    }

    protected static class TradeSettlementSlicedTask
    extends SlicedSerialTask<Interval> {
        private final ComXervLoadContext context;
        private final TradeSettlementProcessor tradeSettlementProcessor;

        public TradeSettlementSlicedTask(Collection<Interval> sliceInputs, ComXervLoadContext context, TradeSettlementProcessor tradeSettlementProcessor) {
            super("Load Trade Settlements", sliceInputs);
            this.context = context;
            this.tradeSettlementProcessor = tradeSettlementProcessor;
        }

        @Override
        protected void loadData(Interval sliceInput) {
            List<TradeSettlement> tradeSettlementInfos;
            if (this.context.getConnection() != null && CollectionUtils.isNotEmpty(tradeSettlementInfos = this.context.getConnection().getTradeSettlementInfo(sliceInput.getStart(), sliceInput.getEnd()))) {
                FxUtil.runInFxThread(() -> tradeSettlementInfos.stream().forEach(this.tradeSettlementProcessor::processTradeSettlement));
            }
        }
    }
}

